<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect"
    exclude-result-prefixes="xalan"
    version="1.0"
>

	<xsl:template name="printAreaElement">
		<xsl:param name="shape_element"/>
		<xsl:param name="r"/>
		<xsl:param name = "url"/>
		<xsl:param name = "alt"/>
		<xsl:param name = "showReferencesPopupWhenClickOnShape"/>
		<xsl:param name = "showSubdiagramsPopupWhenClickOnShape"/>
		<xsl:call-template name="printArea">
      <xsl:with-param name="shape_element" select="."/>
      <xsl:with-param name="r" select="$r"/>
      <xsl:with-param name="url" select="$url"/>
      <xsl:with-param name="alt" select="$alt"/>
			<xsl:with-param name = "x" select = "$shape_element/@x * $r"/>
			<xsl:with-param name = "y" select = "$shape_element/@y * $r"/>
			<xsl:with-param name = "x2" select = "$shape_element/@x + ($shape_element/@width * $r)"/>
			<xsl:with-param name = "y2" select = "$shape_element/@y + ($shape_element/@height * $r)"/>
			<xsl:with-param name = "showReferencesPopupWhenClickOnShape" select = "$showReferencesPopupWhenClickOnShape"/>
			<xsl:with-param name = "showSubdiagramsPopupWhenClickOnShape" select = "$showSubdiagramsPopupWhenClickOnShape"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- for printing area on imagemap -->
	<xsl:template name="printArea">
		<xsl:param name="shape_element"/>
		<xsl:param name="r"/>
		<xsl:param name = "url"/>
		<xsl:param name = "alt"/>
		<xsl:param name="x"/>
		<xsl:param name="y"/>
		<xsl:param name = "x2"/>
		<xsl:param name = "y2"/>
		<xsl:param name = "showReferencesPopupWhenClickOnShape" select='false'/>
		<xsl:param name = "showSubdiagramsPopupWhenClickOnShape" select='false'/>
	
		<!-- *************************************** @docContent *************************************** -->
		<xsl:variable name="docContent_string">
			<xsl:if test="string-length($shape_element/@documentaiton_plainText) &gt; 0 and $opt_is_show_documentation_when_hover_over_a_shape = 'true'">
				<xsl:value-of select="$shape_element/@documentation"></xsl:value-of>
			</xsl:if>
		</xsl:variable>
		
		<!-- *************************************** @href *************************************** -->
		<xsl:variable name="href_string">
			<xsl:if test="not($showReferencesPopupWhenClickOnShape = 'true' and (count($shape_element/DiagramElementProperties/ModelsProperty[@name='references']/*) > 0 or count($shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef)>0 or count($shape_element/DiagramElementProperties/DiagramElementRefsProperty[@name='references']/DiagramElementRef)>0))">
				<xsl:if test="not($showSubdiagramsPopupWhenClickOnShape = 'true' and count($shape_element/SubDiagrams/DiagramRef)>0)">
					<xsl:value-of select ="$url"></xsl:value-of>
				</xsl:if>
			</xsl:if>
		</xsl:variable>
		
		<!-- *************************************** onmouseover *************************************** -->
		<!-- REFERENCE OR SUBDIAGRAM-->
		<xsl:variable name="onmouseover_reference_and_subdiagram_string">
			<xsl:if test="count($shape_element/DiagramElementProperties/ModelsProperty[@name='references']/*) > 0 or count($shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef)>0 or count($shape_element/DiagramElementProperties/DiagramElementRefsProperty[@name='references']/DiagramElementRef)>0 or count($shape_element/SubDiagrams/DiagramRef) > 0">
				<!-- file refs -->
				<xsl:variable name="file_refs_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/DiagramElementProperties/ModelsProperty/Model/ModelProperties/StringProperty[@name='type' and @value='File']">
						<xsl:text>'</xsl:text>
						<xsl:choose>
							<xsl:when test="$references_dir_name = '' or count(../StringProperty[@name='url']/@fileValue) = 0">
							  <xsl:variable name="convertedURL">
							    <xsl:call-template name="replaceChars">
							      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
							      <xsl:with-param name="charsIn" select="'\'"/>
							      <xsl:with-param name="charsOut" select="'/'"/>
							    </xsl:call-template>
							  </xsl:variable>
								<xsl:value-of select="concat(../StringProperty[@name='url']/@pathName, '*', $convertedURL)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="realUrl" select="concat('../', $references_dir_name, '/', ../StringProperty[@name='url']/@fileValue)"/>
								<xsl:value-of select="concat(../StringProperty[@name='url']/@pathName, '*', $realUrl)"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>'</xsl:text>
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
				
				<!-- folder refs -->
				<xsl:variable name="folder_refs_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/DiagramElementProperties/ModelsProperty/Model/ModelProperties/StringProperty[@name='type' and @value='Folder']">
						<xsl:text>'</xsl:text>
					  <xsl:variable name="convertedURL">
					    <xsl:call-template name="replaceChars">
					      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
					      <xsl:with-param name="charsIn" select="'\'"/>
					      <xsl:with-param name="charsOut" select="'/'"/>
					    </xsl:call-template>
					  </xsl:variable>
						<xsl:value-of select="concat(../StringProperty[@name='url']/@pathName, '*', $convertedURL)"/>
						<xsl:text>'</xsl:text>
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
				
				<!-- url refs -->
				<xsl:variable name="url_refs_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/DiagramElementProperties/ModelsProperty/Model/ModelProperties/StringProperty[@name='type' and @value='URL']">
						
					  <xsl:variable name="convertedURL">
					    <xsl:call-template name="replaceChars">
					      <xsl:with-param name="s" select="../StringProperty[@name='url']/@value"/>
					      <xsl:with-param name="charsIn" select="'\'"/>
					      <xsl:with-param name="charsOut" select="'/'"/>
					    </xsl:call-template>
					  </xsl:variable>
						
						<xsl:value-of select="'new Array('"/>
						<xsl:text>'</xsl:text>
						<xsl:value-of select="$convertedURL"/>
						<xsl:text>'</xsl:text>						
						<xsl:value-of select="','"/>
						<xsl:text>'</xsl:text>						
						<xsl:value-of select="../StringProperty[@name='name']/@value"/>
						<xsl:text>'</xsl:text>
						<xsl:value-of select="')'"/>
						
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
				
				<!-- diagram refs -->
				<xsl:variable name="diagram_refs_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef">
						<xsl:text>'</xsl:text>
						<xsl:value-of select="concat(@diagramType, '_', @id, '.html', '/', @name, '/', @diagramType)"/>
						<xsl:text>'</xsl:text>
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
	
				<!-- shape refs -->
				<xsl:variable name="shape_refs_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/DiagramElementProperties/DiagramElementRefsProperty/DiagramElementRef">
						<xsl:text>'</xsl:text>
						<xsl:choose>
							<xsl:when test="not(@model)">
								<xsl:value-of select="concat('/', @displayShapeType, '/', @shapeType)"/>
							</xsl:when>
							<xsl:when test="not(@model) and string-length(@name) = 0">
								<xsl:value-of select="concat('/', 'Unamed ', @displayShapeType, '/', @shapeType)"/>
							</xsl:when>
							<xsl:when test="string-length(@name) = 0">
								<xsl:variable name="isContentPageAvailable">
									<xsl:call-template name="isContentPageAvailable">
							      <xsl:with-param name="model_node" select="."/>
									</xsl:call-template>
								</xsl:variable>
							
								<xsl:choose>
									<xsl:when test="$isContentPageAvailable = 'true'">
										<xsl:value-of select="concat(@modelType, '_', @model, '.html', '/', 'Unamed ', @displayShapeType, '/', @modelType)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="concat('', '/', 'Unamed ', @displayShapeType, '/', @modelType)"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="name_without_newline">
									<xsl:call-template name="replace">
										<xsl:with-param name="string" select="@name"/>
										<xsl:with-param name="pattern" select="'&#10;'"/>
										<xsl:with-param name="replacement" select="''"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="isContentPageAvailable">
									<xsl:call-template name="isContentPageAvailable">
							      <xsl:with-param name="model_node" select="."/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$isContentPageAvailable = 'true'">
										<xsl:value-of select="concat(@modelType, '_', @model, '.html', '/', $name_without_newline, '/', @modelType)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="concat('', '/', $name_without_newline, '/', @modelType)"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>'</xsl:text>
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
				
				<!-- subdiagrams -->
				<xsl:variable name="subdiagrams_string">
					<xsl:value-of select="'new Array('"/>
					<xsl:for-each select="$shape_element/SubDiagrams/DiagramRef">
						<xsl:text>'</xsl:text>
						<xsl:value-of select="concat(@diagramType, '_', @id, '.html', '/', @name, '/', @diagramType)"/>
						<xsl:text>'</xsl:text>
						<xsl:if test="position()!=last()">
							<xsl:value-of select="','"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:value-of select="')'"/>
				</xsl:variable>
								
				<xsl:value-of select="concat('storeReferenceAndSubdiagramInfos(this.coords,', $file_refs_string, ',', $folder_refs_string, ',', $url_refs_string, ',', $diagram_refs_string, ',', $shape_refs_string, ',', $subdiagrams_string, ')')"/>
			
			</xsl:if>
		</xsl:variable>
	
		<!-- REFERENCE -->
		<xsl:variable name="onmouseover_reference_string">
			<xsl:if test="count($shape_element/DiagramElementProperties/ModelsProperty[@name='references']/*) > 0 or count($shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef)>0 or count($shape_element/DiagramElementProperties/DiagramElementRefsProperty[@name='references']/DiagramElementRef)>0">
				<xsl:value-of select="'showReferenceIcon(this.coords)'"/>
			</xsl:if>
		</xsl:variable>
		
		<!-- SUBDIAGRAM -->
		<xsl:variable name="onmouseover_subdiagram_string">
			<xsl:if test="count($shape_element/SubDiagrams/DiagramRef) > 0">
				<xsl:value-of select="'showSubdiagramIcon(this.coords)'"/>
			</xsl:if>
		</xsl:variable>
		
		<!-- DOCUMENTATION (Tooltip) -->
		<xsl:variable name="onmouseover_doc_tooltip_string">
			<xsl:if test="string-length($shape_element/@documentaiton_plainText) &gt; 0 and $opt_is_show_documentation_when_hover_over_a_shape = 'true'">
				<xsl:value-of select="'showTooltip(this)'"></xsl:value-of>
			</xsl:if>
		</xsl:variable>
		

		<!-- *************************************** onmousemove *************************************** -->
		<xsl:variable name="onmousemove_update_cur_pos_string">
			<xsl:if test="(count($shape_element/DiagramElementProperties/ModelsProperty[@name='references']/*) > 0 or count($shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef)>0 or count($shape_element/DiagramElementProperties/DiagramElementRefsProperty[@name='references']/DiagramElementRef)>0) and $showReferencesPopupWhenClickOnShape='true'">
				<xsl:value-of select="'updateCursorPosition(event)'"></xsl:value-of>
			</xsl:if>
		</xsl:variable>

		<!-- *************************************** onmousedown *************************************** -->
		<xsl:variable name="onmousedown_reset_popup_pos_string">
			<xsl:if test="(count($shape_element/DiagramElementProperties/ModelsProperty[@name='references']/*) > 0 or count($shape_element/DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef)>0 or count($shape_element/DiagramElementProperties/DiagramElementRefsProperty[@name='references']/DiagramElementRef)>0) and $showReferencesPopupWhenClickOnShape='true'">
				<xsl:value-of select="'resetPopupForReference();movePopupPositionToCursorPosition(event);showLinkPopup();return false;'"></xsl:value-of>
			</xsl:if>
			<xsl:if test="$showSubdiagramsPopupWhenClickOnShape = 'true' and count($shape_element/SubDiagrams/DiagramRef)>0">
				<xsl:value-of select="'resetPopupForSubdiagram();movePopupPositionToCursorPosition(event);showLinkPopup();return false;'"></xsl:value-of>
			</xsl:if>			
		</xsl:variable>

		<!-- *************************************** onmouseout *************************************** -->
		<xsl:variable name="onmouseout_hide_doc_tooltip_string">
			<xsl:if test="string-length($shape_element/@documentaiton_plainText) &gt; 0 and $opt_is_show_documentation_when_hover_over_a_shape = 'true'">
				<xsl:value-of select="'hideTooltip()'"></xsl:value-of>
			</xsl:if>
		</xsl:variable>
		
		
		<xsl:variable name="onmouseover_var">
			<xsl:element name="JSFunctions">
				<xsl:element name="F"><xsl:value-of select="$onmouseover_reference_and_subdiagram_string"/></xsl:element>
				<xsl:element name="F"><xsl:value-of select="$onmouseover_reference_string"/></xsl:element>
				<xsl:element name="F"><xsl:value-of select="$onmouseover_subdiagram_string"/></xsl:element>
				<xsl:element name="F"><xsl:value-of select="$onmouseover_doc_tooltip_string"/></xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="onmousemove_var">
			<xsl:element name="JSFunctions">
				<xsl:element name="F"><xsl:value-of select="$onmousemove_update_cur_pos_string"/></xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="onmousedown_var">
			<xsl:element name="JSFunctions">
				<xsl:element name="F"><xsl:value-of select="$onmousedown_reset_popup_pos_string"/></xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="onmouseout_var">
			<xsl:element name="JSFunctions">
				<xsl:element name="F"><xsl:value-of select="$onmouseout_hide_doc_tooltip_string"/></xsl:element>
			</xsl:element>
		</xsl:variable>
	
		<!-- Form the Area element -->
		<xsl:call-template name="printAreaSub">
			<xsl:with-param name="doc_content" select="$docContent_string"/>
			<xsl:with-param name="coords" select="concat($x,',',$y,',',$x2,',',$y2)"/>
			<xsl:with-param name="href" select="$href_string"/>
			<xsl:with-param name="alt" select="$alt"/>
			<xsl:with-param name="id" select="$shape_element/@id"/>
			<xsl:with-param name="onmouseover_nodeset" select="$onmouseover_var"/>
			<xsl:with-param name="onmousemove_nodeset" select="$onmousemove_var"/>
			<xsl:with-param name="onmousedown_nodeset" select="$onmousedown_var"/>
			<xsl:with-param name="onmouseout_nodeset" select="$onmouseout_var"/>
		</xsl:call-template>
		
	</xsl:template>
	
	<!-- 
		Form the Area element with the onmouseover, onmousemove and onmousedown strings
	-->
	<xsl:template name="printAreaSub">
		<xsl:param name="doc_content"/>
		<xsl:param name="coords"/>
		<xsl:param name="href"/>
		<xsl:param name="alt"/>
		<xsl:param name="id"/>
		<xsl:param name="onmouseover_nodeset"/>
		<xsl:param name="onmousemove_nodeset"/>
		<xsl:param name="onmousedown_nodeset"/>
		<xsl:param name="onmouseout_nodeset"/>

		<!-- onmouseover -->
		<xsl:variable name="onmouseover_str">
			<xsl:for-each select="xalan:nodeset($onmouseover_nodeset)/JSFunctions/*[text() != '']">
				<xsl:value-of select="text()"/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<!-- onmousemove -->
		<xsl:variable name="onmousemove_str">
			<xsl:for-each select="xalan:nodeset($onmousemove_nodeset)/JSFunctions/*[text() != '']">
				<xsl:value-of select="text()"/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<!-- onmousedown -->
		<xsl:variable name="onmousedown_str">
			<xsl:for-each select="xalan:nodeset($onmousedown_nodeset)/JSFunctions/*[text() != '']">
				<xsl:value-of select="text()"/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
	
		<!-- onmouseout -->
		<xsl:variable name="onmouseout_str">
			<xsl:for-each select="xalan:nodeset($onmouseout_nodeset)/JSFunctions/*[text() != '']">
				<xsl:value-of select="text()"/>
				<xsl:if test="position() != last()">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<!-- area -->
		<xsl:element name="area">
			<xsl:if test="boolean($doc_content) and $doc_content != ''">
				<xsl:attribute name="docContent"><xsl:value-of select="$doc_content"/></xsl:attribute>
			</xsl:if>
			<xsl:attribute name="coords"><xsl:value-of select="$coords"/></xsl:attribute>
			<xsl:attribute name="shape"><xsl:value-of select="'rect'"/></xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="$alt"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<xsl:if test="$href != ''">
				<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$onmouseover_str != ''">
				<xsl:attribute name="onmouseover"><xsl:value-of select="$onmouseover_str"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$onmousemove_str != ''">
				<xsl:attribute name="onmousemove"><xsl:value-of select="$onmousemove_str"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$onmousedown_str != ''">
				<xsl:attribute name="onmousedown"><xsl:value-of select="$onmousedown_str"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$onmouseout_str != ''">
				<xsl:attribute name="onmouseout"><xsl:value-of select="$onmouseout_str"/></xsl:attribute>
			</xsl:if>
		</xsl:element>
	
	</xsl:template>

			
</xsl:stylesheet>
