<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

<xsl:output method="html" indent="yes"/>


	<xsl:template name = "printPackageWithFullQualifier" match="*">
		<xsl:param name="package_name"/>
			<xsl:choose>
			<xsl:when test="../@modelType = 'Package'">
				<xsl:variable name="parent_package_name" select="../@name"/>
				<xsl:variable name="combined_package_name" select="concat($parent_package_name, '.', $package_name)"/>
				<xsl:apply-templates select="..">
					<xsl:with-param name="package_name" select="$combined_package_name"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="name(../.) != 'Models'">
						<xsl:apply-templates select="..">
							<xsl:with-param name="package_name" select="$package_name"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$package_name"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose> 
	
	
	</xsl:template>

	<xsl:template match="*" mode="printParentHierarchyWithHyperlink">
		<xsl:param name="seperator_text"/>
		<xsl:choose>
		<!--
			if it's parent has Childs as model type, show its parent's parent's link
			if it's parent doesn't has Childs as model type, return
		-->
			<xsl:when test="name(../.) = 'ChildModels'">
				<xsl:variable name="url" select="concat(../../@modelType, '_', ../../@id, '.html')"/>
				<xsl:variable name="parent_name" select="../../@name"/>
				<xsl:variable name="parent_type" select="../../@displayModelType"/>
				
				<xsl:apply-templates select="../.." mode="printParentHierarchyWithHyperlink">
					<xsl:with-param name="seperator_text" select="' . '"/>
				</xsl:apply-templates>
				
				<a href="{$url}" class="PageParentTitle"><xsl:value-of select="concat($parent_name, ' : ', $parent_type)"/></a><span class="PageParentTitle"><xsl:value-of select="$seperator_text"/></span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="name(../.) != 'Models'">
						<xsl:apply-templates select=".." mode="printParentHierarchyWithHyperlink">
							<xsl:with-param name="seperator_text" select="' . '"/>
						</xsl:apply-templates>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*" mode="printParentModelElementlink">
		<xsl:variable name="parentModelNode" select="./DiagramProperties/ModelRefProperty[@name='parentModel']/ModelRef"/>
		<xsl:variable name="url" select="concat($parentModelNode/DiagramElementRef/@modelType, '_', $parentModelNode/DiagramElementRef/@model, '.html')"/>
		<xsl:variable name="parent_name" select="$parentModelNode/@name"/>
		<xsl:variable name="parent_type" select="$parentModelNode/@displayModelType"/>
		
		<a href="{$url}" class="PageParentTitle"><xsl:value-of select="concat($parent_name, ' : ', $parent_type)"/></a>
	</xsl:template>

	
</xsl:stylesheet>
