<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

<xsl:output method="html" indent="yes"/>

	<xsl:template name="replace">
		<xsl:param name="string" select="''"/>
		<xsl:param name="pattern" select="''"/>
		<xsl:param name="replacement" select="''"/>
		<xsl:choose>
			<xsl:when test="$pattern != '' and $string != '' and contains($string, $pattern)">
				<xsl:value-of select="substring-before($string, $pattern)"/>
				<xsl:value-of select="$replacement" disable-output-escaping="yes"/>
				<xsl:call-template name="replace">
					<xsl:with-param name="string" select="substring-after($string, $pattern)"/>
					<xsl:with-param name="pattern" select="$pattern"/>
					<xsl:with-param name="replacement" select="$replacement"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- replace chars in string -->
	<xsl:template name="replaceChars">
	  <xsl:param name="s"/>
	  <xsl:param name="charsIn"/>
	  <xsl:param name="charsOut"/>
	  <xsl:choose>
	    <xsl:when test="contains($s,$charsIn)">
	      <xsl:value-of select="concat(substring-before($s,$charsIn),$charsOut)"/>
	      <xsl:call-template name="replaceChars">
	        <xsl:with-param name="s" select="substring-after($s,$charsIn)"/>
	        <xsl:with-param name="charsIn" select="$charsIn"/>
	        <xsl:with-param name="charsOut" select="$charsOut"/>
	      </xsl:call-template>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="$s"  disable-output-escaping="yes"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
