<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

<xsl:output method="html" indent="yes"/>

	<xsl:template name = "drawDiagramNavigatorPane">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $DIAGRAM_NAVIGATOR_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;" >
				<xsl:call-template name="drawNavigatorPageHeader">
					<xsl:with-param name="report_name" select="$report_name"/>
				</xsl:call-template>
				<div id="header">
					<ul>
						<li>
							<span>
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</span>
						</li>
						<li>
							<a href="{$MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}" >
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</a>
						</li>
						<xsl:if test="$support_class_diagram = 'true'">
							<li>
								<a href="{$CLASS_MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}">
								<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
								</a>
							</li>
						</xsl:if>
					</ul>
				</div>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="2"/></tr>
					<tr><td class="TableHeaderLine1" colspan="2"/></tr>
					<tr class="TableHeader">
						<td style="width: 5px"/>
						<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_Diagram_Navigator"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="2"/></tr>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr class = "TableRow1">
						<td style="width: 10px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}');"/>
						</td>
						<td style="width: 5px"/>
						<td width="*">
							<xsl:variable name="filename" select="$ALL_DIAGRAMS_MENU_PAGE_NAME"/>
							<a href="{$filename}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink"><xsl:value-of select="$st_Show_All_Diagrams"/></a>
						</td>
					</tr>
					<xsl:for-each select="//Project/Diagrams/Diagram[@diagramType!='UseCaseDescriptionDiagram' and not(@diagramType=preceding-sibling::Diagram/@diagramType)]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td style="width: 18px">
							<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @diagramType, $diagram_folder_icon_file_suffix)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @diagramType, $diagram_folder_icon_file_suffix)}');"/>
							</td>
							<td style="width: 5px"/>
							<td>
								<a href="{concat(@diagramType, '_menu.html')}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink">
									<xsl:value-of select="./@displayDiagramType"/>
								</a>
							</td>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</body>
			</html>
		</redirect:write>
	</xsl:template>
	
	<xsl:template name = "drawModelNavigatorPane">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $MODEL_NAVIGATOR_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
				<xsl:call-template name="drawNavigatorPageHeader">
					<xsl:with-param name="report_name" select="$report_name"/>
				</xsl:call-template>
				<div id="header">
					<ul>
						<li>
							<a href="{$DIAGRAM_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}">
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</a>
						</li>
						<li>
							<span>
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</span>
						</li>
						<xsl:if test="$support_class_diagram = 'true'">
							<li>
								<a href="{$CLASS_MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}">
								<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
								</a>
							</li>
						</xsl:if>
						
						<!--
						<li><a href="{$DIAGRAM_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}"><img src = "{concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}" class = "TabIcon"/></a></li>
						<li><span><img src = "{concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}" class = "TabIcon"/></span></li>
						<li><a href="{$CLASS_MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}"><img src = "{concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}" class = "TabIcon"/></a></li>
						-->
						
					</ul>
				</div>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="2"/></tr>
					<tr><td class="TableHeaderLine1" colspan="2"/></tr>
					<tr class="TableHeader">
						<td style="width: 5px"/>
						<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_Model_Navigator"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="2"/></tr>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr class = "TableRow1">
						<td style="width: 10px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}');"/>
						</td>
						<td style="width: 5px"/>
						<td>
							<xsl:variable name="filename" select="$ALL_MODELS_MENU_PAGE_NAME"/>
							<a href="{$filename}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink"><xsl:value-of select="$st_Show_All_Models"/></a>
						</td>
					</tr>
					<xsl:for-each select="//Project/Models//Model[@modelType='Package']">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td style="width: 18px">
							<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
							</td>
							<td style="width: 5px"/>
							<td>
								<a href="{concat(@id, '_model_menu.html')}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink">
									<xsl:call-template name="printPackageWithFullQualifier">
										<xsl:with-param name="package_name" select="@name"/>
									</xsl:call-template>
								</a>
							</td>
						</tr>
					</xsl:for-each>
				</table>
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<tr><td style="height: 1px"/></tr>
						<tr><td class="TableFooter"/></tr>
					</table>
				<p/>
			</body>
			</html>
		</redirect:write>
	</xsl:template>
	

	<xsl:template name = "drawClassModelNavigatorPane">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $CLASS_MODEL_NAVIGATOR_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
				<xsl:call-template name="drawNavigatorPageHeader">
					<xsl:with-param name="report_name" select="$report_name"/>
				</xsl:call-template>
				<div id="header">
					<ul>
						<li>
							<a href="{$DIAGRAM_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}">
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</a>
						</li>
						<li>
							<a href="{$MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}">
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</a>
						</li>
						<li>
							<span>
							<center><div style="border: none; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}'); margin-top:3px;"/></center>
							</span>
						</li>
						
						<!--
						<li><a href="{$DIAGRAM_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}"><img src = "{concat('../', $icon_dir_relative_path, '/', $diagram_navigator_icon_file_name)}" class = "TabIcon"/></a></li>
						<li><a href="{$MODEL_NAVIGATOR_PAGE_NAME}" target="{$NAVIGATOR_PANE_NAME}"><img src = "{concat('../', $icon_dir_relative_path, '/', $model_navigator_icon_file_name)}" class = "TabIcon"/></a></li>
						<li><span><img src = "{concat('../', $icon_dir_relative_path, '/', $class_model_navigator_icon_file_name)}" class = "TabIcon"/></span></li>
						-->
					</ul>
				</div>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="2"/></tr>
					<tr><td class="TableHeaderLine1" colspan="2"/></tr>
					<tr class="TableHeader">
						<td style="width: 5px"/>
						<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_Class_Navigator"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="2"/></tr>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr class = "TableRow1">
						<td style="width: 10px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $project_icon_file_name)}');"/>
						</td>
						<td style="width: 5px"/>
						<td>
							<xsl:variable name="filename" select="$ALL_CLASS_MODELS_MENU_PAGE_NAME"/>
							<a href="{$filename}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink"><xsl:value-of select="$st_Show_All_Class_Models"/></a>
							<!-- <xsl:call-template name="drawAllDiagramsMenuPane"/> -->
						</td>
					</tr>
					<xsl:for-each select="//Project/Models//Model[@modelType='Package']">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td style="width: 18px">
							<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
							</td>
							<td style="width: 5px"/>
							<td>
								<a href="{concat(@id, '_model_menu.html')}" target="{$MENU_PANE_NAME}" class = "CategoryItemLink">
									<xsl:call-template name="printPackageWithFullQualifier">
										<xsl:with-param name="package_name" select="@name"/>
									</xsl:call-template>
								</a>
							</td>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</body>
			</html>
		</redirect:write>
	</xsl:template>
		
</xsl:stylesheet>
