<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

<xsl:output method="html" indent="yes"/>

	<xsl:template name = "generateDiagramMenus">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $ALL_DIAGRAMS_MENU_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="2"/></tr>
				<tr><td class="TableHeaderLine1" colspan="2"/></tr>
				<tr class="TableHeader">
					<td style="width: 5px">&nbsp;</td>
					<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_All_Diagrams"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="2"/></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<xsl:for-each select="//Project/Diagrams/Diagram[@diagramType!='UseCaseDescriptionDiagram']">
					<xsl:variable name="diagram_id" select="@id" />
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 24px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}');"/>
						</td> 
						<td style="width: 5px"/>
						<td width="*">
							<a href="{concat(@diagramType, '_', $diagram_id, '.html')}" target="{$CONTENT_PANE_NAME}" class = "ItemLink">
								<xsl:value-of select="./@name"/>
							</a>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
			</body>
			</html>
		</redirect:write>	
		
		
		<xsl:for-each select="//Project/Diagrams/Diagram[@diagramType!='UseCaseDescriptionDiagram']">
			<xsl:variable name="diagram_type" select="@diagramType" />
			<xsl:variable name="display_diagram_type" select="@displayDiagramType" />
			<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $diagram_type, '_menu.html')" />
			<redirect:write file="{$filename}">
				<html>
				<head>
				<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
				<title></title>
				</head>
				<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<tr><td class="TableHeaderLine" colspan="4"/></tr>
						<tr><td class="TableHeaderLine1" colspan="4"/></tr>
						<tr class="TableHeader">
							<td style="width: 5px"/>
							<td style="width: 18px">
							<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @diagramType, $diagram_folder_icon_file_suffix)}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @diagramType, $diagram_folder_icon_file_suffix)}');"/>
							</td>
							<td style="width: 6px"/>
							<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$display_diagram_type"/></span></td>
						</tr>
						<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					</table>
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<xsl:for-each select="../*[@diagramType=$diagram_type]">
							<xsl:variable name="diagram_id" select="@id" />
							<tr>
								<xsl:choose>
									<xsl:when test="position() mod 2 = 1">
										<xsl:attribute name="class">TableRow1</xsl:attribute> 
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="class">TableRow2</xsl:attribute> 
									</xsl:otherwise>
								</xsl:choose>
								<td style="width: 24px"/>
								<td style="width: 18px">
								<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}');"/>
								</td>
								<td style="width: 5px"/>
								<td width="*">
									<a href="{concat(@diagramType, '_', $diagram_id, '.html')}" target="{$CONTENT_PANE_NAME}" class = "ItemLink">
										<xsl:value-of select="./@name"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<tr><td style="height: 1px"/></tr>
						<tr><td class="TableFooter"/></tr>
					</table>
					<p/>
				</body>
				</html>
			</redirect:write>
		</xsl:for-each>	
		
	</xsl:template>
	
	
	<xsl:template name = "generateModelMenus">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $ALL_MODELS_MENU_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="2"/></tr>
				<tr><td class="TableHeaderLine1" colspan="2"/></tr>
				<tr class="TableHeader">
					<td style="width: 5px">&nbsp;</td>
					<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_All_Models"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="2"/></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<xsl:for-each select="//Project/Models//Model[
					@modelType = 'UseCase' 
					or @modelType = 'Actor' 
					or @modelType = 'System' 
					or @modelType = 'Package' 
					or @modelType = 'Subsystem' 
					or @modelType = 'Collaboration' 
					or @modelType = 'DiagramOverview' 
					or @modelType = 'Class' 
					or @modelType = 'Model' 
					or @modelType = 'NARY' 
					or @modelType = 'Frame' 
					or @modelType = 'InteractionLifeLine'
					or @modelType = 'CombinedFragment' 
					or @modelType = 'InteractionActor' 
					or @modelType = 'Continuation' 
					or @modelType = 'Concurrent' 
					or @modelType = 'Gate' 
					or @modelType = 'SwimLane' 
					or @modelType = 'State2' 
					or @modelType = 'SubmachineState2' 
					or @modelType = 'InitialPseudoState' 
					or @modelType = 'ShallowHistory' 
					or @modelType = 'DeepHistory' 
					or @modelType = 'Choice' 
					or @modelType = 'Junction' 
					or @modelType = 'Fork' 
					or @modelType = 'Join' 
					or @modelType = 'EntryPoint' 
					or @modelType = 'ExitPoint' 
					or @modelType = 'Terminate' 
					or @modelType = 'FinalState2' 
					or @modelType = 'Activity' 
					or @modelType = 'ActivityParameterNode' 
					or @modelType = 'ActivityAction' 
					or @modelType = 'AcceptEventAction' 
					or @modelType = 'SendSignalAction' 
					or @modelType = 'StructuredActivityNode' 
					or @modelType = 'SequenceNode' 
					or @modelType = 'DecisionNode' 
					or @modelType = 'MergeNode' 
					or @modelType = 'ForkNode' 
					or @modelType = 'JoinNode' 
					or @modelType = 'InitialNode' 
					or @modelType = 'ActivityFinalNode' 
					or @modelType = 'InputPin' 
					or @modelType = 'OutputPin' 
					or @modelType = 'ValuePin' 
					or @modelType = 'ObjectNode' 
					or @modelType = 'InterruptibleActivityRegion' 
					or @modelType = 'ExpansionRegion' 
					or @modelType = 'ExpansionNode' 
					or @modelType = 'ActivitySwimlane2' 
					or @modelType = 'ActivityEdgeConnector' 
					or @modelType = 'ExceptionHandler' 
					or @modelType = 'CentralBufferNode' 
					or @modelType = 'DataStoreNode' 
					or @modelType = 'FlowFinalNode' 
					or @modelType = 'Component' 
					or @modelType = 'InstanceSpecification' 
					or @modelType = 'Port' 
					or @modelType = 'Node' 
					or @modelType = 'Artifact' 
					or @modelType = 'DeploySpecification' 
					or @modelType = 'Collaboration2' 
					or @modelType = 'CollaborationOccurrence' 
					or @modelType = 'StructuredClass' 
					or @modelType = 'TimingFrame' 
					or @modelType = 'InteractionOccurrence' 
					or @modelType = 'DBView' 
					or @modelType = 'DBTable' 
					or @modelType = 'CRCCard' 
					
					or @modelType = 'BPDataObject' 
					or @modelType = 'BPEmbeddedSubProcess' 
					or @modelType = 'BPEndEvent' 
					or @modelType = 'BPGateway' 
					or @modelType = 'BPGatewayAND' 
					or @modelType = 'BPGatewayComplex' 
					or @modelType = 'BPGatewayDataBasedXOR' 
					or @modelType = 'BPGatewayEventBasedXOR' 
					or @modelType = 'BPGatewayOR' 
					or @modelType = 'BPGroup' 
					or @modelType = 'BPIndependentSubProcess' 
					or @modelType = 'BPIntermediateEvent' 
					or @modelType = 'BPLane' 
					or @modelType = 'BPManualTask' 
					or @modelType = 'BPPool' 
					or @modelType = 'BPReceiveTask' 
					or @modelType = 'BPReferenceSubProcess' 
					or @modelType = 'BPReferenceTask' 
					or @modelType = 'BPScriptTask' 
					or @modelType = 'BPSendTask' 
					or @modelType = 'BPServiceTask' 
					or @modelType = 'BPStartEvent' 
					or @modelType = 'BPSubProcess' 
					or @modelType = 'BPTask' 
					or @modelType = 'BPTextAnnotation' 
					or @modelType = 'BPUserTask' 
				
					or @modelType = 'Requirement' 
					or @modelType = 'RequirementModel' 
					or @modelType = 'TestCase' 
			
					or @modelType = 'DFDataStore' 
					or @modelType = 'DFExternalEntity' 
					or @modelType = 'DFProcess' 
					
					or @modelType = 'UIButton' 
					or @modelType = 'UICheckBox' 
					or @modelType = 'UIComboBox' 
					or @modelType = 'UIFrame' 
					or @modelType = 'UILabel' 
					or @modelType = 'UIList' 
					or @modelType = 'UIPanel' 
					or @modelType = 'UIPasswordField' 
					or @modelType = 'UIProgressBar' 
					or @modelType = 'UIRadioButton' 
					or @modelType = 'UIScrollBar' 
					or @modelType = 'UISeparator' 
					or @modelType = 'UISlider' 
					or @modelType = 'UISpinner' 
					or @modelType = 'UITabbedHeader' 
					or @modelType = 'UITable' 
					or @modelType = 'UITextArea' 
					or @modelType = 'UITextField' 
					or @modelType = 'UIToggleButton' 
					or @modelType = 'UITree' 
					or @modelType = 'UIButton' 
					or @modelType = 'UIMenubar' 
								
					or @modelType = 'GraphicShape' 
					or @modelType = 'Interface' 
					or @modelType = 'VisioModel' 
					
					or @modelType = 'ProcedureContainer' 
					or @modelType = 'ProcedureResultSet' 
					or @modelType = 'DBTriggerContainer' 
					
					or @modelType = 'MindMapNode'
			
					or @modelType = 'EPCEvent'
					or @modelType = 'EPCFunction'
					or @modelType = 'EPCAndOperator'
					or @modelType = 'EPCXOROperator'
					or @modelType = 'EPCOrganizationUnit'
					or @modelType = 'EPCProcessPath'
					or @modelType = 'EPCInformationResource'
					
					or @modelType = 'PMProcess'
					or @modelType = 'PMSend'
					or @modelType = 'PMReceive'
			
					or @modelType = 'OCUnit'
					or @modelType = 'ShapeEditorShape'
					or @modelType = 'DBSequence'
				]">
					<xsl:sort select="@modelType"/>
					<xsl:variable name="model_id" select="@id" />
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 24px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
						</td>
						<td style="width: 5px"/>
						<td width="*">
							<a href="{concat(@modelType, '_', $model_id, '.html')}" target="{$CONTENT_PANE_NAME}" class = "ItemLink">
								<xsl:value-of select="./@name"/> : <xsl:value-of select="./@displayModelType"/>
							</a>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
			</body>
			</html>
		</redirect:write>	

		<!-- Package menu will be generated in generateClassModelMenus -->

	</xsl:template>	

	
	<xsl:template name = "generateClassModelMenus">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $ALL_CLASS_MODELS_MENU_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="2"/></tr>
				<tr><td class="TableHeaderLine1" colspan="2"/></tr>
				<tr class="TableHeader">
					<td style="width: 5px">&nbsp;</td>
					<td width = "*"><span class="TableHeaderText"><xsl:value-of select="$st_All_Class_Models"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="2"/></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<xsl:for-each select="//Project/Models//Model[@modelType = 'Class' or @modelType = 'Package']">
					<xsl:sort select="@modelType"/>
					<xsl:variable name="model_id" select="@id" />
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 24px"/>
						<td style="width: 18px">
						<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
						</td>
						<td style="width: 5px"/>
						<td width="*">
							<a href="{concat(@modelType, '_', $model_id, '.html')}" target="{$CONTENT_PANE_NAME}" class = "ItemLink">
								<xsl:value-of select="./@name"/>
							</a>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
			</body>
			</html>
		</redirect:write>	
		
		<xsl:for-each select="//Project/Models//Model[@modelType='Package']">
			<xsl:variable name="filename" select="concat($content_dir_base_path, '/', @id, '_model_menu.html')" />
			<redirect:write file="{$filename}">
				<html>
				<head>
				<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
				<title></title>
				</head>
				<body style="margin-left: 5px; margin-right: 5px; margin-top: 5px; margin-bottom: 5px;">
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<tr><td class="TableHeaderLine" colspan="4"/></tr>
						<tr><td class="TableHeaderLine1" colspan="4"/></tr>
						<tr class="TableHeader">
							<td style="width: 5px"/>
							<td style="width: 18px">
							<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
							</td>
							<td style="width: 6px"/>
							<td width = "*"><a class="TableHeaderText" href="{concat(@modelType, '_', @id, '.html')}" target="{$CONTENT_PANE_NAME}">
								<xsl:call-template name="printPackageWithFullQualifier">
									<xsl:with-param name="package_name" select="@name"/>
								</xsl:call-template>
							</a></td>
						</tr>
						<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					</table>
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<xsl:for-each select="./ChildModels/Model[@modelType = 'Class' or @modelType = 'Package']">
							<tr>
								<xsl:choose>
									<xsl:when test="position() mod 2 = 1">
										<xsl:attribute name="class">TableRow1</xsl:attribute> 
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="class">TableRow2</xsl:attribute> 
									</xsl:otherwise>
								</xsl:choose>
								<td style="width: 24px"/>
								<td style="width: 18px">
								<div style="width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>
								</td>
								<td style="width: 5px"/>
								<td width="*">
									<a href="{concat(@modelType, '_', @id, '.html')}" target="{$CONTENT_PANE_NAME}" class = "ItemLink">
										<xsl:value-of select="./@name"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					<table width = "100%" border="0" cellpadding="0" cellspacing="0">
						<tr><td style="height: 1px"/></tr>
						<tr><td class="TableFooter"/></tr>
					</table>
					<p/>
				</body>
				</html>
			</redirect:write>
		</xsl:for-each>	
	</xsl:template>	
	
</xsl:stylesheet>
