<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>
<xsl:include href="NavigatorPane.xsl" />
<xsl:include href="MenuPane.xsl" />
<xsl:include href="ContentPane.xsl" />
<xsl:include href="UIComponents.xsl" />
<xsl:include href="Utility.xsl" />
<xsl:include href="StringUtility.xsl" />

<xsl:output method="html" indent="yes"/>

	<!-- the base location where the generated files be placed -->
	<xsl:param name="absolute_base_dir"/>

	<!-- image folder name-->
	<xsl:param name="image_dir_name"/>
	
	<!-- icon folder relative path -->
	<xsl:param name="icon_dir_relative_path"/>

	<!-- css file name -->
 	<xsl:param name="style_sheet_file_name"/>

	<!-- js file name -->
 	<xsl:param name="javascript_file_name1"/>
 	<xsl:param name="javascript_file_name2"/>
 	<xsl:param name="javascript_file_name3"/>

	<!-- icon file -->
	<xsl:param name="icon_file_path"/>

	<!-- diagram folder icon file suffix -->
	<xsl:param name="diagram_folder_icon_file_suffix"/>

	<!-- content folder name -->
	<xsl:param name="content_dir_name"/>
	
	<!-- references folder name -->
	<xsl:param name="references_dir_name"/>
	
	<!-- tab icons file name -->
	<xsl:param name="diagram_navigator_icon_file_name"/>
	<xsl:param name="model_navigator_icon_file_name"/>
	<xsl:param name="class_model_navigator_icon_file_name"/>
	
	<!-- resource icons file name -->
	<xsl:param name="back_to_top_file_name"/>
	<xsl:param name="open_specification_file_name"/>
	<xsl:param name="ref_icon_file_name"/>
	<xsl:param name="subdiagram_icon_file_name"/>
	
	<!-- support class diagarm? (e.g. BPVA does not support) -->
	<xsl:param name="support_class_diagram"/>
	
	<!-- project icon file name -->
	<xsl:param name="project_icon_file_name"/>
	
	<!-- project name -->
	<xsl:variable name="project_name" select="Project/@name"/>
	
	<!-- report name -->
	<xsl:variable name="report_name" select="concat($project_name, ' ', 'Documentation')"/>
	
	<!-- content dir base path-->
	<xsl:variable name="content_dir_base_path" select="concat($absolute_base_dir, '/', $content_dir_name)"/>
	
	<!-- frame name constants -->
	<xsl:variable name="NAVIGATOR_PANE_NAME" select="'_navigator_pane'"/>
	<xsl:variable name="MENU_PANE_NAME" select="'_menu_pane'"/>
	<xsl:variable name="CONTENT_PANE_NAME" select="'_content_pane'"/>
	
	<!-- page name constants -->
 	<xsl:variable name="DIAGRAM_NAVIGATOR_PAGE_NAME" select="'diagram_navigator.html'"/>
 	<xsl:variable name="MODEL_NAVIGATOR_PAGE_NAME" select="'model_navigator.html'"/>
 	<xsl:variable name="CLASS_MODEL_NAVIGATOR_PAGE_NAME" select="'class_model_navigator.html'"/>
 	<xsl:variable name="BLANK_MENU_PAGE_NAME" select="'blank_menu.html'"/>
 	<xsl:variable name="ALL_DIAGRAMS_MENU_PAGE_NAME" select="'all_diagrams_menu.html'"/>
 	<xsl:variable name="ALL_MODELS_MENU_PAGE_NAME" select="'all_models_menu.html'"/>
 	<xsl:variable name="ALL_CLASS_MODELS_MENU_PAGE_NAME" select="'all_class_models_menu.html'"/>
 	<xsl:variable name="PROJCET_CONTENT_PAGE_NAME" select="'project_content.html'"/>
 	<xsl:variable name="INDEX_WITHOUT_MENU_PAGE_NAME" select="'index_withoutmenu.html'"/>
	
	<!-- report index page name -->
	<xsl:param name="report_index_page_name"/>
	
	<!-- diagram dimension -->
	<xsl:param name="max_image_width"/>
	<xsl:param name="max_image_height"/>
	
	<!-- several advanced options -->
	<xsl:param name="opt_drill_down_effect_for_general_model"/>
	<xsl:param name="opt_drill_down_effect_for_business_subprocess"/>
	<xsl:param name="opt_drill_down_effect_for_process_map_process"/>
	<xsl:param name="opt_drill_down_effect_for_bpmn_events"/>
	<xsl:param name="opt_drill_down_effect_for_diagram_overview"/>
	<xsl:param name="opt_is_generate_model_list_in_diagram_page"/>
	<xsl:param name="opt_is_generate_only_documentation_in_model_page"/>
	<xsl:param name="opt_default_diagram_id"/>
	<xsl:param name="opt_is_generate_page_header"/>
	<xsl:param name="opt_is_generate_page_footer"/>
	<xsl:param name="opt_is_show_documentation_when_hover_over_a_shape"/>
	<xsl:param name="opt_is_display_jump_to"/>
	<xsl:param name="opt_is_display_diagram_page_title"/>
	<xsl:param name="opt_is_display_model_element_page_title"/>
	
	<!-- params for static text -->
	<xsl:param name="st_Action_Type"/>
	<xsl:param name="st_Actor_Input"/>
	<xsl:param name="st_All_Class_Models"/>
	<xsl:param name="st_All_Diagrams"/>
	<xsl:param name="st_All_Models"/>
	<xsl:param name="st_Assignments"/>
	<xsl:param name="st_Attribute"/>
	<xsl:param name="st_Attribute_Links"/>
	<xsl:param name="st_Attributes"/>
	<xsl:param name="st_Attributes_Detail"/>
	<xsl:param name="st_Attributes_Summary"/>
	<xsl:param name="st_Author"/>
	<xsl:param name="st_Begin"/>
	<xsl:param name="st_Candidate_items"/>
	<xsl:param name="st_Candidate_Class"/>
	<xsl:param name="st_Categories"/>
	<xsl:param name="st_Children"/>
	<xsl:param name="st_Class"/>
	<xsl:param name="st_Class_Description"/>
	<xsl:param name="st_Class_Navigator"/>
	<xsl:param name="st_Column_Name"/>
	<xsl:param name="st_Columns_Summary"/>
	<xsl:param name="st_Columns_Detail"/>
	<xsl:param name="st_Comments"/>
	<xsl:param name="st_Content"/>
	<xsl:param name="st_Company"/>
	<xsl:param name="st_DataObject_Properties"/>
	<xsl:param name="st_Data_Type"/>
	<xsl:param name="st_Decomposed_Diagram"/>
	<xsl:param name="st_Default_Value"/>
	<xsl:param name="st_Description"/>
	<xsl:param name="st_Diagram"/>
	<xsl:param name="st_Diagram_Navigator"/>
	<xsl:param name="st_Do"/>
	<xsl:param name="st_Documentation"/>
	<xsl:param name="st_Element"/>
	<xsl:param name="st_File_Name"/>
	<xsl:param name="st_End"/>
	<xsl:param name="st_Entry"/>
	<xsl:param name="st_Exit"/>
	<xsl:param name="st_Extension_Points"/>
	<xsl:param name="st_Extracted_Text"/>
	<xsl:param name="st_Foreign_Key"/>
	<xsl:param name="st_From"/>
	<xsl:param name="st_Initial_Value"/>
	<xsl:param name="st_InputSets"/>
	<xsl:param name="st_IORules"/>
	<xsl:param name="st_Jump_to"/>
	<xsl:param name="st_Mapped_Attribute"/>
	<xsl:param name="st_Mapped_Class"/>
	<xsl:param name="st_Mapped_Column"/>
	<xsl:param name="st_Mapped_Table"/>
	<xsl:param name="st_Model_Navigator"/>
	<xsl:param name="st_Models"/>
	<xsl:param name="st_Multiplicity"/>
	<xsl:param name="st_Name"/>
	<xsl:param name="st_Navigable"/>
	<xsl:param name="st_No"/>
	<xsl:param name="st_Nullable"/>
	<xsl:param name="st_Operations_Detail"/>
	<xsl:param name="st_Operations_Overview"/>
	<xsl:param name="st_OutputSets"/>
	<xsl:param name="st_Parameters"/>
	<xsl:param name="st_Problem_Statement"/>
	<xsl:param name="st_Procedures_Detail"/>
	<xsl:param name="st_Process"/>
	<xsl:param name="st_Project_Description"/>
	<xsl:param name="st_Properties"/>
	<xsl:param name="st_Redefined_State"/>
	<xsl:param name="st_References"/>
	<xsl:param name="st_Relationships"/>
	<xsl:param name="st_Relationships_Detail"/>
	<xsl:param name="st_Relationships_Summary"/>
	<xsl:param name="st_Responsibilities"/>
	<xsl:param name="st_Return_Type"/>
	<xsl:param name="st_Role"/>
	<xsl:param name="st_Show_All_Class_Models"/>
	<xsl:param name="st_Show_All_Diagrams"/>
	<xsl:param name="st_Show_All_Models"/>
	<xsl:param name="st_Sub_Diagrams"/>
	<xsl:param name="st_Subprocess_Properties"/>
	<xsl:param name="st_Summary"/>
	<xsl:param name="st_System_Response"/>
	<xsl:param name="st_Tagged_Values"/>
	<xsl:param name="st_Task_Properties"/>
	<xsl:param name="st_Task_Type"/>
	<xsl:param name="st_Template_Parameters"/>
	<xsl:param name="st_Transaction"/>
	<xsl:param name="st_Triggers_Detail"/>
	<xsl:param name="st_Text"/>
	<xsl:param name="st_This_report_is_generated_by"/>
	<xsl:param name="st_To"/>
	<xsl:param name="st_Type"/>
	<xsl:param name="st_Type_Modifier"/>
	<xsl:param name="st_Unspecified"/>
	<xsl:param name="st_Use_Case_Descriptions"/>
	<xsl:param name="st_Value"/>
	<xsl:param name="st_Variables"/>
	<xsl:param name="st_Visibility"/>
	<xsl:param name="st_Visual_Paradigm_Project_Publisher"/>
	<xsl:param name="st_Yes"/>
	
	<xsl:template match="/">
		<xsl:call-template name="constructIndexPage" />
	</xsl:template>

	<xsl:template name = "constructIndexPage">
		<html>
		<head>
		<title><xsl:value-of select="$report_name"/></title>
		</head>
		<frameset rows="*" cols="23%,77%">
			<frameset rows="40%, *" cols="*">
				<frame src="{concat($content_dir_name, '/', $DIAGRAM_NAVIGATOR_PAGE_NAME)}" name="{$NAVIGATOR_PANE_NAME}" scrolling="auto"/>
				<frame src="{concat($content_dir_name, '/', $BLANK_MENU_PAGE_NAME)}" name="{$MENU_PANE_NAME}" scrolling="auto"/>
			</frameset>
			<xsl:choose>
				<xsl:when test="$opt_default_diagram_id='Unspecifieda'">
					<frame src="{concat($content_dir_name, '/', $PROJCET_CONTENT_PAGE_NAME)}" name="{$CONTENT_PANE_NAME}" scrolling="auto"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="diagram" select="//Project/Diagrams/Diagram[@id=$opt_default_diagram_id]"/>
					<xsl:choose>
						<xsl:when test="count($diagram)=0">
							<frame src="{concat($content_dir_name, '/', $PROJCET_CONTENT_PAGE_NAME)}" name="{$CONTENT_PANE_NAME}" scrolling="auto"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="filename" select="concat($diagram/@diagramType, '_', $diagram/@id, '.html')" />
							<frame src="{concat($content_dir_name, '/', $filename)}" name="{$CONTENT_PANE_NAME}" scrolling="auto"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</frameset>
		<body>
		</body>
		</html>
		
		<!-- Navigator panes -->
		<xsl:call-template name="drawDiagramNavigatorPane" />
		<xsl:call-template name="drawModelNavigatorPane" />
		
		<xsl:if test="$support_class_diagram = 'true'">
			<xsl:call-template name="drawClassModelNavigatorPane" />
		</xsl:if>
		
		<!-- Menu panes -->
		<xsl:call-template name="generateDiagramMenus"/>
		<xsl:call-template name="generateModelMenus"/>
		<xsl:call-template name="generateClassModelMenus"/>
		<xsl:call-template name="constructBlankModelMenuPage" />
		
		<!-- Content pages -->
		<xsl:call-template name="generateFrontCoverContent"/>
		<xsl:call-template name="generateDiagramContent"/>
		<xsl:call-template name="generateModelContent"/>

		<!-- construct icon XML file -->
		<redirect:write file="{$icon_file_path}">
			<xsl:element name="Icons">
				<xsl:element name="ModelTypes">
					<xsl:for-each select="//Model">
						<xsl:element name="ModelType">
							<xsl:attribute name="name"><xsl:value-of select="@modelType"/></xsl:attribute>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
				<xsl:element name="ShapeTypes">
					<xsl:for-each select="//Shape[not(@modelType) or @modelType='']">
						<xsl:element name="ShapeType">
							<xsl:attribute name="name"><xsl:value-of select="@shapeType"/></xsl:attribute>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
				<xsl:element name="DiagramTypes">
					<xsl:for-each select="//Diagram">
						<xsl:element name="DiagramTypes">
							<xsl:attribute name="name"><xsl:value-of select="@diagramType"/></xsl:attribute>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
		</redirect:write>
		
		
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/../', $INDEX_WITHOUT_MENU_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head>
			<title><xsl:value-of select="$report_name"/></title>
			</head>
			
			<frameset rows="*" cols="0%,100%">
				<frameset rows="40%, *" cols="*">
					<frame src="{concat($content_dir_name, '/', $DIAGRAM_NAVIGATOR_PAGE_NAME)}" name="{$NAVIGATOR_PANE_NAME}" scrolling="auto"/>
					<frame src="{concat($content_dir_name, '/', $BLANK_MENU_PAGE_NAME)}" name="{$MENU_PANE_NAME}" scrolling="auto"/>
				</frameset>
				<xsl:choose>
					<xsl:when test="$opt_default_diagram_id='Unspecifieda'">
						<frame src="{concat($content_dir_name, '/', $PROJCET_CONTENT_PAGE_NAME)}" name="{$CONTENT_PANE_NAME}" scrolling="auto"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="diagram" select="//Project/Diagrams/Diagram[@id=$opt_default_diagram_id]"/>
						<xsl:variable name="filename" select="concat($diagram/@diagramType, '_', $diagram/@id, '.html')" />
						<frame src="{concat($content_dir_name, '/', $filename)}" name="{$CONTENT_PANE_NAME}" scrolling="auto"/>
					</xsl:otherwise>
				</xsl:choose>
			</frameset>
			
			<body>
			</body>
			</html>
		</redirect:write>
		
	</xsl:template>
	
	<xsl:template name = "constructBlankModelMenuPage">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $BLANK_MENU_PAGE_NAME)" />
		<redirect:write file="{$filename}">
			<html>
			<head></head>
			<body></body>
			</html>
		</redirect:write>
	</xsl:template>

</xsl:stylesheet>
