<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>


<xsl:include href="C_ActionContent.xsl" />
<xsl:include href="C_ActivityContent.xsl" />
<xsl:include href="C_ActivityPartitionContent.xsl" />
<xsl:include href="C_ActivitySwimlaneContent.xsl" />
<xsl:include href="C_ActorContent.xsl" />
<xsl:include href="C_BPDataObjectContent.xsl" />
<xsl:include href="C_BPEventContent.xsl" />
<xsl:include href="C_BPGatewayContent.xsl" />
<xsl:include href="C_BPGroupContent.xsl" />
<xsl:include href="C_BPLaneContent.xsl" />
<xsl:include href="C_BPPoolContent.xsl" />
<xsl:include href="C_BPSubprocessContent.xsl" />
<xsl:include href="C_BPTaskContent.xsl" />
<xsl:include href="C_BPTextAnnotationContent.xsl" />
<xsl:include href="C_ClassContent.xsl" />
<xsl:include href="C_CollaborationContent.xsl" />
<xsl:include href="C_ConditionalNodeContent.xsl" />
<xsl:include href="C_CRCCardContent.xsl" />
<xsl:include href="C_Component.xsl" />
<xsl:include href="C_DBStoredProceduresContent.xsl" />
<xsl:include href="C_DBTriggersContent.xsl" />
<xsl:include href="C_DBStoredProcedureResultSetContent.xsl" />
<xsl:include href="C_DFProcessContent.xsl" />
<xsl:include href="C_DiagramOverviewContent.xsl" />
<xsl:include href="C_EntityContent.xsl" />
<xsl:include href="C_Frame.xsl" />
<xsl:include href="C_InteractionContent.xsl" />
<xsl:include href="C_InteractionLifeLineContent.xsl" />
<xsl:include href="C_LoopNodeContent.xsl" />
<xsl:include href="C_ModelContent.xsl" />
<xsl:include href="C_NARYContent.xsl" />
<xsl:include href="C_PackageContent.xsl" />
<xsl:include href="C_RequirementContent.xsl" />
<xsl:include href="C_StateContent.xsl" />
<xsl:include href="C_StructuredActivityNodeContent.xsl" />
<xsl:include href="C_SubsystemContent.xsl" />
<xsl:include href="C_SwimlaneContent.xsl" />
<xsl:include href="C_SystemContent.xsl" />
<xsl:include href="C_TestCaseContent.xsl" />
<xsl:include href="C_UIComponent.xsl" />
<xsl:include href="C_UseCaseContent.xsl" />

<xsl:include href="C_GeneralContent.xsl" />
<xsl:include href="diagram/diagram_main.xsl" />
<xsl:include href="C_ModelContentTemplateRepository.xsl" />
<xsl:include href="C_RelationshipDetailContent.xsl" />

<xsl:include href="C_RequirementModelContent.xsl" />
<xsl:include href="C_RegionContent.xsl" />

<xsl:include href="AvailableModelElementChecker.xsl" />

	<xsl:output method="html" indent="yes"/>
	
	<xsl:template name = "generateFrontCoverContent">
		<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $PROJCET_CONTENT_PAGE_NAME)" />
		<xsl:variable name="project_node" select="//Project"/>
		
		<redirect:write file="{$filename}">
			<html>
			<head>
			<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
			<title></title>
			</head>
			<body style="margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px;">
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<center><span class="ProjectTitle1"><xsl:value-of select="$report_name"/></span></center>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<p>&nbsp;</p>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td width="40%"></td>
						<td width="60%">
							<table width="100%"  border="0" cellpadding="0" cellspacing="0">
								<tr><td class="TableHeaderLine" colspan="4"/></tr>
								<tr><td class="TableHeaderLine1" colspan="4"/></tr>
								<tr class="TableHeader">
									<td style="width: 10px"/>
									<td width="30%"/>
									<td style="width: 20px"/>
									<td/>
								</tr>
								<tr><td class="TableHeaderLine2" colspan="4"/></tr>
								<xsl:if test="$project_node/@author != ''">
									<tr class = "TableRow1">
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$st_Author"/></span></td>
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$project_node/@author" disable-output-escaping="yes"/>&nbsp;</span></td>
									</tr>
								</xsl:if>
								<xsl:if test="$project_node/@company != ''">
									<tr class = "TableRow2">
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$st_Company"/></span></td>
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$project_node/@company" disable-output-escaping="yes"/>&nbsp;</span></td>
									</tr>
								</xsl:if>
								<xsl:if test="$project_node/@description != ''">
									<tr class = "TableRow1">
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$st_Project_Description"/></span></td>
										<td/>
										<td><span class="TableContent"><xsl:value-of select="$project_node/@description" disable-output-escaping="yes"/>&nbsp;</span></td>
									</tr>
								</xsl:if>
							</table>
							<table width = "100%" border="0" cellpadding="0" cellspacing="0">
								<tr><td style="height: 1px"/></tr>
								<tr><td class="TableFooter"/></tr>
							</table>
							<table width = "100%" border="0" cellpadding="0" cellspacing="0">
								<tr><td style="height: 3px"/></tr>
							</table>
							<table width = "100%" border="0" cellpadding="0" cellspacing="0">
								<tr class = "TableRow1"><td><span class="TableContent"><xsl:value-of select="$st_This_report_is_generated_by"/>&nbsp;</span><a href="http://www.visual-paradigm.com" class="ItemLink" target="_blank"><xsl:value-of select="$st_Visual_Paradigm_Project_Publisher"/></a></td></tr>
							</table>
						</td>
					</tr>
				</table>
				<p/>
			</body>
			</html>
		</redirect:write>		
		
	</xsl:template>
	
	<xsl:template name = "generateDiagramContent">
		<xsl:call-template name="printDiagramContentPage"/>
	</xsl:template>
	 
	<!-- */* Activation is available for content but not in model tree -->
	<!-- 
	24/4/2006 added InteractionOperand, Message, Deployment Specification, NOTE (Note)
	 -->
	<xsl:template name = "generateModelContent">
		<xsl:for-each select="//Project/Models//Model">
			<xsl:if test="@modelType != 'ActivityPartition' or (@modelType = 'ActivityPartition' and (../@name='horizontalPartitions' or ../@name='verticalPartitions'))">
				<xsl:variable name="isContentPageAvailable">
					<xsl:call-template name="isContentPageAvailable">
			      <xsl:with-param name="model_node" select="."/>
					</xsl:call-template>
				</xsl:variable>
			
				<xsl:if test="$isContentPageAvailable = 'true'">
					<xsl:variable name="model_type" select="@modelType" />
					<xsl:variable name="display_model_type" select="@displayModelType" />
					<xsl:variable name="model_id" select="@id" />
					<xsl:variable name="model_name" select="@name" />
		
					<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $model_type, '_', $model_id, '.html')" />
					<redirect:write file="{$filename}">
						<html>
						<head>
						<xsl:variable name="documentation" select="./ModelProperties/HTMLProperty[@name = 'documentation']/@plainTextValue "/>
						<xsl:if test="$documentation != ''">
							<META name="Description" content="{$documentation}"/>
						</xsl:if>
						<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
						<title><xsl:value-of select="$display_model_type"/> - <xsl:value-of select="$model_name"/></title>
						</head>
						<body style="margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px;">
						
							<xsl:if test="$opt_is_generate_page_header = 'true'">
								<xsl:call-template name="drawContentPageHeader">
									<xsl:with-param name="report_name" select="$report_name"/>
								</xsl:call-template>
							</xsl:if>
							
							<!-- Page parent title -->
							<p>
								<xsl:choose>
									<xsl:when test="../../../@modelType='ActivitySwimlane2'">
										<xsl:variable name="url" select="concat(../../../@modelType, '_', ../../../@id, '.html')"/>
										<xsl:variable name="parent_name" select="../../../@name"/>
										<xsl:variable name="parent_type" select="../../../@displayModelType"/>
										<a href="{$url}" class="PageParentTitle"><xsl:value-of select="concat($parent_name, ' : ', $parent_type)"/></a><span class="PageParentTitle"></span>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates mode="printParentHierarchyWithHyperlink" select=".">
											<xsl:with-param name="seperator_text" select="''"/>
										</xsl:apply-templates>
									</xsl:otherwise>
								</xsl:choose>
							</p>
							
							<!-- Page title -->
							<xsl:if test="$opt_is_display_model_element_page_title = 'true'">
								<p class="PageTitle"><xsl:value-of select="$display_model_type"/> - <xsl:value-of select="$model_name"/>
								<xsl:if test="$model_type = 'BPSubProcess' and count(./ModelProperties/DiagramRefProperty[@name = 'diagramId']/DiagramRef)>0">
										<xsl:variable name = "diagram_id_property_node" select="./ModelProperties/DiagramRefProperty[@name = 'diagramId']"/>
										<xsl:variable name = "diagram_ref_node" select="$diagram_id_property_node/DiagramRef"/>
										<xsl:variable name = "model_content_page_url" select="concat($diagram_ref_node/@diagramType, '_', $diagram_ref_node/@id, '.html')"/>
										&nbsp;[
										<a href = "{$model_content_page_url}" class = "PageTitleLink"  target = "{@CONTENT_PANE_NAME}">Open Diagram</a>
										]
								</xsl:if>
								</p>
							</xsl:if>
		
							<xsl:choose>
								<xsl:when test="$opt_is_generate_only_documentation_in_model_page='true'">
									<p/>
									<table width = "100%" border="0" cellpadding="0" cellspacing="0">
										<tr><td class="Category"><xsl:value-of select="$st_Documentation"/></td></tr>
										<tr><td style="height: 5px"></td></tr>
									</table>
								
									<xsl:if test="./ModelProperties/HTMLProperty/@plainTextValue != ''">
										<p>
											<table width="100%"  border="0" cellpadding="0" cellspacing="0">
												<tr><td><span class="TableContent"><xsl:value-of select="./ModelProperties/HTMLProperty/@value" disable-output-escaping="yes"/></span></td></tr>
											</table>
										</p>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<!-- Use apply-templates to print the content -->
									<xsl:apply-templates select="." mode="model_content"/>
								</xsl:otherwise>
							</xsl:choose>
							
							<!-- Footer -->
							<xsl:if test="$opt_is_generate_page_footer = 'true'">
								<xsl:call-template name="drawContentPageFooter">
									<xsl:with-param name="report_name" select="$report_name"/>
								</xsl:call-template>
							</xsl:if>
						</body>
						</html>
					</redirect:write>
				
				</xsl:if>
		
		
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	

	
</xsl:stylesheet>
