<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='UseCase']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>

		<!-- Extension Points table -->
		<xsl:call-template name="printExtensionPointsTable"/>
		
		<!-- Use Case Descriptions -->
		<xsl:call-template name="printUseCaseDescriptionTable"/>
		
		<!-- Tagged Values -->
		<xsl:call-template name="printTaggedValueTable"/>
			
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
	
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
	
	<!-- Use Case Description table -->
	<xsl:template name="printUseCaseDescriptionTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name = 'UseCaseDescription']/* | ./ModelProperties/ModelsProperty[@name = 'alternativeUseCaseDescriptions']/*) > 0">
		
			<!-- Links -->
		
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Use_Case_Descriptions"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="2"/></tr>
				<tr><td class="TableHeaderLine1" colspan="2"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="2"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name = 'UseCaseDescription']/Model | ./ModelProperties/ModelsProperty[@name = 'alternativeUseCaseDescriptions']/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
			
			<!-- Actual content -->
			<xsl:for-each select="./ModelProperties/ModelProperty[@name = 'UseCaseDescription']/Model | ./ModelProperties/ModelsProperty[@name = 'alternativeUseCaseDescriptions']/Model">
				<p/>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td style="width: 120px"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ChildModels/Model">
						<xsl:sort select="./ModelProperties/IntegerProperty[@name='sequenceNumber']/@value" data-type="number" order="ascending"/>
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='name']/@rtfValue" disable-output-escaping="yes"/></span></td>
							<td/>
							<xsl:choose>
								<xsl:when test="@modelType = 'FlowOfEventItemContainer'">
									<td>
										<table width="100%"  border="0" cellpadding="0" cellspacing="0">
											<tr class="SubtableHeader">
												<td style="width: 10px"/>
												<td width="5px"><span class="TableHeaderText"></span></td>
												<td style="width: 10px"/>
												<td>
													<table width="100%"  border="0" cellpadding="0" cellspacing="0">
														<tr>
															<td width="50%"><span class="TableHeaderText"><xsl:value-of select="./ModelProperties/StringProperty[@name='inputHeader']/@value"/></span></td>
															<td width="50%"><span class="TableHeaderText"><xsl:value-of select="./ModelProperties/StringProperty[@name='responseHeader']/@value"/></span></td>
														</tr>
													</table>
												</td>
											</tr>
											<tr><td class="TableHeaderLine2" colspan="4"/></tr>
											<xsl:for-each select="./ChildModels/Model[@modelType='FlowOfEventItem']">
												<xsl:sort select="./ModelProperties/IntegerProperty[@name='sequenceNumber']" data-type="number"/>
												<tr>
													<xsl:choose>
														<xsl:when test="position() mod 2 = 1">
															<xsl:attribute name="class">TableRow1</xsl:attribute> 
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="class">TableRow2</xsl:attribute> 
														</xsl:otherwise>
													</xsl:choose>
													<td style="width: 10px"/>
													<td width="5px"><span class="TableContent"><xsl:value-of select="./ModelProperties/IntegerProperty[@name='sequenceNumber']/@value"/></span></td>
													<td style="width: 10px"/>
													<td>
														<table width="100%"  border="0" cellpadding="0" cellspacing="0">
															<tr>
																<xsl:choose>
																	<xsl:when test="./ModelProperties/StringProperty[@name='eventType']/@value = 'Input'">
																		<td width="50%"><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='value']/@rtfValue" disable-output-escaping="yes"/></span></td>
																		<td width="50%"><span class="TableContent"></span></td>
																	</xsl:when>
																	<xsl:when test="./ModelProperties/StringProperty[@name='eventType']/@value = 'Response'">
																		<td width="50%"><span class="TableContent"></span></td>
																		<td width="50%"><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='value']/@rtfValue" disable-output-escaping="yes"/></span></td>
																	</xsl:when>
																</xsl:choose>
															</tr>
														</table>
													</td>
												</tr>
											</xsl:for-each>
										</table>
									</td>							
								</xsl:when>
								<xsl:otherwise>
									<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='value']/@rtfValue" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>	
	
		<!-- Extension Points table -->
	<xsl:template name="printExtensionPointsTable">
		<xsl:if test="count(./FromSimpleRelationships/Model[@modelType='Extend']/ModelProperties/ModelProperty[@name='extensionPoint']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Extension_Points"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each extension point is a table -->
			<xsl:for-each select="./FromSimpleRelationships/Model[@modelType='Extend']/ModelProperties/ModelProperty[@name='extensionPoint']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or @name = 'returnType' or (@name = 'documentation' and @plainTextValue != '') or (@name = 'taggedValues' and count(./Model)>0) or (@name = 'comments' and count(./Model)>0) or (@name = 'references' and count(./Model)>0) or (@name = 'constraints' and count(./ModelRef)>0)]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'documentation'">
									<xsl:if test="@plainTextValue != ''">
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
									</xsl:if>
								</xsl:when>
								<xsl:when test="@name = 'taggedValues'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><xsl:apply-templates select="." mode="printTaggedValueSubtable"/></td>
								</xsl:when>
								<xsl:when test="@name = 'comments'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><xsl:apply-templates select="." mode="printCommentsSubtable"/></td>
								</xsl:when>
								<xsl:when test="@name = 'references'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
								</xsl:when>
								<xsl:when test="@name = 'constraints'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><xsl:apply-templates mode="printConstraintsTable" select="."/></td>
								</xsl:when>
						
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
