<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='Requirement']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>
		
		<!-- Tagged Values -->
		<xsl:call-template name="printRequirementAttributeTable"/>
				
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
	
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
		
	<!-- Requirement Attribute table -->
	<xsl:template name="printRequirementAttributeTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='taggedValues']/Model[@modelType = 'TaggedValueContainer']/ChildModels/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Attributes"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="6"/></tr>
				<tr><td class="TableHeaderLine1" colspan="6"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='taggedValues']/Model[@modelType = 'TaggedValueContainer']/ChildModels/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='type']/@value"/></span></td>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="count(./ModelProperties/TextModelProperty[@name='value']/ModelRef) > 0">
								<xsl:variable name="model_ref_node" select="./ModelProperties/TextModelProperty[@name='value']/ModelRef"/>
								<xsl:variable name="isContentPageAvailable">
									<xsl:call-template name="isContentPageAvailable">
							      <xsl:with-param name="model_node" select="$model_ref_node"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$isContentPageAvailable = 'true'">		
										<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
										<td>
											<span class="TableContent">
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
												<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
												</a>
											</span>
										</td>
									</xsl:when>
									<xsl:otherwise>		
										<td>
											<span class="TableContent">
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>
												<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
											</span>
										</td>
									</xsl:otherwise>
								</xsl:choose>		
							</xsl:when>
							<xsl:when test="count(./ModelProperties/HTMLProperty[@name='value']) > 0">
								<td><span class="TableContent"><xsl:value-of select="./ModelProperties/HTMLProperty[@name='value']/@value" disable-output-escaping="yes"/></span></td>
							</xsl:when>
							<xsl:otherwise>
							  <xsl:variable name="attributeWithMultipleLines">
									<xsl:call-template name="replace">
										<xsl:with-param name="string" select="./ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/>
										<xsl:with-param name="pattern" select="'&#10;'"/>
										<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
									</xsl:call-template>		
								</xsl:variable>		
								<td><span class="TableContent"><xsl:value-of select="$attributeWithMultipleLines" disable-output-escaping="yes"/></span></td>
							</xsl:otherwise>
						</xsl:choose>		
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
