<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<!-- Relationship detail table -->
	<xsl:template name="printRelationshipDetailTable">
		<xsl:if test="count(./ToEndRelationships/* | ./FromEndRelationships/* | ./ToSimpleRelationships/*  | ./FromSimpleRelationships/*) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Relationships_Detail"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each association or message (sequence) is a table -->
			<xsl:for-each select="ToEndRelationships/* | FromEndRelationships/* ">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<xsl:apply-templates select="." mode="printEndRelationshipDetailTable"/>
	
			</xsl:for-each>
			
			<!--  each relationship is a table -->
			<xsl:for-each select="ToSimpleRelationships/* | FromSimpleRelationships/* ">
				<xsl:variable name="relationship_id" select="@id"/>
				<xsl:variable name="from_ref_node" select="./ModelProperties/ModelRefProperty[@name='from']/ModelRef"/>
				<xsl:variable name="to_ref_node" select="./ModelProperties/ModelRefProperty[@name='to']/ModelRef"/>
				
				<!-- place the anchor name here -->
				<a name="{$relationship_id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[@value != '' or @name='from' or @name='to' or @name='replacedTransition' or (@name = 'references' and count(./Model) > 0)]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'from'">
									<xsl:variable name="url" select="concat($from_ref_node/@modelType, '_', $from_ref_node/@id, '.html')"/>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="$st_From"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent">
										<xsl:if test="$from_ref_node/@id != ''">
											<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $from_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $from_ref_node/@modelType, '.png')}');"/>&nbsp;
											<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
												<xsl:value-of select="concat($from_ref_node/@name, ' : ', $from_ref_node/@displayModelType)"/>
											</a>
										</xsl:if>
										</span>
									</td>
								</xsl:when>
								<xsl:when test="@name = 'to'">
									<xsl:variable name="url" select="concat($to_ref_node/@modelType, '_', $to_ref_node/@id, '.html')"/>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="$st_To"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent">
										<xsl:if test="$to_ref_node/@id != ''">
											<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $to_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $to_ref_node/@modelType, '.png')}');"/>&nbsp;
											<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink"> 
												<xsl:value-of select="concat($to_ref_node/@name, ' : ', $to_ref_node/@displayModelType)"/>
											</a>
										</xsl:if>
										</span>
									</td>
								</xsl:when>
								<xsl:when test="@name = 'replacedTransition'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:apply-templates select="." mode="printReplacedTransitionValueCellContent"/></span></td>
								</xsl:when>
								<xsl:when test="@name = 'modelType'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="$st_Type"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./../../@displayModelType" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:when test="@name = 'references'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="$st_References"/></span></td>
									<td style="width: 20px"/>
									<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>		
		
	</xsl:template>
	
	
	<!-- Association detail table -->
	<xsl:template match="*[@modelType='Association']" mode="printEndRelationshipDetailTable">
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@name != 'documentation' and @value != '') or @name='endRelationshipFromMetaModelElement' or @name='endRelationshipToMetaModelElement' or (@name = 'documentation' and @plainTextValue!='') or (@name = 'references' and count(./Model) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'endRelationshipFromMetaModelElement'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_From"/></span></td>
							<td style="width: 20px"/>
							<td>
								<span class="TableContent">
									<table width="100%"  border="0" cellpadding="0" cellspacing="0">
										<tr class="SubtableHeader">
											<td style="width: 10px"/>
											<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
										</tr>
										<tr><td class="TableHeaderLine2" colspan="4"/></tr>
										<tr class="TableRow1">
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Role"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../FromEnd/Model/@name"/></span></td>
										</tr>
										<tr class="TableRow2">
											<xsl:variable name="from_ref_node" select="./ModelRef"/>
											<xsl:variable name="url" select="concat($from_ref_node/@modelType, '_', $from_ref_node/@id, '.html')"/>
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Element"/></span></td>
											<td style="width: 20px"/>
											<td>
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $from_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $from_ref_node/@modelType, '.png')}');"/>&nbsp;
												<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
												<xsl:value-of select="concat($from_ref_node/@name, ' : ', $from_ref_node/@displayModelType)"/>
												</a>
											</td>
										</tr>
										<tr class="TableRow1">
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Multiplicity"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../FromEnd/Model/ModelProperties/StringProperty[@name='multiplicity']/@value"/></span></td>
										</tr>
										<tr class="TableRow2">
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Navigable"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../FromEnd/Model/ModelProperties/StringProperty[@name='navigable']/@value"/></span></td>
										</tr>
										<!-- Show property strings if defined -->
										<xsl:variable name="propertyStringsProperty" select="../../FromEnd/Model/ModelProperties/ModelProperty[@name='propertyStrings']"/>
										<xsl:if test="count($propertyStringsProperty/Model) != 0">
											<tr class="TableRow1">
												<td style="width: 10px"/>
												<td><span class="TableContent"><xsl:value-of select="$propertyStringsProperty/@displayName"/></span></td>
												<td style="width: 20px"/>
												<td>
													<table width="100%"  border="0" cellpadding="0" cellspacing="0">
														<tr class="SubtableHeader">
															<td style="width: 10px"/>
															<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
															<td style="width: 20px"/>
															<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
														</tr>
														<tr><td class="TableHeaderLine2" colspan="4"/></tr>
														<xsl:for-each select="$propertyStringsProperty/Model/ModelProperties/*[(@name != 'modelType' and (@name!='documentation' and @value != '')) or (@name='documentation' and @plainTextValue!='') or (@name='redefines' and count(./Model) != 0)]">
															<tr class="TableRow1">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 1">
																		<xsl:attribute name="class">TableRow1</xsl:attribute> 
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:attribute name="class">TableRow2</xsl:attribute> 
																	</xsl:otherwise>
																</xsl:choose>
																<xsl:choose>
																	<xsl:when test="@name='redefines'">
																		<td style="width: 10px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
																		<td style="width: 20px"/>
																		<td>
																		<!-- evaluate the path for redefines -->
																		<xsl:choose>
																			<xsl:when test="./Model/@endRoleName!=''">
																				<xsl:choose>
																					<xsl:when test="./Model/@endId=./Model/ModelProperties/ModelRefProperty[@name='fromAssociationEnd']/ModelRef/@id">
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="./Model/@endRoleName"/>
																							<xsl:with-param name="roleAB" select="'Role A of ('"/>
																						</xsl:call-template>	
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="./Model/@endRoleName"/>
																							<xsl:with-param name="roleAB" select="'Role B of ('"/>
																						</xsl:call-template>																				
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:choose>
																					<xsl:when test="(./Model/@endId)=(./Model/ModelProperties/ModelRefProperty[@name='fromAssociationEnd']/ModelRef/@id)">
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="'&lt;unnamed&gt;'"/>
																							<xsl:with-param name="roleAB" select="'Role A of ('"/>
																						</xsl:call-template>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="'&lt;unnamed&gt;'"/>
																							<xsl:with-param name="roleAB" select="'Role B of ('"/>
																						</xsl:call-template>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																		</td>
																	</xsl:when>
																	<xsl:otherwise>
																		<td style="width: 10px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
																		<td style="width: 20px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
																	</xsl:otherwise>
																</xsl:choose>
															</tr>	
														</xsl:for-each>
													</table>
												</td>
											</tr>
										</xsl:if>
									</table>
								</span>
							</td>	
						</xsl:when>
						<xsl:when test="@name = 'endRelationshipToMetaModelElement'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_To"/></span></td>
							<td style="width: 20px"/>
							<td>
								<span class="TableContent">
									<table width="100%"  border="0" cellpadding="0" cellspacing="0">
										<tr class="SubtableHeader">
											<td style="width: 10px"/>
											<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
										</tr>
										<tr><td class="TableHeaderLine2" colspan="4"/></tr>
										<tr class="TableRow1">
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Role"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../ToEnd/Model/@name"/></span></td>
										</tr>
										<tr class="TableRow2">
											<xsl:variable name="to_ref_node" select="./ModelRef"/>
											<xsl:variable name="url" select="concat($to_ref_node/@modelType, '_', $to_ref_node/@id, '.html')"/>
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Element"/></span></td>
											<td style="width: 20px"/>
											<td>
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $to_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $to_ref_node/@modelType, '.png')}');"/>&nbsp;
												<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
												<xsl:value-of select="concat($to_ref_node/@name, ' : ', $to_ref_node/@displayModelType)"/>
												</a>
											</td>
										</tr>
										<tr class="TableRow1">
											<td style="width: 10px"/>
											<td><span class="TableContent"><xsl:value-of select="$st_Multiplicity"/></span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../ToEnd/Model/ModelProperties/StringProperty[@name='multiplicity']/@value"/></span></td>
										</tr>
										<tr class="TableRow2">
											<td style="width: 10px"/>
											<td><span class="TableContent">Navigable</span></td>
											<td style="width: 20px"/>
											<td><span class="TableContent"><xsl:value-of select="../../ToEnd/Model/ModelProperties/StringProperty[@name='navigable']/@value"/></span></td>
										</tr>
										<!-- Show property strings if defined -->
										<xsl:variable name="propertyStringsProperty" select="../../ToEnd/Model/ModelProperties/ModelProperty[@name='propertyStrings']"/>
										<xsl:if test="count($propertyStringsProperty/Model) != 0">
											<tr class="TableRow1">
												<td style="width: 10px"/>
												<td><span class="TableContent"><xsl:value-of select="$propertyStringsProperty/@displayName"/></span></td>
												<td style="width: 20px"/>
												<td>
													<table width="100%"  border="0" cellpadding="0" cellspacing="0">
														<tr class="SubtableHeader">
															<td style="width: 10px"/>
															<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
															<td style="width: 20px"/>
															<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
														</tr>
														<tr><td class="TableHeaderLine2" colspan="4"/></tr>
														<xsl:for-each select="$propertyStringsProperty/Model/ModelProperties/*[(@name != 'modelType' and (@name!='documentation' and @value != '')) or (@name='documentation' and @plainTextValue!='') or (@name='redefines' and count(./Model) != 0)]">
															<tr class="TableRow1">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 1">
																		<xsl:attribute name="class">TableRow1</xsl:attribute> 
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:attribute name="class">TableRow2</xsl:attribute> 
																	</xsl:otherwise>
																</xsl:choose>
																<xsl:choose>
																	<xsl:when test="@name='redefines'">
																		<td style="width: 10px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
																		<td style="width: 20px"/>
																		<td>
																		<!-- evaluate the path for redefines -->
																		<xsl:choose>
																			<xsl:when test="./Model/@endRoleName!=''">
																				<xsl:choose>
																					<xsl:when test="./Model/@endId=./Model/ModelProperties/ModelRefProperty[@name='fromAssociationEnd']/ModelRef/@id">
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="./Model/@endRoleName"/>
																							<xsl:with-param name="roleAB" select="'Role A of ('"/>
																						</xsl:call-template>	
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="./Model/@endRoleName"/>
																							<xsl:with-param name="roleAB" select="'Role B of ('"/>
																						</xsl:call-template>																				
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:choose>
																					<xsl:when test="(./Model/@endId)=(./Model/ModelProperties/ModelRefProperty[@name='fromAssociationEnd']/ModelRef/@id)">
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="'&lt;unnamed&gt;'"/>
																							<xsl:with-param name="roleAB" select="'Role A of ('"/>
																						</xsl:call-template>
																					</xsl:when>
																					<xsl:otherwise>
																						<xsl:call-template name="printRedefinedCellContent">
																							<xsl:with-param name="endRoleName" select="'&lt;unnamed&gt;'"/>
																							<xsl:with-param name="roleAB" select="'Role B of ('"/>
																						</xsl:call-template>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																		</td>
																	</xsl:when>
																	<xsl:otherwise>
																		<td style="width: 10px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
																		<td style="width: 20px"/>
																		<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
																	</xsl:otherwise>
																</xsl:choose>
															</tr>	
														</xsl:for-each>
													</table>
												</td>
											</tr>
										</xsl:if>										
									</table>
								</span>
							</td>	
						</xsl:when>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Type"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./../../@displayModelType" disable-output-escaping="yes"/></span></td>
						</xsl:when>
						<xsl:when test="@name = 'references'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_References"/></span></td>
							<td style="width: 20px"/>
							<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>							
					
					
				</tr>
			</xsl:for-each>
			
			<xsl:variable name="previousRowsCounts" select="count(./ModelProperties/*[(@name != 'documentation' and @value != '') or @name='endRelationshipFromMetaModelElement' or @name='endRelationshipToMetaModelElement' or (@name = 'documentation' and @plainTextValue!='')])"/>
			<xsl:for-each select="./*[local-name()='FromSimpleRelationships' or local-name()='ToSimpleRelationships']">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod (2 + previousRowsCounts) = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="$st_Relationships"/></span></td>
					<td style="width: 20px"/>
					<td>
						<xsl:for-each select="./Model">
							<table width="100%"  border="0" cellpadding="0" cellspacing="0">
								<tr class="SubtableHeader">
									<td style="width: 10px"/>
									<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
								</tr>
								<tr><td class="TableHeaderLine2" colspan="4"/></tr>
								<xsl:for-each select="ModelProperties/*[(@name != 'modelType' and (@name!='documentation' and @value != '')) or (@name='documentation' and @plainTextValue!='')]">
									<tr class="TableRow1">
										<xsl:choose>
											<xsl:when test="position() mod 2 = 1">
												<xsl:attribute name="class">TableRow1</xsl:attribute> 
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">TableRow2</xsl:attribute> 
											</xsl:otherwise>
										</xsl:choose>
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
									</tr>	
								</xsl:for-each>
							</table>
						</xsl:for-each>	
					</td>	
				</tr>
			</xsl:for-each>
			
			
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>
	</xsl:template>
	

	<!-- Message detail table -->
	<xsl:template match="*[@modelType='Message']" mode="printEndRelationshipDetailTable">
		<xsl:variable name="from_model_node" select="ModelProperties/ModelRefProperty [@name='endRelationshipFromMetaModelElement']/ModelRef"/>
		<xsl:variable name="to_model_node" select="ModelProperties/ModelRefProperty [@name='endRelationshipToMetaModelElement']/ModelRef"/>
		
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@name!='modelType' and @value != '') or @name='endRelationshipFromMetaModelElement' or @name='endRelationshipToMetaModelElement' or (@name='actionType' and count(./*) > 0) or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0) or (@name = 'references' and count(./Model) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'endRelationshipFromMetaModelElement'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_From"/></span></td>
							<td style="width: 20px"/>
							<td>
								<xsl:if test="$from_model_node/@id != ''">
									<xsl:variable name="url" select="concat($from_model_node/@modelType, '_', $from_model_node/@id, '.html')"/>
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $from_model_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $from_model_node/@modelType, '.png')}');"/>&nbsp;
									<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="concat($from_model_node/@name, ' : ', $from_model_node/@displayModelType)"/>
									</a>
								</xsl:if>
							</td>
						</xsl:when>
						<xsl:when test="@name = 'endRelationshipToMetaModelElement'">
							<td style="width: 10px"/>
							<td><span class="TableContent">To</span></td>
							<td style="width: 20px"/>
							<td>
								<xsl:if test="$to_model_node/@id != ''">
									<xsl:variable name="url" select="concat($to_model_node/@modelType, '_', $to_model_node/@id, '.html')"/>
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $to_model_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $to_model_node/@modelType, '.png')}');"/>&nbsp;
									<a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="concat($to_model_node/@name, ' : ', $to_model_node/@displayModelType)"/>
									</a>
								</xsl:if>
							</td>
						</xsl:when>
						<xsl:when test="@name = 'actionType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><xsl:apply-templates select="./Model" mode="printActionTypeSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'references'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_References"/></span></td>
							<td style="width: 20px"/>
							<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;

														<xsl:variable name="isContentPageAvailable">
															<xsl:call-template name="isContentPageAvailable">
													      <xsl:with-param name="model_node" select="."/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$isContentPageAvailable = 'true'">
																<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
																<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
																</a>
															</xsl:when>
															<xsl:when test="@modelType = 'Operation'">
																<xsl:variable name="url2" select="concat(@parentModelType, '_', @parentId, '.html#', @id)"/>
																<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
																<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
																</a>
															</xsl:when>
															<xsl:otherwise>
																<span class="TableContent"><xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/></span>
															</xsl:otherwise>
														</xsl:choose>				
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;

														<xsl:variable name="isContentPageAvailable">
															<xsl:call-template name="isContentPageAvailable">
													      <xsl:with-param name="model_node" select="."/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$isContentPageAvailable = 'true'">
																<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
																<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
																</a>														
															</xsl:when>
															<xsl:otherwise>
																<span class="TableContent"><xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/></span>
															</xsl:otherwise>
														</xsl:choose>	
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>
	
	<!-- Action type sub-table (for general action types) -->
	<xsl:template match="ModelProperty[@name='actionType']/Model[@modelType='ActionTypeCreate' or @modelType='ActionTypeDestroy' or @modelType='ActionTypeReturn' or @modelType='ActionTypeUninterpreted' or @modelType='ActionTypeSend' or @modelType='ActionTypeTerminate']" mode="printActionTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[@value != '' and @name != 'name']">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Action_Type"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>

	<!-- Action type sub-table (for call actions) -->
	<xsl:template match="ModelProperty[@name='actionType']/Model[@modelType='ActionTypeCall']" mode="printActionTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'name') or (@name = 'operation' and count(./ModelRef) > 0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Action_Type"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:when test="@name = 'operation'">
							<xsl:variable name="operation_ref_node" select="./ModelRef"/>
							<xsl:variable name="url" select="concat($operation_ref_node/@parentModelType, '_', $operation_ref_node/@parentId, '.html#', $operation_ref_node/@id)"/>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><a href="{$url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
							<xsl:value-of select="$operation_ref_node/@name"/>()
							</a></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Action type sub-table (for sequence actions) -->
	<xsl:template match="ModelProperty[@name='actionType']/Model[@modelType='ActionTypeSequence']" mode="printActionTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'name') or (@name = 'operation' and count(./ModelRef) > 0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Action_Type"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>		

	<!-- Replaced transition -->
	<xsl:template match="ModelProperty[@name='replacedTransition']/Model" mode="printReplacedTransitionValueCellContent">
		<!-- icon $name (from -> to) -->
		<xsl:variable name="from_model_ref" select="ModelProperties/ModelRefProperty[@name='from']/ModelRef"/>
		<xsl:variable name="to_model_ref" select="ModelProperties/ModelRefProperty[@name='to']/ModelRef"/>
		
		<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
		<xsl:choose>
			<xsl:when test="count(ModelProperties/ModelRefProperty[@name='from']/ModelRef) > 0">
				<xsl:variable name="url" select="concat($from_model_ref/@modelType, '_', $from_model_ref/@id, '.html', '#', @id)"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@name" />
			</xsl:otherwise>
		</xsl:choose>
		(
		<xsl:choose>
			<xsl:when test="count($from_model_ref) > 0">
				<xsl:variable name="url" select="concat($from_model_ref/@modelType, '_', $from_model_ref/@id, '.html')"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="$from_model_ref/@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				&nbsp;
			</xsl:otherwise>
		</xsl:choose>
		->
		<xsl:choose>
			<xsl:when test="count($to_model_ref) > 0">
				<xsl:variable name="url" select="concat($to_model_ref/@modelType, '_', $to_model_ref/@id, '.html')"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="$to_model_ref/@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				&nbsp;
			</xsl:otherwise>
		</xsl:choose>
		)
	</xsl:template>
	
	<xsl:template name="printRedefinedCellContent">
		<xsl:param name="endRoleName"/>
		<xsl:param name="roleAB"/>

		<span class="TableContent">
		<xsl:value-of select="$endRoleName"/>
		<xsl:value-of select="' - '"/>
		<xsl:value-of select="$roleAB"/>
		</span>
		
		<xsl:variable name="from_model_ref_node" select="./Model/ModelProperties/ModelRefProperty[@name='fromAssociationEndModel']/ModelRef"/>
		<xsl:variable name="from_url" select="concat($from_model_ref_node/@modelType, '_', $from_model_ref_node/@id, '.html')"/>
		<a href="{$from_url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
		<xsl:value-of select="$from_model_ref_node/@name"/>
		</a>
		
		<span class="TableContent"><xsl:value-of select="' -> '"/></span>
		
		<xsl:variable name="to_model_ref_node" select="./Model/ModelProperties/ModelRefProperty[@name='toAssociationEndModel']/ModelRef"/>
		<xsl:variable name="to_url" select="concat($to_model_ref_node/@modelType, '_', $to_model_ref_node/@id, '.html')"/>
		<a href="{$to_url}" target="{@CONTENT_PANE_NAME}" class="ItemLink">
		<xsl:value-of select="$to_model_ref_node/@name"/>
		</a>

		<span class="TableContent"><xsl:value-of select="')'"/></span>
		
	</xsl:template>

</xsl:stylesheet>
