<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<!-- Property table -->
	<xsl:template name="printPropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name!='modelType' and @name!= 'name' and @name!= 'documentation') or (@name = 'diagramId' and count(./DiagramRef) > 0) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'ormDetail' and count(./Model[@modelType='ORMClassDetail']/ModelProperties/ModelRefProperty[@name='tableModel']/ModelRef) > 0) or (@name = 'classModel' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0)]">
				
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td/>
					<td><span class="TableContent">
						<xsl:choose>
							<xsl:when test="@name = 'ormDetail' and count(./Model[@modelType='ORMClassDetail']/ModelProperties/ModelRefProperty[@name='tableModel']/ModelRef) > 0">
								<xsl:value-of select="$st_Mapped_Table"/>
							</xsl:when>
							<xsl:when test="@name = 'classModel' and count(./ModelRef) > 0">
								<xsl:value-of select="$st_Mapped_Class"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@displayName" />
							</xsl:otherwise>
						</xsl:choose>
					</span></td>
					<td/>
					<xsl:choose>
						<xsl:when test="@name = 'stereotypes'">
							<td><span class="TableContent">
							<xsl:for-each select="./ModelRef">
								<xsl:variable name = "stereotype_model_id" select="@id"/>
								<xsl:variable name="stereotype_content_page_url" select="concat(@modelType, '_', $stereotype_model_id, '.html')"/>
								<a href = "{$stereotype_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="@name" /></a>
								<xsl:if test="position() != last()">
									<xsl:value-of select="', '"/>
								</xsl:if>
							</xsl:for-each>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'ormDetail'">
							<td><span class="TableContent">
							<xsl:variable name = "model_ref_node" select="./Model[@modelType='ORMClassDetail']/ModelProperties/ModelRefProperty[@name='tableModel']/ModelRef"/>
							<xsl:variable name="table_model_content_page_url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}');"/>&nbsp;
							<a href = "{$table_model_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
							<xsl:value-of select="$model_ref_node/@name" /> : <xsl:value-of select="$model_ref_node/@displayModelType"/>
							</a>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'diagramId' and count(./DiagramRef)>0">
							<td><span class="TableContent">
							<xsl:variable name = "diagram_ref_node" select = "./DiagramRef"/>
							<xsl:variable name="table_model_content_page_url" select="concat($diagram_ref_node/@diagramType, '_', $diagram_ref_node/@id, '.html')"/>
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $diagram_ref_node/@diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $diagram_ref_node/@diagramType, '.png')}');"/>&nbsp;
							<a href = "{$table_model_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
							<xsl:value-of select="$diagram_ref_node/@name" /> : <xsl:value-of select="$diagram_ref_node/@displayDiagramType"/>
							</a>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'classModel'">
							<td><span class="TableContent">
							<xsl:variable name = "model_ref_node" select="./ModelRef"/>
							<xsl:variable name="class_model_content_page_url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}');"/>&nbsp;
							<a href = "{$class_model_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
							<xsl:value-of select="$model_ref_node/@name" /> : <xsl:value-of select="$model_ref_node/@displayModelType"/>
							</a>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;

														<xsl:variable name="isContentPageAvailable">
															<xsl:call-template name="isContentPageAvailable">
													      <xsl:with-param name="model_node" select="."/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$isContentPageAvailable = 'true'">
																<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
																<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
																</a>
															</xsl:when>
															<xsl:otherwise>
																<span class="TableContent"><xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/></span>
															</xsl:otherwise>
														</xsl:choose>				
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;

														<xsl:variable name="isContentPageAvailable">
															<xsl:call-template name="isContentPageAvailable">
													      <xsl:with-param name="model_node" select="."/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$isContentPageAvailable = 'true'">
																<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
																<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
																</a>														
															</xsl:when>
															<xsl:otherwise>
																<span class="TableContent"><xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/></span>
															</xsl:otherwise>
														</xsl:choose>	
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
					
					
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>
	
	<!-- Relationship table -->
	<xsl:template name="printRelationshipTable">
		<xsl:if test="count(./ToEndRelationships/* | ./FromEndRelationships/* | ./FromSimpleRelationships/* | ./ToSimpleRelationships/*) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Relationships_Summary"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="6"/></tr>
				<tr><td class="TableHeaderLine1" colspan="6"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Begin"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_End"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="ToEndRelationships/* | FromEndRelationships/* | FromSimpleRelationships/* | ToSimpleRelationships/* ">					
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:apply-templates mode="printRelationshipRow" select="."/>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="Model[name(..)= 'FromSimpleRelationships' or name(..) = 'ToSimpleRelationships']" mode="printRelationshipRow">
		<xsl:variable name="relationModelURL" select="concat('#', @id)"/>
		
		<xsl:variable name="fromEndModelRefNode" select="./ModelProperties/ModelRefProperty[@name='from']/ModelRef"/>
		<xsl:variable name="fromEndModelId" select="$fromEndModelRefNode/@id"/>
		<xsl:variable name="fromEndModelName" select="$fromEndModelRefNode/@name"/>
		<xsl:variable name="fromEndModelType" select="$fromEndModelRefNode/@modelType"/>
		<xsl:variable name="fromEndModelDisplayType" select="$fromEndModelRefNode/@displayModelType"/>
		
		<xsl:variable name="toEndModelRefNode" select="./ModelProperties/ModelRefProperty[@name='to']/ModelRef"/>
		<xsl:variable name="toEndModelId" select="$toEndModelRefNode/@id"/>
		<xsl:variable name="toEndModelName" select="$toEndModelRefNode/@name"/>
		<xsl:variable name="toEndModelType" select="$toEndModelRefNode/@modelType"/>
		<xsl:variable name="toEndModelDisplayType" select="$toEndModelRefNode/@displayModelType"/>
		
		<xsl:variable name="fromEndModelURL" select="concat($fromEndModelType, '_', $fromEndModelId, '.html')"/>
		<xsl:variable name="toEndModelURL" select="concat($toEndModelType, '_', $toEndModelId, '.html')"/>
		
		<td style="width: 10px"/>
		<td width="25%">
			<span class="TableContent">
				<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
				<a href = "{$relationModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
				</a>
			</span>
		</td>
		<td style="width: 20px"/>
		<td>
			<span class="TableContent">
				<xsl:if test="$fromEndModelId != ''">
					<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$fromEndModelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$fromEndModelType, '.png')}');"/>&nbsp;
					<a href = "{$fromEndModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
					<xsl:value-of select="$fromEndModelName"/> : <xsl:value-of select="$fromEndModelDisplayType"/>
					</a>
				</xsl:if>
			</span>
		</td>
		<td style="width: 20px"/>
		<td>
			<span class="TableContent">
				<xsl:if test="$toEndModelId != ''">
					<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $toEndModelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $toEndModelType, '.png')}');"/>&nbsp;
					<a href = "{$toEndModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
					<xsl:value-of select="$toEndModelName"/> : <xsl:value-of select="$toEndModelDisplayType"/>
					</a>
				</xsl:if>
			</span>
		</td>
	</xsl:template>
	
	<xsl:template match="Model[name(..) = 'FromEndRelationships' or name(..) = 'ToEndRelationships']" mode="printRelationshipRow">
		<xsl:variable name="relationModelURL" select="concat('#', @id)"/>
		
		<xsl:variable name="fromEndModelRefNode" select="./FromEnd/Model/ModelProperties/ModelRefProperty[@name='EndModelElement']/ModelRef"/>
		<xsl:variable name="fromEndModelId" select="$fromEndModelRefNode/@id"/>
		<xsl:variable name="fromEndModelName" select="$fromEndModelRefNode/@name"/>
		<xsl:variable name="fromEndModelType" select="$fromEndModelRefNode/@modelType"/>
		<xsl:variable name="fromEndModelDisplayType" select="$fromEndModelRefNode/@displayModelType"/>
		
		<xsl:variable name="toEndModelRefNode" select="./ToEnd/Model/ModelProperties/ModelRefProperty[@name='EndModelElement']/ModelRef"/>
		<xsl:variable name="toEndModelId" select="$toEndModelRefNode/@id"/>
		<xsl:variable name="toEndModelName" select="$toEndModelRefNode/@name"/>
		<xsl:variable name="toEndModelType" select="$toEndModelRefNode/@modelType"/>
		<xsl:variable name="toEndModelDisplayType" select="$toEndModelRefNode/@displayModelType"/>
		
		<xsl:variable name="fromEndModelURL" select="concat($fromEndModelType, '_', $fromEndModelId, '.html')"/>
		<xsl:variable name="toEndModelURL" select="concat($toEndModelType, '_', $toEndModelId, '.html')"/>
		
		<td style="width: 10px"/>
		<td width="25%">
			<span class="TableContent">
				<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
				<a href = "{$relationModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
				</a>
			</span>
		</td>
		<td style="width: 20px"/>
		<td>
			<span class="TableContent">
				<xsl:if test="$fromEndModelId != ''">
					<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$fromEndModelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$fromEndModelType, '.png')}');"/>&nbsp;
					<a href = "{$fromEndModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
					<xsl:value-of select="$fromEndModelName"/> : <xsl:value-of select="$fromEndModelDisplayType"/>
					</a>
				</xsl:if>
			</span>
		</td>
		<td style="width: 20px"/>
		<td>
			<span class="TableContent">
				<xsl:if test="$toEndModelId != ''">
					<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $toEndModelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $toEndModelType, '.png')}');"/>&nbsp;
					<a href = "{$toEndModelURL}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
					<xsl:value-of select="$toEndModelName"/> : <xsl:value-of select="$toEndModelDisplayType"/>
					</a>
				</xsl:if>
			</span>
		</td>
	</xsl:template>
	
	<!-- Attribute summary table -->
	<xsl:template name="printAttributeOverviewTable">
		<xsl:if test="count(./ChildModels/Model[@modelType = 'Attribute']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Attributes_Summary"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="8"/></tr>
				<tr><td class="TableHeaderLine1" colspan="8"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td width="10%"><span class="TableHeaderText"><xsl:value-of select="$st_Visibility"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText">Initial Value</span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="8"/></tr>
				<xsl:for-each select="./ChildModels/Model[@modelType = 'Attribute']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td>
						<xsl:variable name="attr_url" select="concat('#', @id)"/>
						<a href = "{$attr_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
					  <xsl:variable name="attrNameWithMultiLine">
					    <xsl:call-template name="replaceChars">
					      <xsl:with-param name="s" select="./ModelProperties/StringProperty[@name='name']/@value"/>
					      <xsl:with-param name="charsIn" select="'&#10;'"/>
					      <xsl:with-param name="charsOut" select="'&lt;br/&gt;'"/>
					    </xsl:call-template>
					  </xsl:variable>
						<xsl:value-of select="$attrNameWithMultiLine" disable-output-escaping="yes"/>
						</a>
						</td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='visibility']/@value"/>&nbsp;</span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent">
							<xsl:variable name="type_model_node" select="./ModelProperties/TextModelProperty[@name='type']"/>
							<xsl:choose>
								<xsl:when test="count($type_model_node/ModelRef) > 0">
									<xsl:variable name="model_ref_node" select="$type_model_node/ModelRef"/>
									<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="./ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$type_model_node/StringValue/@value"/>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="./ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								
								</xsl:otherwise>
							</xsl:choose>
							
						</span></td>
						<td style="width: 20px"/>
						<td ><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='initialValue']/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>


	<!-- Attribute detail table -->
	<xsl:template name="printAttributeDetailTable">
		<xsl:if test="count(./ChildModels/Model[@modelType='Attribute']) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Attributes_Detail"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each attribute is a table -->
			<xsl:for-each select="./ChildModels/Model[@modelType='Attribute']">
				<xsl:variable name="attribute_node" select="."/>				

				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'ormDetail' and count(./Model) > 0) or (@name = 'type' and (./StringValue/@value != '' or ./ModelRef)) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'references' and count(./*) > 0)]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'name'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent">
										<xsl:variable name="attrNameWithMultiLine">
									    <xsl:call-template name="replaceChars">
									      <xsl:with-param name="s" select="./@value"/>
									      <xsl:with-param name="charsIn" select="'&#10;'"/>
									      <xsl:with-param name="charsOut" select="'&lt;br/&gt;'"/>
									    </xsl:call-template>
									  </xsl:variable>
										<xsl:value-of select="$attrNameWithMultiLine" disable-output-escaping="yes"/>
									</span></td>
								</xsl:when>
								<xsl:when test="@name = 'type'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent">
										<xsl:choose>
											<xsl:when test="count(./ModelRef) > 0">
												<xsl:variable name="model_ref_node" select="./ModelRef"/>
												<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>&nbsp;
											
												<!-- binded type -->
												<xsl:variable name="binded_type_model_node" select="$attribute_node/ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
												<xsl:choose>
													
													<!-- ModelType + ModelType> -->
													<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
														<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
														<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
														&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
													</xsl:when>
													
													<!-- ModelType + StringType> -->
													<xsl:when test="count($binded_type_model_node/StringValue) > 0">
														<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
														&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
													</xsl:when>
													
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="./StringValue/@value"/>&nbsp;
											
												<!-- binded type -->
												<xsl:variable name="binded_type_model_node" select="$attribute_node/ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
												<xsl:choose>
													
													<!-- ModelType + ModelType> -->
													<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
														<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
														<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
														&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
													</xsl:when>
													
													<!-- ModelType + StringType> -->
													<xsl:when test="count($binded_type_model_node/StringValue) > 0">
														<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
														&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
													</xsl:when>
													
												</xsl:choose>
											
											</xsl:otherwise>
										</xsl:choose>
									</span></td>
								</xsl:when>
								<xsl:when test="@name = 'ormDetail'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="$st_Mapped_Column"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./Model/ModelProperties/ModelRefProperty[@name='columnModel']/ModelRef/@name" disable-output-escaping="yes"/>&nbsp;</span></td>
								</xsl:when>
								<xsl:when test="@name = 'documentation'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
								</xsl:when>
								<xsl:when test="@name='references'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>		
		
	</xsl:template>
	
	<!-- Operation overview table -->
	<xsl:template name="printOperationOverviewTable">
		<xsl:if test="count(./ChildModels/Model[@modelType = 'Operation']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Operations_Overview"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="6"/></tr>
				<tr><td class="TableHeaderLine1" colspan="6"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Visibility"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Return_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./ChildModels/Model[@modelType = 'Operation']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='visibility']/@value"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent">
							<xsl:variable name="type_model_node" select="./ModelProperties/TextModelProperty[@name='returnType']"/>
							<xsl:choose>
								<xsl:when test="count($type_model_node/ModelRef) > 0">
									<xsl:variable name="model_ref_node" select="$type_model_node/ModelRef"/>
									<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="./ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$type_model_node/StringValue/@value"/>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="./ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								
								</xsl:otherwise>
							</xsl:choose>
						</span></td>
						<td style="width: 20px"/>
						<td>
						<xsl:variable name="oper_url" select="concat('#', @id)"/>
						<a href = "{$oper_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
						<xsl:value-of select="./@name"/>
						</a>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Operation detail table -->
	<xsl:template name="printOperationDetailTable">
		<xsl:if test="count(./ChildModels/Model[@modelType='Operation']) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Operations_Detail"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each operation is a table -->
			<xsl:for-each select="./ChildModels/Model[@modelType='Operation']">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					
					<!-- show parameters, if exist -->
					<xsl:choose>
						<xsl:when test="count(ChildModels/Model[@modelType='Parameter'])>0">
							<tr class="TableRow1">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="$st_Parameters" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printParametersSubtable"/></td>
								<xsl:call-template name="printOperationProperties">
									<xsl:with-param name="modValue" select="0"/>
								</xsl:call-template>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="printOperationProperties">
								<xsl:with-param name="modValue" select="1"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<!-- -->
	<xsl:template name="printOperationProperties">
		<xsl:param name="modValue"/>
		<xsl:variable name="operation_node" select="."/>
		<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'raisedExceptions' and count(./*) > 0) or (@name = 'preconditions' and count(./*) > 0) or (@name = 'postconditions' and count(./*) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'references' and count(./*) > 0) or (@name = 'returnType' and (count(./ModelRef) > 0 or ./StringValue/@value != ''))]">
			<tr>
				<xsl:choose>
					<xsl:when test="position() mod 2 = $modValue">
						<xsl:attribute name="class">TableRow1</xsl:attribute> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="class">TableRow2</xsl:attribute> 
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@name = 'returnType'">
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent">
							<xsl:choose>
								<xsl:when test="count(./ModelRef) > 0">
									<xsl:variable name="model_ref_node" select="./ModelRef"/>
									<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="$operation_node/ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="./StringValue/@value"/>&nbsp;
								
									<!-- binded type -->
									<xsl:variable name="binded_type_model_node" select="$operation_node/ModelProperties/ModelProperty[@name='templateTypeBindInfo']/Model/ModelProperties/ModelsProperty/Model/ModelProperties/TextModelProperty/Model/ModelProperties/TextModelProperty[@name='bindedType']"/>
									<xsl:choose>
										
										<!-- ModelType + ModelType> -->
										<xsl:when test="count($binded_type_model_node/ModelRef) > 0">
											<xsl:variable name="binded_type_model_ref_node" select="$binded_type_model_node/ModelRef"/>
											<xsl:variable name="url2" select="concat($binded_type_model_ref_node/@modelType, '_', $binded_type_model_ref_node/@id, '.html')"/>
											&lt;<a href = "{$url2}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$binded_type_model_ref_node/@name"/></a>&gt;
										</xsl:when>
										
										<!-- ModelType + StringType> -->
										<xsl:when test="count($binded_type_model_node/StringValue) > 0">
											<xsl:variable name="binded_type_string_value_node" select="$binded_type_model_node/StringValue"/>
											&lt;<xsl:value-of select="$binded_type_string_value_node/@value"/>&gt;
										</xsl:when>
										
									</xsl:choose>
								
								</xsl:otherwise>
							</xsl:choose>
						</span></td>
					</xsl:when>
					<xsl:when test="@name='raisedExceptions'">
						<td/>
						<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
						<td/>
						<td><xsl:apply-templates select="." mode="printRaisedExceptionsSubtable"/></td>
					</xsl:when>
					<xsl:when test="@name='preconditions' or @name='postconditions'">
						<td/>
						<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
						<td/>
						<td><xsl:apply-templates select="." mode="printPrePostConditionsSubtable"/></td>
					</xsl:when>
					<xsl:when test="@name = 'documentation'">
						<xsl:if test="@plainTextValue != ''">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:if>
					</xsl:when>
					<xsl:when test="@name='references'">
						<td/>
						<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
						<td/>
						<td><xsl:apply-templates select="." mode="printFileSubtable"/></td>
					</xsl:when>
					<xsl:otherwise>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</xsl:for-each>
	</xsl:template>
	
	
	<!-- Sub-Diagram table -->
	<xsl:template name="printSubDiagramTable">
		<xsl:if test="count(./SubDiagrams/DiagramRef ) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Sub_Diagrams"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="40%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./SubDiagrams/DiagramRef">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>

					<xsl:variable name="diagram_id" select="@id"/>

					<td/>
					<td>
						<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @diagramType, '.png')}');"/>&nbsp;
						<xsl:variable name="url" select="concat(@diagramType, '_', @id, '.html')"/>
						<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
						<xsl:value-of select="@name" /> : <xsl:value-of select="@displayDiagramType"/>
						</a>
					</td>
					<td/>
					<td><span class="TableContent"><xsl:value-of select="@documentation" disable-output-escaping="yes"/></span></td>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
			<p/>
		</xsl:if>	
	</xsl:template>
	
	<!-- Reference table -->
	<xsl:template name="printFileTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name = 'references']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_References"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_File_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Description"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./ModelProperties/ModelsProperty[@name = 'references']/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<xsl:variable name="fileType" select="./ModelProperties/StringProperty[@name='type']/@value"/>
						<xsl:choose>
							<xsl:when test="$fileType = 'File'">
								<xsl:choose>
									<xsl:when test="$references_dir_name = '' or count(./ModelProperties/StringProperty[@name='url']/@fileValue) = 0">
										<xsl:variable name="url" select="concat('file:///', ./ModelProperties/StringProperty[@name='url']/@value)"/>
										<xsl:variable name="displayUrl" select="./ModelProperties/StringProperty[@name='url']/@value"/>
										<td><span class="TableContent"><a href="{$url}" class="ItemLink" target="_blank"><xsl:value-of select="$displayUrl"/></a></span></td>
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="realUrl" select="concat('../', $references_dir_name, '/', ./ModelProperties/StringProperty[@name='url']/@fileValue)"/>
										<xsl:variable name="displayUrl" select="./ModelProperties/StringProperty[@name='url']/@fileName"/>
										<td><span class="TableContent"><a href="{$realUrl}" class="ItemLink" target="_blank"><xsl:value-of select="$displayUrl"/></a></span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$fileType = 'Folder'">
								<xsl:variable name="url" select="concat('file:///', ./ModelProperties/StringProperty[@name='url']/@value)"/>
								<xsl:variable name="displayUrl" select="./ModelProperties/StringProperty[@name='url']/@value"/>
								<td><span class="TableContent"><a href="{$url}" class="ItemLink" target="_blank"><xsl:value-of select="$displayUrl"/></a></span></td>
							</xsl:when>
							<xsl:when test="$fileType = 'Diagram'">
								<xsl:variable name="url_node" select="./ModelProperties/StringProperty[@name='url']"/>
								<xsl:choose>
									<xsl:when test="$url_node/@diagramType != ''">
										<xsl:variable name="url" select="concat($url_node/@diagramType, '_', $url_node/@value, '.html')"/>
										<td><span class="TableContent">
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $url_node/@diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $url_node/@diagramType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="$url_node/@diagramName" /> : <xsl:value-of select="$url_node/@displayDiagramType"/>
										</a>
										</span>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td><span class="TableContent">N/A</span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$fileType = 'Shape'">
								<xsl:variable name="url_node" select="./ModelProperties/StringProperty[@name='url']"/>
								<xsl:choose>
									<xsl:when test="$url_node/@shapeType != ''">
										<xsl:variable name="isContentPageAvailable">
											<xsl:call-template name="isContentPageAvailable">
									      <xsl:with-param name="model_node" select="$url_node"/>
											</xsl:call-template>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$isContentPageAvailable = 'true'">
												<xsl:variable name="url" select="concat($url_node/@shapeType, '_', $url_node/@model, '.html')"/>
												<td><span class="TableContent">
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}');"/>&nbsp;
												<xsl:choose>
													<xsl:when test="string-length($url_node/@model) != 0">
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="$url_node/@shapeName" /> : <xsl:value-of select="$url_node/@displayShapeType"/>
														</a>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$url_node/@shapeName" /> : <xsl:value-of select="$url_node/@displayShapeType"/>
													</xsl:otherwise>
												</xsl:choose>
												</span>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td><span class="TableContent">
													<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}');"/>&nbsp;
													<xsl:value-of select="$url_node/@shapeName" /> : <xsl:value-of select="$url_node/@displayShapeType"/>
													</span>
												</td>
											</xsl:otherwise>
										</xsl:choose>
																
									</xsl:when>
									<xsl:otherwise>
										<td><span class="TableContent">N/A</span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="url" select="./ModelProperties/StringProperty[@name='url']/@value"/>
								<td><span class="TableContent"><a href="{$url}" class="ItemLink" target="_blank"><xsl:value-of select="$url"/></a></span></td>
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 20px"/>
						<td><span class="TableContent">
							<xsl:variable name="processedBrake1">
								<xsl:call-template name="replace">
									<xsl:with-param name="string" select="./ModelProperties/StringProperty[@name='description']/@value"/>
									<xsl:with-param name="pattern" select="'&#13;'"/>
									<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:call-template name="replace">
								<xsl:with-param name="string" select="$processedBrake1"/>
								<xsl:with-param name="pattern" select="'&#10;'"/>
								<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
							</xsl:call-template>	
						</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>	
	</xsl:template>

	<!-- Reference sub-table -->
	<xsl:template match="ModelsProperty[@name='references']" mode="printFileSubtable">
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr class="SubtableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_File_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Description"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<xsl:variable name="fileType" select="./ModelProperties/StringProperty[@name='type']/@value"/>
						<xsl:choose>
							<xsl:when test="$fileType = 'File'">
								<xsl:choose>
									<xsl:when test="$references_dir_name = '' or count(./ModelProperties/StringProperty[@name='url']/@fileValue) = 0">
										<xsl:variable name="url" select="concat('file:///', ./ModelProperties/StringProperty[@name='url']/@value)"/>
										<td><span class="TableContent"><a href="{$url}" class="ItemLink" target="_blank"><xsl:value-of select="$url"/></a></span></td>
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="realUrl" select="concat('../', $references_dir_name, '/', ./ModelProperties/StringProperty[@name='url']/@fileValue)"/>
										<xsl:variable name="displayUrl" select="./ModelProperties/StringProperty[@name='url']/@fileName"/>
										<td><span class="TableContent"><a href="{$realUrl}" class="ItemLink" target="_blank"><xsl:value-of select="$displayUrl"/></a></span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$fileType = 'Shape'">
								<xsl:variable name="url_node" select="./ModelProperties/StringProperty[@name='url']"/>
								<xsl:choose>
									<xsl:when test="$url_node/@shapeType != ''">
										<xsl:variable name="url" select="concat($url_node/@shapeType, '_', $url_node/@model, '.html')"/>
										<td><span class="TableContent">
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $url_node/@shapeType, '.png')}');"/>&nbsp;
										<xsl:choose>
											<xsl:when test="string-length($url_node/@model) != 0">
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
												<xsl:value-of select="$url_node/@shapeName" /> : <xsl:value-of select="$url_node/@displayShapeType"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$url_node/@shapeName" /> : <xsl:value-of select="$url_node/@displayShapeType"/>
											</xsl:otherwise>
										</xsl:choose>
										</span>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td><span class="TableContent">N/A</span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="$fileType = 'Diagram'">
								<xsl:variable name="url_node" select="./ModelProperties/StringProperty[@name='url']"/>
								<xsl:choose>
									<xsl:when test="$url_node/@diagramType != ''">
										<xsl:variable name="url" select="concat($url_node/@diagramType, '_', $url_node/@value, '.html')"/>
										<td><span class="TableContent">
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $url_node/@diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $url_node/@diagramType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="$url_node/@diagramName" /> : <xsl:value-of select="$url_node/@displayDiagramType"/>
										</a>
										</span>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td><span class="TableContent">N/A</span></td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="url" select="./ModelProperties/StringProperty[@name='url']/@value"/>
								<td><span class="TableContent"><a href="{$url}" class="ItemLink" target="_blank"><xsl:value-of select="$url"/></a></span></td>
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='description']/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
	</xsl:template>

	<!-- Comments table -->
	<xsl:template name="printCommentTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name = 'comments']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Comments"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each comment is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty[@name = 'comments']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name!='modelType') ]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'name'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="$st_Summary" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:when test="@name = 'documentation'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="$st_Content" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:otherwise>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>	
	
	<!-- Comments sub-table -->
	<xsl:template match="ModelsProperty[@name='comments']" mode="printCommentsSubtable">
			<!--  each comment is a table -->
			<xsl:for-each select="./Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr class="SubtableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name!='modelType') ]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'name'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="$st_Summary" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:when test="@name = 'documentation'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="$st_Content" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:otherwise>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<p/>
			</xsl:for-each>
	</xsl:template>
		
	<!-- Child table -->
	<xsl:template name="printChildTable">
		<xsl:if test="count(./ChildModels/Model[@composite='false']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Children"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="30%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="ChildModels/Model">
					<xsl:sort select="@modelType"/>
					<xsl:if test="@composite='false'">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td><span class="TableContent">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @id, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@displayModelType"/>
								</a>
							</span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="ModelProperties/HTMLProperty[@name='documentation']/@value" disable-output-escaping="yes"/>&nbsp;</span></td>
	
						</tr>
					</xsl:if>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Tagged Value table -->
	<xsl:template name="printTaggedValueTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='taggedValues']/Model[@modelType = 'TaggedValueContainer']/ChildModels/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Tagged_Values"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="6"/></tr>
				<tr><td class="TableHeaderLine1" colspan="6"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='taggedValues']/Model[@modelType = 'TaggedValueContainer']/ChildModels/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='type']/@value"/></span></td>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="count(./ModelProperties/TextModelProperty[@name='value']/ModelRef) > 0">
								<xsl:variable name="model_ref_node" select="./ModelProperties/TextModelProperty[@name='value']/ModelRef"/>
								<xsl:variable name="isContentPageAvailable">
									<xsl:call-template name="isContentPageAvailable">
							      <xsl:with-param name="model_node" select="$model_ref_node"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$isContentPageAvailable = 'true'">		
										<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
										<td>
											<span class="TableContent">
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
												<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
												</a>
											</span>
										</td>
									</xsl:when>
									<xsl:otherwise>		
										<td>
											<span class="TableContent">
												<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>
												<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
											</span>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="./ModelProperties/StringProperty[@name='type']/@value = 'Model' and count(./ModelProperties/TextModelProperty[@name='value']/*) = 0">
								<td>
									<span class="TableContent"><xsl:value-of select="$st_Unspecified"/></span>
								</td>
							</xsl:when>
							<xsl:when test="count(./ModelProperties/HTMLProperty[@name='value']) > 0">
								<td><span class="TableContent"><xsl:value-of select="./ModelProperties/HTMLProperty[@name='value']/@value" disable-output-escaping="yes"/></span></td>
							</xsl:when>
							<xsl:otherwise>
							  <xsl:variable name="attributeWithMultipleLines">
									<xsl:call-template name="replace">
										<xsl:with-param name="string" select="./ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/>
										<xsl:with-param name="pattern" select="'&#10;'"/>
										<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
									</xsl:call-template>		
								</xsl:variable>		
								<td><span class="TableContent"><xsl:value-of select="$attributeWithMultipleLines" disable-output-escaping="yes"/></span></td>
							</xsl:otherwise>
						</xsl:choose>		
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Tagged Value sub-table -->
	<xsl:template match="ModelProperty[@name='taggedValues']" mode="printTaggedValueSubtable">
		<xsl:if test="count(./Model[@modelType = 'TaggedValueContainer']/ChildModels/Model) > 0">

		</xsl:if>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr class="SubtableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:for-each select="./Model[@modelType = 'TaggedValueContainer']/ChildModels/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='type']/@value"/></span></td>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="count(./ModelProperties/TextModelProperty[@name='value']/ModelRef) > 0">
								<xsl:variable name="model_ref_node" select="./ModelProperties/TextModelProperty[@name='value']/ModelRef"/>
								<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
								<td>
									<span class="TableContent">
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:when test="count(./ModelProperties/HTMLProperty[@name='value']) > 0">
								<td><span class="TableContent"><xsl:value-of select="./ModelProperties/HTMLProperty[@name='value']/@value" disable-output-escaping="yes"/></span></td>
							</xsl:when>
							<xsl:otherwise>
								<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/></span></td>
							</xsl:otherwise>
						</xsl:choose>		
					</tr>
				</xsl:for-each>
			</table>
	</xsl:template>
	
	
	<!-- Template Parameter table -->
	<xsl:template name="printTemplateParameterTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='templateParameters']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Template_Parameters"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="8"/></tr>
				<tr><td class="TableHeaderLine1" colspan="8"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type_Modifier"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Default_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="8"/></tr>
				<xsl:for-each select="./ModelProperties/ModelsProperty[@name='templateParameters']/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="@name"/></span></td>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="count(ModelProperties/TextModelProperty[@name='type']/ModelRef) > 0">
								<xsl:variable name="model_ref_node" select="ModelProperties/TextModelProperty[@name='type']/ModelRef"/>
								<td>
									<xsl:variable name="model_type" select="$model_ref_node/@displayModelType"/>
									
									<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
									<span class="TableContent">
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty[@name='type']/StringValue/@value"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='typeModifier']/@value"/>&nbsp;</span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='defaultValue']/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Class -> Operation -> Raised Exceptions -->
	<xsl:template match="ModelsProperty[@name='raisedExceptions']" mode="printRaisedExceptionsSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./Model">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="count(./ModelProperties/TextModelProperty[@name='value']/StringValue) = 1">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Text"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="model_ref_node" select="./ModelProperties/TextModelProperty[@name='value']/ModelRef"/>
							<xsl:variable name="model_type" select="$model_ref_node/@displayModelType"/>
							<td style="width: 10px"/>
							<td>
								<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
								<span class="TableContent">
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/',$model_ref_node/@modelType, '.png')}');"/>&nbsp;
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
									<xsl:value-of select="$model_ref_node/@name"/> : <xsl:value-of select="$model_ref_node/@modelType"/>
									</a>
								</span>
							</td>						
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="$model_type"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>	
	
	<!-- Class -> Operation -> Pre/Post Conditions -->
	<xsl:template match="ModelsProperty[@name='preconditions' or @name='postconditions']" mode="printPrePostConditionsSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./Model">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/></span></td>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>

	<!-- Class -> Operation -> Parameters -->
	<xsl:template match="Model[@modelType='Operation']" mode="printParametersSubtable">
		<xsl:for-each select="ChildModels/Model">
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr class="SubtableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="ModelProperties/*[@name != 'modelType' and @value != '']">
					<tr class="TableRow1">
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
					</tr>	
				</xsl:for-each>
			</table>
		</xsl:for-each>	
	</xsl:template>
	
	<!-- Constraints -->
	<xsl:template match="ModelRefsProperty[@name='constraints']" mode="printConstraintsTable">
		<xsl:if test="count(./ModelRef[@modelType='ConstraintElement']) > 0">
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr class="SubtableHeader">
					<td style="width: 10px"/>
					<td width="*"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelRef[@modelType='ConstraintElement']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="@name"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
		
</xsl:stylesheet>
