<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='InteractionLifeLine']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printLifeLinePropertyTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>
	
		<!-- Attribute Links -->
		<xsl:call-template name="printAttributeLinkTable"/>
			
		<!-- Tagged Values -->
		<xsl:call-template name="printTaggedValueTable"/>
				
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
	
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
	
	<!-- Property table -->
	<xsl:template name="printLifeLinePropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[((@name='baseClassifier' and count(./*) > 0) or (@value != '' and (@name!='modelType' and @name!= 'name' and @name != 'documentation'))) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name='baseClassifier'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<span class="TableContent">
									<xsl:variable name="model_ref_node" select="./ModelRef"/>
									<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}');"/>&nbsp;
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
									<xsl:value-of select="$model_ref_node/@name" /> : <xsl:value-of select="$model_ref_node/@displayModelType"/>
									</a>
								</span>
							</td>
						</xsl:when>
						<xsl:when test="@name = 'stereotypes'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent">
							<xsl:for-each select="./ModelRef">
								<xsl:variable name = "id" select="@id"/>
								<xsl:variable name="stereotype_content_page_url" select="concat(@modelType, '_', $id, '.html')"/>
								<a href = "{$stereotype_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="@name" /></a>
								<xsl:if test="position() != last()">
									<xsl:value-of select="', '"/>
								</xsl:if>
							</xsl:for-each>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>
		
	<!-- Attribute link table -->
	<xsl:template name="printAttributeLinkTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='attributeLinks']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Attribute_Links"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="6"/></tr>
				<tr><td class="TableHeaderLine1" colspan="6"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Class"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Attribute"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Initial_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="6"/></tr>
				<xsl:variable name="bass_classifier_id" select="./ModelProperties/TextModelProperty[@name='baseClassifier']/ModelRef/@id"/>
				<xsl:variable name="bass_classifier_name" select="./ModelProperties/TextModelProperty [@name='baseClassifier']/ModelRef/@name"/>
				<xsl:variable name="bass_classifier_url" select="concat('Class_', $bass_classifier_id, '.html')"/>
				<xsl:for-each select="./ModelProperties/ModelsProperty[@name='attributeLinks']/Model">
					<xsl:variable name="model_id" select="./ModelProperties/ModelRefProperty[@name='type']/ModelRef/@id"/>
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td>
							<span class="TableContent">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/Class', '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/Class', '.png')}');"/>&nbsp;
								<a href = "{$bass_classifier_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
								<xsl:value-of select="$bass_classifier_name"/> : Class
								</a>
							</span>
						</td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='attributeName']/@value"/>&nbsp;</span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='initialValue']/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
