<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>
	<xsl:template match="Model[@modelType='DBTriggerContainer']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>
		
		<!-- Trigger detail -->
		<xsl:call-template name="printTriggerDetailTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>

		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template>
	
	<!-- Trigger detail table -->
	<xsl:template name="printTriggerDetailTable">
		<xsl:if test="count(./ChildModels/Model[@modelType='DBTrigger']) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Triggers_Detail"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each trigger is a table -->
			<xsl:for-each select="./ChildModels/Model[@modelType='DBTrigger']">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:call-template name="printTriggerProperties">
						<xsl:with-param name="modValue" select="1"/>
					</xsl:call-template>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<!-- -->
	<xsl:template name="printTriggerProperties">
		<xsl:param name="modValue"/>
		<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '') or (@name = 'references' and count(./*) > 0)]">
			<tr>
				<xsl:choose>
					<xsl:when test="position() mod 2 = $modValue">
						<xsl:attribute name="class">TableRow1</xsl:attribute> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="class">TableRow2</xsl:attribute> 
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@name = 'documentation'">
						<xsl:if test="@plainTextValue != ''">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>
