<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='CRCCard']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>
		
		<!-- Attributes -->
		<xsl:call-template name="printCRCAttributeTable"/>

		<!-- Responsibility -->
		<xsl:call-template name="printCRCResponsibilityTable"/>
		
	</xsl:template> 
	
	<!-- Attribute table -->
	<xsl:template name="printCRCAttributeTable">
		<xsl:if test="count(./ChildModels/Model[@modelType = 'CRCAttribute']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Attributes"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ChildModels/Model[@modelType = 'CRCAttribute']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./@name" /></span></td>
						<td/>
					  <xsl:variable name="attributeWithMultipleLines">
							<xsl:call-template name="replace">
								<xsl:with-param name="string" select="./ModelProperties/HTMLProperty[@name='documentation']/@plainTextValue"/>
								<xsl:with-param name="pattern" select="'&#10;'"/>
								<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
							</xsl:call-template>		
						</xsl:variable>			
						<td><span class="TableContent"><xsl:value-of select="$attributeWithMultipleLines" disable-output-escaping="yes"/></span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Responsibility table -->
	<xsl:template name="printCRCResponsibilityTable">
		<xsl:if test="count(./ChildModels/Model[@modelType = 'CRCResponsibility']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Responsibilities"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ChildModels/Model[@modelType = 'CRCResponsibility']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./@name" /></span></td>
						<td/>
					  <xsl:variable name="collaboratorWithMultipleLines">
							<xsl:call-template name="replace">
								<xsl:with-param name="string" select="./ModelProperties/StringProperty[@name='collaborator']/@value"/>
								<xsl:with-param name="pattern" select="'&#10;'"/>
								<xsl:with-param name="replacement" select="'&lt;br/&gt;'"/>
							</xsl:call-template>		
						</xsl:variable>			
						<td><span class="TableContent"><xsl:value-of select="$collaboratorWithMultipleLines" disable-output-escaping="yes"/></span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>	
	
</xsl:stylesheet>
