<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPTask']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printBPTaskPropertyTable"/>

		<!-- Task Type -->
		<xsl:call-template name="printBPTaskTypeTable"/>

		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>

		<!-- Assignments -->
		<xsl:call-template name="printAssignmentTable"/>

		<!-- Properties (Model) -->
		<xsl:call-template name="printBPTaskPropertyCollectionTable"/>
		
		<!-- Input Sets -->
		<xsl:call-template name="printInputSetsTable"/>
		
		<!-- Output Sets -->
		<xsl:call-template name="printOutputSetsTable"/>
		
		<!-- IO Rules -->
		<xsl:call-template name="printIORulesTable"/>
		
		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
		
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>

		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>

		<!-- Files -->
		<xsl:call-template name="printFileTable"/>

		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>

	</xsl:template> 
	
	<!-- Property table -->
	<xsl:template name="printBPTaskPropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[((@name='baseClassifier' and count(./*) > 0) or (@value != '' and (@name!='modelType' and @name!= 'name' and @name != 'documentation'))) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'loopType' and count(./Model) > 0) or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0) or (@name = 'documentation' and @plainTextValue != '')]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name='loopType'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="./Model" mode="printLoopTypeSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>
	
	<!-- Loop type sub-table -->
	<xsl:template match="ModelProperty[@name='loopType']/Model" mode="printLoopTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[@value != '' and @name != 'name']">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Type table -->
	<xsl:template name="printBPTaskTypeTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='taskType']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Task_Type"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='taskType']/Model/ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '') or (@name = 'inMessage' and count(./Model) >0) or (@name = 'outMessage' and count(./Model) >0) or (@name = 'message' and count(./Model) >0) or (@name = 'implementation' and count(./Model) >0) or (@name = 'taskRef' and count(./ModelRef) >0) or (@name = 'performer' and count(./Model) >0)]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="@name='inMessage' or @name='outMessage' or @name='message'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printInOutMessageSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='implementation'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printImplementationSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='taskRef'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:when test="@name='performer'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printPerformersSubtable"/></td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>	
		
		</xsl:if>
	</xsl:template>	
	
	<!-- Task -> Task Type -> In/Out message -->
	<xsl:template match="ModelProperty[@name='inMessage' or @name='outMessage' or @name='message']/Model" mode="printInOutMessageSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType') or (@name='properties' and count(./Model)>0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:when test="@name='properties'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="." mode="printPropertiesSubtable"/></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Task -> Task Type -> In/Out message -> Properties -->
	<xsl:template match="ModelsProperty[@name='properties']" mode="printPropertiesSubtable">
		<!--  each property is a table -->
			<xsl:for-each select="Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr class="SubtableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'documentation'">
									<xsl:if test="@plainTextValue != ''">
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>	
			</xsl:for-each>
	</xsl:template>

	<!-- Task -> Task Type -> Implementation -->
	<xsl:template match="ModelProperty[@name='implementation']/Model" mode="printImplementationSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType') or (@name='properties' and count(./Model)>0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:when test="@name='properties'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="." mode="printPropertiesSubtable"/></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Task -> Task Type -> Performers -->
	<xsl:template match="ModelsProperty[@name='performer']" mode="printPerformersSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="*"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="Model">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty/StringValue/@value"/></span></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>	
	
	<!-- Task Properties collection table -->
	<xsl:template name="printBPTaskPropertyCollectionTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty [@name='properties']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Task_Properties"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each property is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty [@name='properties']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or @name = 'returnType' or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'documentation'">
									<xsl:if test="@plainTextValue != ''">
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<!-- Task Assignments table -->
	<xsl:template name="printAssignmentTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty [@name='assignments']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Assignments"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each assignment is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty [@name='assignments']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or @name = 'returnType' or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'documentation'">
									<xsl:if test="@plainTextValue != ''">
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
						
	<!-- Input sets table -->
	<xsl:template name="printInputSetsTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='inputSets']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_InputSets"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each input is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty[@name='inputSets']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'inputs' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'type'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<xsl:choose>
										<xsl:when test="count(./ModelRef) > 0">
											<xsl:variable name="model_ref_node" select="./ModelRef"/>
											<xsl:variable name="model_name" select="$model_ref_node/@name"/>
											<td>
												<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td><span class="TableContent"><xsl:value-of select="./StringValue/@value"/>&nbsp;</span></td>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:when test="@name = 'inputs'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td>
										<table width="100%"  border="0" cellpadding="0" cellspacing="0">
											<tr class="SubtableHeader">
												<td style="width: 10px"/>
												<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
												<td style="width: 20px"/>
												<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
											</tr>
											<tr><td class="TableHeaderLine2" colspan="4"/></tr>
											<xsl:for-each select="./ModelRef">
												<tr class="TableRow1">
													<xsl:choose>
														<xsl:when test="position() mod 2 = 1">
															<xsl:attribute name="class">TableRow1</xsl:attribute> 
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="class">TableRow2</xsl:attribute> 
														</xsl:otherwise>
													</xsl:choose>
													<td style="width: 10px"/>
													<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
													<td style="width: 20px"/>
													<td><span class="TableContent"><xsl:value-of select="./@displayModelType" disable-output-escaping="yes"/></span></td>
												</tr>
											</xsl:for-each>
										</table>
									</td>
								</xsl:when>
								<xsl:when test="@name = 'documentation'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
							
	<!-- Output sets table -->
	<xsl:template name="printOutputSetsTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='outputSets']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_OutputSets"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each output is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty[@name='outputSets']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or (@name = 'outputs' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'type'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<xsl:choose>
										<xsl:when test="count(./ModelRef) > 0">
											<xsl:variable name="model_ref_node" select="./ModelRef"/>
											<xsl:variable name="model_name" select="$model_ref_node/@name"/>
											<td>
												<xsl:variable name="url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
												<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="$model_ref_node/@name"/></a>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td><span class="TableContent"><xsl:value-of select="./StringValue/@value"/>&nbsp;</span></td>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:when test="@name = 'outputs'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td>
										<table width="100%"  border="0" cellpadding="0" cellspacing="0">
											<tr class="SubtableHeader">
												<td style="width: 10px"/>
												<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
												<td style="width: 20px"/>
												<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
											</tr>
											<tr><td class="TableHeaderLine2" colspan="4"/></tr>
											<xsl:for-each select="./ModelRef">
												<tr class="TableRow1">
													<xsl:choose>
														<xsl:when test="position() mod 2 = 1">
															<xsl:attribute name="class">TableRow1</xsl:attribute> 
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="class">TableRow2</xsl:attribute> 
														</xsl:otherwise>
													</xsl:choose>
													<td style="width: 10px"/>
													<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
													<td style="width: 20px"/>
													<td><span class="TableContent"><xsl:value-of select="./@displayModelType" disable-output-escaping="yes"/></span></td>
												</tr>
											</xsl:for-each>
										</table>
									</td>
								</xsl:when>
								<xsl:when test="@name = 'documentation'">
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<!-- IO Rules -->
	<xsl:template name="printIORulesTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='ioRules']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_IORules"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="*"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelsProperty[@name='ioRules']/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
	<!-- Categories -->
	<xsl:template name="printCategoriesTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty[@name='categories']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Categories"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="*"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelsProperty[@name='categories']/Model">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent"><xsl:value-of select="ModelProperties/TextModelProperty[@name='value']/StringValue/@value"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
		
</xsl:stylesheet>
