<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPSubProcess']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printSubProcessPropertyTable"/>

		<!-- Subprocess Type -->
		<xsl:call-template name="printBPSubprocessTypeTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>

		<!-- Assignments -->
		<xsl:call-template name="printAssignmentTable"/>

		<!-- Properties (Model) -->
		<xsl:call-template name="printBPSubprocessPropertyCollectionTable"/>
		
		<!-- Input Sets -->
		<xsl:call-template name="printInputSetsTable"/>
		
		<!-- Output Sets -->
		<xsl:call-template name="printOutputSetsTable"/>
		
		<!-- IO Rules -->
		<xsl:call-template name="printIORulesTable"/>
		
		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
		
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>

		<!-- Files -->
		<xsl:call-template name="printFileTable"/>

		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>

	</xsl:template> 
	
	<!-- Property table -->
	<xsl:template name="printSubProcessPropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name!='modelType' and @name!= 'name' and @name!= 'documentation') or (@name = 'diagramId' and count(./DiagramRef) > 0) or (@name = 'transaction' and count(./Model) > 0) or (@name = 'loopType' and count(./Model) > 0) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'ormDetail' and count(./Model[@modelType='ORMClassDetail']) > 0) or (@name = 'classModel' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td/>
					<xsl:choose>
						<xsl:when test="@name='loopType'">
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="./Model" mode="printLoopTypeSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:when test="@name='transaction'">
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="./Model" mode="printTransactionSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'diagramId'">
							<td><span class="TableContent"><xsl:value-of select="$st_Diagram"/></span></td>
							<td/>
							<td><span class="TableContent">
							<xsl:variable name = "diagram_ref_node" select = "./DiagramRef"/>
							<xsl:variable name="table_model_content_page_url" select="concat($diagram_ref_node/@diagramType, '_', $diagram_ref_node/@id, '.html')"/>
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $diagram_ref_node/@diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $diagram_ref_node/@diagramType, '.png')}');"/>&nbsp;
							<a href = "{$table_model_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
							<xsl:value-of select="$diagram_ref_node/@name" /> : <xsl:value-of select="$diagram_ref_node/@displayDiagramType"/>
							</a>
							</span></td>
						</xsl:when>
						<xsl:otherwise>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>

	<!-- Transaction sub-table -->
	<xsl:template match="ModelProperty[@name='transaction']/Model" mode="printTransactionSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[@value != '' and @name != 'name']">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Loop type sub-table -->
	<xsl:template match="ModelProperty[@name='loopType']/Model" mode="printLoopTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[@value != '' and @name != 'name']">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	<!-- Type table -->
	<xsl:template name="printBPSubprocessTypeTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='subProcessType']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="./ModelProperties/ModelProperty[@name='subProcessType']/@displayName"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='subProcessType']/Model/ModelProperties/*[(@value != '' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '') or (@name = 'processRef' and count(./ModelRef) >0) or (@name = 'diagramRefId' and count(./DiagramRef) >0) or (@name = 'inputProperties' and count(./Model) >0) or (@name = 'outputProperties' and count(./Model) >0)]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="@name='modelType'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="$st_Type" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
							</xsl:when>
							<xsl:when test="@name='processRef'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:when test="@name='diagramRefId'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./DiagramRef/@diagramType, '_', ./DiagramRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./DiagramRef/@diagramType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./DiagramRef/@diagramType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./DiagramRef/@name" /> : <xsl:value-of select="./DiagramRef/@displayDiagramType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:when test="@name='inputProperties' or @name='outputProperties'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printInOutputPropertiesSubtable"/></td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>	
		
		</xsl:if>
	</xsl:template>	

	<!-- SubProcess Properties collection table -->
	<xsl:template name="printBPSubprocessPropertyCollectionTable">
		<xsl:if test="count(./ModelProperties/ModelsProperty [@name='properties']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Subprocess_Properties"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each property is a table -->
			<xsl:for-each select="./ModelProperties/ModelsProperty [@name='properties']/Model">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType' and @name != 'documentation') or @name = 'returnType' or (@name = 'documentation' and @plainTextValue != '')]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'documentation'">
									<xsl:if test="@plainTextValue != ''">
										<td style="width: 10px"/>
										<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
										<td style="width: 20px"/>
										<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<td style="width: 10px"/>
									<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
									<td style="width: 20px"/>
									<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>	
	
	<!-- Subprocess -> Type -> Input/Output properties -->
	<xsl:template match="ModelsProperty[@name='inputProperties' or @name='outputProperties']" mode="printInOutputPropertiesSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="Model">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="count(./ModelProperties/TextModelProperty/StringValue) > 0">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty/StringValue/@value"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="$st_Text"/></span></td>
						</xsl:when>
						<xsl:when test="count(./ModelProperties/TextModelProperty/ModelRef) > 0">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty/ModelRef/@name"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./ModelProperties/TextModelProperty/ModelRef/@displayModelType"/></span></td>
						</xsl:when>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>	
	
</xsl:stylesheet>
