<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPPool']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>
		
		<!-- Process -->
		<xsl:call-template name="printProcessTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>
		
		<!-- Children -->
		<xsl:call-template name="printChildTable"/>
		
		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
		
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
	
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template>
	
	<!-- Process table -->
	<xsl:template name="printProcessTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='process']/Model) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Process"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='process']/Model/ModelProperties/*[(@value != '' and @name!='modelType' and @name!= 'name' and @name!= 'documentation') or (@name = 'diagramId' and count(./DiagramRef) > 0) or (@name = 'transaction' and count(./Model) > 0) or (@name = 'loopType' and count(./Model) > 0) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'ormDetail' and count(./Model[@modelType='ORMClassDetail']) > 0) or (@name = 'classModel' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '')]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
