<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPLane']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printBPLanePropertyTable"/>
		
		<!-- Children -->
		<xsl:call-template name="printChildTable"/>
		
		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
						
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
	
	<!-- Property table -->
	<xsl:template name="printBPLanePropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[((@name='baseClassifier' and count(./*) > 0) or (@value != '' and (@name!='modelType' and @name!= 'name' and @name != 'documentation'))) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'parentLane' and count(./ModelRef) > 0) or (@name = 'loopType' and count(./Model) > 0) or (@name = 'documentation' and @plainTextValue != '')]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'parentLane'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent">
							<xsl:variable name = "model_ref_node" select = "./ModelRef"/>
							<xsl:variable name="table_model_content_page_url" select="concat($model_ref_node/@modelType, '_', $model_ref_node/@id, '.html')"/>
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $model_ref_node/@modelType, '.png')}');"/>&nbsp;
							<a href = "{$table_model_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
							<xsl:value-of select="$model_ref_node/@name" /> : <xsl:value-of select="$model_ref_node/@modelType"/>
							</a>
							</span></td>
						</xsl:when>
						<xsl:otherwise>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>	
	
</xsl:stylesheet>
