<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPGroup']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>

		<!-- Children -->
		<xsl:call-template name="printBPGroupChildTable"/>
		
		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
				
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
	
	<xsl:template name="printBPGroupChildTable">
		<xsl:variable name="bpgroup_id" select="@id"/>
		<xsl:variable name="bpgroup_diagram_element_node" select="//Project/Diagrams/Diagram[@diagramType='BusinessProcessDiagram']//Shape[@model=$bpgroup_id]"/>
		<xsl:if test="count($bpgroup_diagram_element_node/ChildShapes/Shape) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Children"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="30%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="$bpgroup_diagram_element_node/ChildShapes/Shape">
					<xsl:sort select="shapeType"/>
					<xsl:variable name="child_model_id" select="@model"/>
					<xsl:variable name="child_model_node" select="//Project/Models//Model[@id = $child_model_id]"/>
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent">
							<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', $child_model_node/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', $child_model_node/@modelType, '.png')}');"/>&nbsp;
							<a href = "{concat($child_model_node/@modelType, '_', $child_model_node/@id, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
								<xsl:value-of select="$child_model_node/@name"/> : <xsl:value-of select="$child_model_node/@displayModelType"/>
							</a>
						</span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="$child_model_node/ModelProperties/HTMLProperty[@name='documentation']/@value" disable-output-escaping="yes"/>&nbsp;</span></td>

					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template> 
	
</xsl:stylesheet>
