<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPGateway']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printPropertyTable"/>

		<!-- Task Type -->
		<xsl:call-template name="printBPGatewayTypeTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>

		<!-- Assignments -->
		<xsl:call-template name="printAssignmentTable"/>

		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
		
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>

		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>

		<!-- Files -->
		<xsl:call-template name="printFileTable"/>

		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>

	</xsl:template> 
	
	<!-- Type table -->
	<xsl:template name="printBPGatewayTypeTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='gatewayType']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="./ModelProperties/ModelProperty[@name='gatewayType']/@displayName"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='gatewayType']/Model/ModelProperties/*[(@value != '' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '') or (@name = 'defaultGate' and count(./Model) >0) or (@name = 'gates' and count(./Model) >0)]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="@name='modelType'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="$st_Type" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
							</xsl:when>
							<xsl:when test="@name='defaultGate'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printDefaultGateSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='gates'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printGatesSubtable"/></td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>	
		
		</xsl:if>
	</xsl:template>		

	<!-- Gateway -> Gateway Type -> Default Gate -->
	<xsl:template match="ModelProperty[@name='defaultGate']/Model" mode="printDefaultGateSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType') or (@name='outgoingSequenceFlow' and count(./Model)>0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:when test="@name='outgoingSequenceFlow'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:apply-templates select="." mode="printOutgoingSequenceFlowValueCellContent"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
	
	
	<!-- Outgoing sequence flow Value cell content -->
	<xsl:template match="ModelProperty[@name='outgoingSequenceFlow']/Model" mode="printOutgoingSequenceFlowValueCellContent">
		<!-- icon $name (from -> to) -->
		<xsl:variable name="from_model_ref" select="ModelProperties/ModelRefProperty[@name='from']/ModelRef"/>
		<xsl:variable name="to_model_ref" select="ModelProperties/ModelRefProperty[@name='to']/ModelRef"/>
		
		<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
		<xsl:choose>
			<xsl:when test="count(ModelProperties/ModelRefProperty[@name='from']/ModelRef) > 0">
				<xsl:variable name="url" select="concat($from_model_ref/@modelType, '_', $from_model_ref/@id, '.html', '#', @id)"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@name" />
			</xsl:otherwise>
		</xsl:choose>
		(
		<xsl:choose>
			<xsl:when test="count($from_model_ref) > 0">
				<xsl:variable name="url" select="concat($from_model_ref/@modelType, '_', $from_model_ref/@id, '.html')"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="$from_model_ref/@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				&nbsp;
			</xsl:otherwise>
		</xsl:choose>
		->
		<xsl:choose>
			<xsl:when test="count($to_model_ref) > 0">
				<xsl:variable name="url" select="concat($to_model_ref/@modelType, '_', $to_model_ref/@id, '.html')"/>
				<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
				<xsl:value-of select="$to_model_ref/@name" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				&nbsp;
			</xsl:otherwise>
		</xsl:choose>
		)
	</xsl:template>
	
	<!-- Gateway -> Gateway Type -> Gates -->
	<xsl:template match="ModelsProperty[@name='gates']" mode="printGatesSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="Model">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableContent"><xsl:apply-templates select="ModelProperties/ModelProperty[@name='outgoingSequenceFlow']" mode="printOutgoingSequenceFlowValueCellContent"/></span></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>		
	
</xsl:stylesheet>
