<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='BPStartEvent' or @modelType='BPIntermediateEvent' or @modelType='BPEndEvent']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printEventPropertyTable"/>

		<!-- Trigger -->
		<xsl:call-template name="printBPEventTriggerTable"/>

		<!-- Result -->
		<xsl:call-template name="printBPEventResultTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>

		<!-- Assignments -->
		<xsl:call-template name="printAssignmentTable"/>

		<!-- Categories -->
		<xsl:call-template name="printCategoriesTable"/>
		
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>

		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>

		<!-- Files -->
		<xsl:call-template name="printFileTable"/>

		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>

	</xsl:template> 

	<!-- Property table -->
	<xsl:template name="printEventPropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name!='modelType' and @name!= 'name' and @name!= 'documentation') or (@name = 'target' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td/>
					<xsl:choose>
						<xsl:when test="@name='target'">
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<span class="TableContent">
									<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
									<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
									</a>
								</span>
							</td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>

	<!-- Type table -->
	<xsl:template name="printBPEventTriggerTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='trigger']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="./ModelProperties/ModelProperty[@name='trigger']/@displayName"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='trigger']/Model/ModelProperties/*[(@value != '' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '')or (@name = 'message' and count(./Model) >0) or (@name = 'implementation' and count(./Model) >0) or (@name = 'rule' and count(./Model) >0) or (@name = 'triggers' and count(./Model) >0) or (@name = 'processRef' and count(./ModelRef) >0)]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="@name='modelType'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="$st_Type" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
							</xsl:when>
							<xsl:when test="@name='message'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printInOutMessageSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='implementation'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printImplementationSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='rule'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printRuleSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='triggers'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printTriggersSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='processRef'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>	

	<!-- Result table -->
	<xsl:template name="printBPEventResultTable">
		<xsl:if test="count(./ModelProperties/ModelProperty[@name='result']/Model) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="./ModelProperties/ModelProperty[@name='result']/@displayName"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelProperty[@name='result']/Model/ModelProperties/*[(@value != '' and @name != 'documentation') or (@name = 'documentation' and @plainTextValue != '')or (@name = 'message' and count(./Model) >0) or (@name = 'implementation' and count(./Model) >0) or (@name = 'results' and count(./Model) >0) or (@name = 'activity' and count(./ModelRef) >0) or (@name = 'processRef' and count(./ModelRef) >0)]">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="@name='modelType'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="$st_Type" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
							</xsl:when>
							<xsl:when test="@name='message'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printInOutMessageSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='implementation'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="./Model" mode="printImplementationSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='results'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><xsl:apply-templates select="." mode="printResultsSubtable"/></td>
							</xsl:when>
							<xsl:when test="@name='activity'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:when test="@name='processRef'">
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td>
									<span class="TableContent">
										<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
										<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
										<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
										<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
										</a>
									</span>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
								<td/>
								<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>

	<!-- Event -> Trigger -> Triggers -->
	<xsl:template match="ModelsProperty[@name='triggers']" mode="printTriggersSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="Model">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
					<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayModelType"/>&nbsp;</span></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

	<!-- Event -> Trigger -> Rule-->
	<xsl:template match="ModelProperty[@name='rule']/Model" mode="printRuleSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType')]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'modelType'">
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="../../@displayModelType"/></span></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>	
	

	<!-- Event -> Result -> Results -->
	<xsl:template match="ModelsProperty[@name='results']" mode="printResultsSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="Model">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td><span class="TableContent"><xsl:value-of select="./@name"/></span></td>
					<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./@displayModelType"/>&nbsp;</span></td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>	
</xsl:stylesheet>
