<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='ActivityPartition']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printActivityPartitionChildren"/>

		<!-- Children -->
		<xsl:call-template name="printChildTable"/>
				
		<!-- Tagged Values -->
		<xsl:call-template name="printTaggedValueTable"/>
				
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
	
	<xsl:template name="printActivityPartitionChildren">
		<xsl:if test="count(./ModelProperties/ModelRefsProperty [@name='containedElements']/ModelRef) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Children"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="30%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./ModelProperties/ModelRefsProperty [@name='containedElements']/ModelRef">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<td style="width: 10px"/>
							<td><span class="TableContent">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @id, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@displayModelType"/>
								</a>
							</span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="@documentation" disable-output-escaping="yes"/>&nbsp;</span></td>
						</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>

	
	
</xsl:stylesheet>
