<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
    version="1.0"
>

	<xsl:template match="Model[@modelType='ActivityAction']" mode="model_content">
		<!-- Properties -->
		<xsl:call-template name="printActionPropertyTable"/>
		
		<!-- Relationships -->
		<xsl:call-template name="printRelationshipTable"/>
		
		<!-- Tagged Values -->
		<xsl:call-template name="printTaggedValueTable"/>
				
		<!-- Sub Diagrams -->
		<xsl:call-template name="printSubDiagramTable"/>
		
		<!-- Files -->
		<xsl:call-template name="printFileTable"/>
	
		<!-- Relationships detail -->
		<xsl:call-template name="printRelationshipDetailTable"/>
		
		<!-- Comments detail -->
		<xsl:call-template name="printCommentTable"/>
		
	</xsl:template> 
										
	<!-- Property table -->
	<xsl:template name="printActionPropertyTable">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Properties"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[((@name='actionType' and count(./*) > 0) or (@value != '' and (@name!='modelType' and @name!= 'name' and @name != 'documentation'))) or (@name = 'stereotypes' and count(./ModelRef) > 0) or (@name = 'documentation' and @plainTextValue != '') or (@name = 'transitTo' and count(./*) > 0) or (@name = 'transitFrom' and count(./*) > 0)]">
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name = 'stereotypes'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent">
							<xsl:for-each select="./ModelRef">
								<xsl:variable name = "stereotype_model_id" select="@id"/>
								<xsl:variable name="stereotype_content_page_url" select="concat(@modelType, '_', $stereotype_model_id, '.html')"/>
								<a href = "{$stereotype_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="@name" /></a>
								<xsl:if test="position() != last()">
									<xsl:value-of select="', '"/>
								</xsl:if>
							</xsl:for-each>
							</span></td>
						</xsl:when>
						<xsl:when test="@name='actionType'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="./Model" mode="printActionTypeSubtable"/></td>
						</xsl:when>
						<xsl:when test="@name = 'stereotypes'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent">
							<xsl:for-each select="./ModelRef">
								<xsl:variable name = "stereotype_model_id" select="@id"/>
								<xsl:variable name="stereotype_content_page_url" select="concat(@modelType, '_', $stereotype_model_id, '.html')"/>
								<a href = "{$stereotype_content_page_url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}"><xsl:value-of select="@name" /></a>
								<xsl:if test="position() != last()">
									<xsl:value-of select="', '"/>
								</xsl:if>
							</xsl:for-each>
							</span></td>
						</xsl:when>
						<xsl:when test="@name = 'transitTo' or @name = 'transitFrom'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<table width="100%"  border="0" cellpadding="0" cellspacing="0">
									<tr class="SubtableHeader">
										<td style="width: 10px"/>
										<td><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
									</tr>
									<tr><td class="TableHeaderLine2" colspan="2"/></tr>
									<xsl:for-each select="./*">
										<tr class="TableRow1">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 1">
													<xsl:attribute name="class">TableRow1</xsl:attribute> 
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">TableRow2</xsl:attribute> 
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="local-name()='ModelRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @id, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
												<xsl:when test="local-name()='DiagramElementRef'">
													<td style="width: 10px"/>
													<td>
														<xsl:variable name="url" select="concat(@modelType, '_', @model, '.html')"/>
														<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
														<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
														<xsl:value-of select="@name" /> : <xsl:value-of select="@displayModelType"/>
														</a>
													</td>
												</xsl:when>
											</xsl:choose>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/>&nbsp;</span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>	
	</xsl:template>	
										
	<!-- Action type -->
	<xsl:template match="ModelProperty[@name='actionType']/Model" mode="printActionTypeSubtable">
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr class="SubtableHeader">
				<td style="width: 10px"/>
				<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./ModelProperties/*[(@value != '' and @name != 'modelType') or (@name='behavior' and count(./ModelRef)>0)]">
				<tr class="TableRow1">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@name='behavior'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td>
								<span class="TableContent">
									<xsl:variable name="url" select="concat(./ModelRef/@modelType, '_', ./ModelRef/@id, '.html')"/>
									<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', ./ModelRef/@modelType, '.png')}');"/>&nbsp;
									<a href = "{$url}" class = "ItemLink"  target = "{@CONTENT_PANE_NAME}">
									<xsl:value-of select="./ModelRef/@name" /> : <xsl:value-of select="./ModelRef/@displayModelType"/>
									</a>
								</span>
							</td>
						</xsl:when>
						<xsl:when test="@name='properties'">
							<td/>
							<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
							<td/>
							<td><xsl:apply-templates select="." mode="printPropertiesSubtable"/></td>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 10px"/>
							<td><span class="TableContent"><xsl:value-of select="./@displayName"/></span></td>
							<td style="width: 20px"/>
							<td><span class="TableContent"><xsl:value-of select="./@value" disable-output-escaping="yes"/></span></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>		
	</xsl:template>
			
</xsl:stylesheet>
