/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;

import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class XPSeparatorUI extends BasicSeparatorUI
{

  private static final Dimension H_DIM = new Dimension( 0, 9 );
  private static final Dimension V_DIM = new Dimension( 9, 0 );

  public static ComponentUI createUI( JComponent comp )
  {
    return new XPSeparatorUI();
  }

  public void paint( Graphics g, JComponent c )
  {
    Dimension d = c.getSize();
    g.setColor( UIManager.getColor( "controlShadow" ) ); //$NON-NLS-1$
    if ( ((JSeparator)c).getOrientation() == JSeparator.HORIZONTAL )
    {
      g.drawLine( 1, 3, d.width - 2, 3 );
    }
    else
    {
      g.drawLine( 3, 1, 3, d.height - 2 );
    }
  }

  public Dimension getPreferredSize( JComponent c )
  {
    if ( ((JSeparator)c).getOrientation() == JSeparator.HORIZONTAL )
    {  
      return H_DIM;
    }
    else
    {
      return V_DIM;
    }
  }  
}