/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;

import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

/**
 * Windows XP Look and Feel popup menu separator
 *
 * @author Brian.Duff@oracle.com
 * @version $Revision: 1.2 $
 */
public class XPPopupMenuSeparatorUI extends BasicPopupMenuSeparatorUI
{
  private static final Dimension DIM = new Dimension( 0, 9 );
  
  public static ComponentUI createUI( JComponent comp )
  {
    return new XPPopupMenuSeparatorUI();
  }

  public void paint( Graphics g, JComponent c )
  {
    Dimension d = c.getSize();

    g.setColor( UIManager.getColor( "controlShadow" ) ); //$NON-NLS-1$
    g.drawLine( 1, 3, d.width - 2, 3 );
  }

  public Dimension getPreferredSize( JComponent c )
  {
    return DIM;
  }
}