/*
  The contents of this file are subject to the Sun Public License
    Version 1.0 (the "License"); you may not use this file except in
    compliance with the License. A copy of the License is available at
    http://www.sun.com/

    The Original Code is winlaf. The Initial Developer of the
    Original Code is Gerhard Leonhartsberger. Portions created by 
    Gerhard Leonhartsberger are Copyright(C) Gerhard Leonhartsberger. 
    All Rights Reserved.

    Contributor(s): ______________________
*/

package net.java.plaf.windows.xp;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

import com.sun.java.swing.plaf.windows.WindowsMenuUI;

/**
 * This class fixes the following issues:
 * <ul>
 *  <li><b>Issue 26:<B> Menus on a menubar contained by a JFrame are not drawn 
 *                      in "de-activated" style when JFrame is deactivated.</li>
 * </ul>
 * 
 * @author Gerhard.Leonhartsberger@scch.at
 */
public class XPMenuUI extends WindowsMenuUI {
	static int i = 0;

	private JMenu menu;
	private FocusHandler focusHandler;

	public static ComponentUI createUI(JComponent x) {
		return new XPMenuUI((JMenu) x);
	}

	XPMenuUI(JMenu menu) {
		this.menu = menu;
	}
	protected void installListeners() {
		super.installListeners();
		focusHandler = new FocusHandler();
		KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", //$NON-NLS-1$
		focusHandler);
	}

	protected void uninstallListeners() {
		super.uninstallListeners();

		// We should consider that the current keyboard focus manager can be
		// replaced. In that case we need to unregister from the previous
		// keyboard focus manager and to register with the new one.
		// The only way to get notified if the current keyboard focus manager
		// changes is to register with AppContext. AppContext is a class
		// located in sun packages. There is no documentation if events are
		// fired or not on a keyboard focus manager change. 
		// That's the reason why I desided not to register with AppContext. 
		KeyboardFocusManager
			.getCurrentKeyboardFocusManager()
			.removePropertyChangeListener(focusHandler);
	}

	/* (non-Javadoc)
	 * @see javax.swing.plaf.ComponentUI#paint(java.awt.Graphics, javax.swing.JComponent)
	 */
	public void paint(Graphics g, JComponent c) {

		Window window = SwingUtilities.windowForComponent(c);
		Color oldColor = g.getColor();
		if (!window.isActive()) {
			g.setColor(disabledForeground);
		}
		super.paint(g, c);

		g.setColor(oldColor);
	}

	private class FocusHandler implements PropertyChangeListener {

		public void propertyChange(PropertyChangeEvent event) {

			// Issue #39
			MenuSelectionManager manager =
				MenuSelectionManager.defaultManager();
			if (manager.getSelectedPath().length > 0) {
				manager.clearSelectedPath();
				return;
			}
            
			menu.repaint();
			menu.validate();

		}
	}
}