/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Gerhard Leonhartsberger. Portions created by Gerhard 
	Leonhartsberger are Copyright(C) by Gerhard Leonhartsberger. 
	All Rights Reserved.

	Contributor(s): ________________________
*/
package net.java.plaf.windows.xp;

import javax.swing.UIDefaults;
import javax.swing.UIManager;

import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * MenuItems under the Windows Look and Feel on Windows XP do not have the
 * correct spacing of icons and menu item text.
 * This patch fixes the following winlaf issues:
 * <ul>
 * <li><b>Issue 24:</b> Wrong insets for JMenuItem with icon and text</li>
 * </ul>
 * 
 * @author Gerhard.Leonhartsberger@scch.at
 */
public class XPMenuItemPatch implements LookAndFeelPatch {

	/* (non-Javadoc)
	 * @see net.java.plaf.LookAndFeelPatch#isApplicable(net.java.plaf.Environment)
	 */
	public boolean isApplicable(Environment env) {
		return env.isWindowsLookAndFeel() && env.isWindowsXPThemed();
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.LookAndFeelPatch#patch(net.java.plaf.Environment)
	 */
	public void patch(Environment env) {
		UIDefaults defaults = UIManager.getDefaults();
		defaults.put("MenuItemUI", "net.java.plaf.windows.xp.XPMenuItemUI");  //$NON-NLS-1$//$NON-NLS-2$
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.LookAndFeelPatch#unpatch()
	 */
	public void unpatch() {
		UIDefaults defaults = UIManager.getDefaults();
		defaults.put("MenuItemUI", "com.sun.java.swing.plaf.windows.WindowsMenuItemUI"); //$NON-NLS-1$ //$NON-NLS-2$
	}
}
