/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.xp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;

public class XPComboBoxUI extends WindowsComboBoxUI
{
  public static ComponentUI createUI( JComponent comp )
  {
    return new XPComboBoxUI();
  }
  
  
  protected LayoutManager createLayoutManager()
  {
    return new XPComboBoxLayoutManager();
  }

  protected Insets getInsets()
  {
    return UIManager.getInsets( "ComboBox.margin" ); //$NON-NLS-1$
  }

  /**
   * We override the combo box layout manager, because XP combo box arrow 
   * buttons do not inherit the parent insets of the combo box.
   */
  private class XPComboBoxLayoutManager implements LayoutManager 
  {
    public void addLayoutComponent(String name, Component comp) {}

    public void removeLayoutComponent(Component comp) {}

    public Dimension preferredLayoutSize(Container parent) 
    {
      return parent.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container parent) 
    {
      return parent.getMinimumSize();
    }

    public void layoutContainer(Container parent) 
    {
      JComboBox cb = (JComboBox)parent;
      int width = cb.getWidth();
      int height = cb.getHeight();
            
      Rectangle cvb;

      int buttonWidth = arrowButton.getPreferredSize().width;

      if ( arrowButton != null ) 
      {
        if(cb.getComponentOrientation().isLeftToRight()) 
        {
          arrowButton.setBounds( width - (1 + buttonWidth), 
            1, buttonWidth, height - 2);
        }
        else 
        {
          arrowButton.setBounds( 1, 1, buttonWidth, height - 2);
        }
      }

      if ( editor != null ) 
      {
        cvb = rectangleForCurrentValue();
        editor.setBounds(cvb);
      }
    }
  }  
}