/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/


package net.java.plaf.windows.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Caret;

/**
 * 
 */
public class WindowsTextFieldUI
  extends com.sun.java.swing.plaf.windows.WindowsTextFieldUI
{

  public static ComponentUI createUI(JComponent c)
  {
    return new WindowsTextFieldUI();
  }
  
  public void installDefaults()
  {
    super.installDefaults();
  }

  protected void propertyChange( PropertyChangeEvent evt) 
  {
    super.propertyChange( evt );
    
    // Make the I-beam cursor appear on non-editable text fields.
    if ( UIManager.getBoolean ( "TextField.patchCaret" ) ) //$NON-NLS-1$
    {
      if ( evt.getPropertyName().equals("editable") ||  //$NON-NLS-1$
           evt.getPropertyName().equals( "enabled" ) )  //$NON-NLS-1$
      {
        JTextField source = (JTextField)evt.getSource();
        if ( source.isEnabled() )
        {
          source.setCursor( Cursor.getPredefinedCursor( Cursor.TEXT_CURSOR ) );
        }
        else
        {
          source.setCursor( Cursor.getPredefinedCursor( Cursor.DEFAULT_CURSOR ) );
        }
      }
    }
  }

  /**
   * We override the default background painter to paint the correct
   * background color for disabled or non-editable text fields
   *
   * @param g the graphics context in which to paint
   */
  protected void paintBackground(Graphics g)
  {
    if ( UIManager.getBoolean( "TextField.patchDisabledBackground" ) ) //$NON-NLS-1$
    {
      if ( !getComponent().isEnabled() )
      {
        Color c = UIManager.getColor( "control" ); //$NON-NLS-1$
        g.setColor( c );
        g.fillRect(0, 0, getComponent().getWidth(), getComponent().getHeight());
        return;
      }
    }
    
    if ( UIManager.getBoolean( "TextField.patchReadOnlyBackground" ) ) //$NON-NLS-1$
    {
      if ( !getComponent().isEditable() )
      {
        Color c = UIManager.getColor( "control" ); //$NON-NLS-1$
        g.setColor( c );
        g.fillRect(0, 0, getComponent().getWidth(), getComponent().getHeight());
        return;
      }
    }
  
    super.paintBackground( g );
  }

  protected Caret createCaret() 
  {
    if ( UIManager.getBoolean ( "TextField.patchCaret" ) ) //$NON-NLS-1$
    {
      return new WindowsTextFieldCaret();
    }
    return super.createCaret();
  }
  
}
