/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/


package net.java.plaf.windows.common;

import javax.swing.UIDefaults;
import javax.swing.UIManager;

import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * Patch the windows look and feel textfield to resolve the following issues:
 * <ul>
 *  <li><b>Issue 12:</b> Tabbing into a text field containing text 
 *    should select the text</li>
 *  <li><b>Issue 15:</b> Non editable and disabled text components have 
 *    incorrect background color</li>
 *  <li><b>Issue 21:</b> Non-editable text fields should show caret 
 *    [and have i-beam cursor]</li>
 * </ul>
 */
public class WindowsTextFieldPatch implements LookAndFeelPatch
{

  public boolean isApplicable( Environment env )
  {
    return env.isWindowsLookAndFeel();
  }
  
  public void patch( Environment env )
  {
    UIDefaults defaults = UIManager.getDefaults();

    // Sun bug 4174290 was fixed in Java 1.4.0, for disabled fields. Allegedly.
    // However, it definitely still reproduces in Java 1.4.2 when the XP 
    // look and feel is off. When the XP look and feel is on, it uses the
    // wrong background color anyway :( In other words, this is still very,
    // very broken.

    defaults.put( "TextField.patchDisabledBackground", Boolean.TRUE ); //$NON-NLS-1$
    
    // Read only color is an existing, unfixed bug ( 4883120 )
    
    defaults.put( "TextField.patchReadOnlyBackground", Boolean.TRUE ); //$NON-NLS-1$
    
    // Caret should be shown when field is not editable - bug 4512626
    // Also makes the I-Beam cursor present for non-editable fields.
    
    defaults.put( "TextField.patchCaret", Boolean.TRUE ); //$NON-NLS-1$
    
    // Java bug 4337647, which Sun "will not fix". Select the text in the
    // field when it gains focus by means other than a mouse click...
    defaults.put( "TextField.patchSelectOnFocus", Boolean.TRUE ); //$NON-NLS-1$
    
    defaults.put( "TextFieldUI",  //$NON-NLS-1$
      "net.java.plaf.windows.common.WindowsTextFieldUI" ); //$NON-NLS-1$
      
      
  }
  
  public void unpatch()
  {
    
  }
}