/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/


package net.java.plaf.windows.common;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;

/**
 * Fixed caret for Windows. Fixes two issues:
 * 
 * 1. The caret should still be visible in read only fields
 * 2. The text in the field should be selected when focus is gained if the
 *    focus was gained via the keyboard.
 */
public class WindowsTextFieldCaret extends DefaultCaret implements UIResource
{
  private boolean m_selectAll = true;

  public void focusGained( FocusEvent e) 
  {
    if (getComponent().isEnabled()) 
    {
      setVisible(true);
      setSelectionVisible(true);
	  }
    
    if ( getComponent().isEnabled() && m_selectAll &&
      UIManager.getBoolean( "TextField.patchSelectOnFocus" ) ) //$NON-NLS-1$
    {
      super.setDot( 0 );
      super.moveDot( getComponent().getDocument().getLength() );
    }
  }
  
  public void focusLost( FocusEvent e )
  {
    super.focusLost( e );
    if ( !e.isTemporary() )
    {
      m_selectAll = true;
    }
  }
  
  public void mousePressed(MouseEvent e)
  {
    if ( SwingUtilities.isLeftMouseButton( e ) )
    {
      m_selectAll = false;
    }
    super.mousePressed( e );
  }
  
}