/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * This patch fixes the following winlaf issues:
 * <ul>
 * <li><b>Issue 32:</b> button size is wrong in JOptionPane</li>
 * </ul>
 */
public class WindowsOptionPanePatch  implements LookAndFeelPatch
{
  
  public void patch( Environment env )
  {  
    UIDefaults defaults = UIManager.getDefaults();  
    // The glyph used on radio button menu items doesn't resemble the native
    // equivalent.
    defaults.put( "OptionPaneUI",  //$NON-NLS-1$
      "net.java.plaf.windows.common.WindowsOptionPaneUI" ); //$NON-NLS-1$
      
    // The bottom of the border( space below the buttons ) is a few pixels
    // too big (about 2)
    Integer ten = new Integer( 10 );
    Object optionPaneBorder = new UIDefaults.ProxyLazyValue(
     "javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", //$NON-NLS-1$
     new Object[] { ten, ten, ten, ten});      
    defaults.put( "OptionPane.border", optionPaneBorder ); //$NON-NLS-1$
  }


  public void unpatch()
  {
    
  }
  
  public boolean isApplicable( Environment env )
  {
    return env.isWindowsLookAndFeel();
  }  
}