/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

/**
 * This patch fixes the following winlaf issues:
 * <ul>
 * <li><b>Issue 16:</b> Icon glyph for radio button menu item is wrong</li>
 * <li><b>Issue 17:</b> Disabled menu items should continue to highlight</li>
 * </ul>
 */
public class WindowsMenuPatch implements LookAndFeelPatch
{
  
  public void patch( Environment env )
  {  
    UIDefaults defaults = UIManager.getDefaults();  
    // The glyph used on radio button menu items doesn't resemble the native
    // equivalent.
    defaults.put( "RadioButtonMenuItem.checkIcon",  //$NON-NLS-1$
      new WindowsRadioButtonMenuItemIcon() );
    
    // Disabled menu items should continue to show a highlight when the mouse
    // is over them.
    defaults.put( "MenuItemUI",  //$NON-NLS-1$
      "net.java.plaf.windows.common.WindowsMenuItemUI" ); //$NON-NLS-1$
//    defaults.put( "CheckBoxMenuItemUI", 
//      "net.java.plaf.windows.common.WindowsCheckBoxMenuItemUI" );
//    defaults.put( "RadioButtonMenuItemUI", 
//      "net.java.plaf.windows.common.WindowsRadioButtonMenuItemUI" );      
    
    // Radio button menu items are offset a couple of pixels to the left 
    // on Windows Classic.
		defaults.put(
			"RadioButtonMenuItem.margin", //$NON-NLS-1$
			new InsetsUIResource(2, 4, 2, 2));
  }


  public void unpatch()
  {
    
  }
  
  public boolean isApplicable( Environment env )
  {
    return env.isWindowsLookAndFeel();
  }  

  private static class WindowsRadioButtonMenuItemIcon 
    implements Icon, UIResource
  {
    public void paintIcon(Component c, Graphics g, int x, int y) 
    {
      AbstractButton b = (AbstractButton) c;
      if (b.isSelected() == true) 
      {
        g.fillRect( x + 1, y, 4, 6 );
        g.fillRect( x, y + 1, 6, 4 );
      }            
    }
    
    public int getIconWidth() { return 6; }
    public int getIconHeight() { return 6; }
  }

}