/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;

public class WindowsMenuItemCommonUI 
{


  void paintBackground( Graphics g, JMenuItem item, Color bgColor, 
    boolean mouseOver )
  {
    ButtonModel model = item.getModel();
  
    Color oldColor = g.getColor();

    if ( item.isOpaque() )
    {
      if ( item.isArmed() || (item instanceof JMenu && model.isSelected()) || 
           ( !model.isEnabled() && mouseOver )  )
      {
        g.setColor( bgColor );
      }
      else
      {
        g.setColor( item.getBackground() );
      }
    }
    g.fillRect( 0, 0, item.getWidth(), item.getHeight() );    

    g.setColor( oldColor );    
  }
  
  void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, 
    String text, Color selectionForeground, String propertyPrefix )
  {
    ButtonModel model = menuItem.getModel();
    FontMetrics fontMetrics = g.getFontMetrics();

    int mnemIndex = menuItem.getDisplayedMnemonicIndex();
	  if ( WindowsLookAndFeel.isMnemonicHidden()) 
    {
      mnemIndex = -1;
	  }
    if ( !model.isEnabled() )
    {
      g.setColor( UIManager.getColor( propertyPrefix + ".disabledForeground" ) );  //$NON-NLS-1$
    }
    else
    {
      if ( model.isArmed() ||  (menuItem instanceof JMenu && model.isSelected()) ) 
      {
        g.setColor( selectionForeground );
      }
    }
    BasicGraphicsUtils.drawStringUnderlineCharAt(g,text,mnemIndex,
              textRect.x, 
              textRect.y + fontMetrics.getAscent());         
  }
  
  
}