/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Gerhard Leonhartsberger. Portions created by 
	Gerhard Leonhartsberger are Copyright(C) Gerhard Leonhartsberger. 
	All Rights Reserved.

	Contributor(s): ___________________________.
*/
package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

import net.java.plaf.windows.xp.DefaultTreeCellRenderer;

public class TreePatchTestModule extends PatchTestModule {

	public TreePatchTestModule() {
		super("Trees");
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.test.PatchTestModule#createPatchTestPane(java.awt.Container)
	 */
	protected void createPatchTestPane(Container contentPane) {

		JTree tree = new JTree();
		tree.setCellRenderer(new DefaultTreeCellRenderer());
		JPanel panel = new JPanel(new BorderLayout());
		panel.add( new JScrollPane( tree ), BorderLayout.CENTER);
		contentPane.add(panel, BorderLayout.CENTER);
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.test.IPatchTestModule#getIssueDescription()
	 */
	public String getIssueDescription() {
		return "<b>Issue 27</b>: Selected nodes contained by a JTree remains "
			+ "selected highlighted when JTree looses focus<br>" +
      "<b>Issue 11</b>: Default folder icon used by JTree resembles Windows Classic";
	}
}
