package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class TextFieldMarginPatchTestModule extends PatchTestModule {

	public TextFieldMarginPatchTestModule() {
		super( "Text Fields" );
	}
	
	protected void createPatchTestPane(Container contentPane) {
		
		
		JTextField textField1 = new JTextField("normal text field");
		JTextField textField2 = new JTextField("non-editable text field");
		textField2.setEditable(false);
    JTextField textField3 = new JTextField( "disabled text field" );
    textField3.setEnabled( false );
    JPasswordField passwordField = new JPasswordField( "Password field" );
    
		
		JPanel panel = new JPanel( new GridBagLayout() );
    
    GridBagConstraints gbc = new GridBagConstraints( 0, 0, 1, 1, 1.0, 0.0, 
      GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, 
      new Insets( 0, 0, 5, 0 ), 0, 0 );
    
    panel.add( textField1, gbc );
    gbc.gridy++;
    panel.add( textField2, gbc );
    gbc.gridy++;
    panel.add( textField3, gbc );
    gbc.gridy++;
    panel.add( passwordField, gbc );
    
    gbc.gridy++;
    gbc.weighty = 1.0;

    panel.add( new JPanel(), gbc );
    
		contentPane.add(panel, BorderLayout.CENTER);
	}

	public String getIssueDescription() {
		return 
      "<b>Issue 14:</b> Internal insets of JTextField are wrong under Windows XP L&F<br>"+
      "<b>Issue 15:</b> Non editable and disabled text components have incorrect background color<br>"+
      "<b>Issue 19:</b> Password echo character is still * in JPasswordField<br>"+
      "<b>Issue 21:</b> Non-editable text fields should show caret";
	}
}
