/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system.eventlog;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastError;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.RegistryValueTransformer;
import com.jniwrapper.win32.system.AdvApi32;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.eventlog.EventLogMessage;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EventLog
extends Handle {
    private static final FunctionName FUNCTION_OPENEVENTLOG = new FunctionName("OpenEventLog");
    private static final FunctionName FUNCTION_BACKUPEVENTLOG = new FunctionName("BackupEventLog");
    private static final FunctionName FUNCTION_CLEAREVENTLOG = new FunctionName("ClearEventLog");
    private static final String FUNCTION_CLOSEEVENTLOG = "CloseEventLog";
    private static final String FUNCTION_GETNUMBEROFRECORDS = "GetNumberOfEventLogRecords";
    private static final String FUNCTION_GETOLDESTRECORD = "GetOldestEventLogRecord";
    private static final FunctionName FUNCTION_OPENBACKUPEVENTLOG = new FunctionName("OpenBackupEventLog");
    private static final FunctionName FUNCTION_READEVENTLOG = new FunctionName("ReadEventLog");
    private static final FunctionName FUNCTION_REGISTEREVENTSOURCE = new FunctionName("RegisterEventSource");
    private static final FunctionName FUNCTION_DEREGISTEREVENTSOURCE = new FunctionName("DeregisterEventSource");
    private static final FunctionName FUNCTION_REPORTEVENT = new FunctionName("ReportEvent");
    private static final FunctionName FUNCTION_LOOKUPACCOUNTSID = new FunctionName("LookupAccountSid");
    private static final FunctionName FUNCTION_LOADLIBRARY = new FunctionName("LoadLibrary");
    private static final FunctionName FUNCTION_LOADLIBRARYEX = new FunctionName("LoadLibraryEx");
    private static final FunctionName FUNCTION_FORMATMESSAGE = new FunctionName("FormatMessage");
    private static final String NO_FORMAT_FILE_MESSAGE = "The description for Event ID {0} from source {1} cannot be found. Either the component that raises this event is not installed on your local computer or the installation is corrupted. You can install or repair the component on the local computer.\n\nIf the event originated on another computer, the display information had to be saved with the event.\n\nThe following information was included with the event: \n\n{2}";
    private static final long EVENTLOG_SEQUENTIAL_READ = 1L;
    private static final long EVENTLOG_SEEK_READ = 2L;
    private static final long EVENTLOG_FORWARDS_READ = 4L;
    private static final long EVENTLOG_BACKWARDS_READ = 8L;
    private static final long FORMAT_MESSAGE_ALLOCATE_BUFFER = 256L;
    private static final long FORMAT_MESSAGE_ARGUMENT_ARRAY = 8192L;
    private static final long FORMAT_MESSAGE_FROM_HMODULE = 2048L;
    private static final long FORMAT_MESSAGE_FROM_STRING = 1024L;
    private static final long FORMAT_MESSAGE_FROM_SYSTEM = 4096L;
    private static final long FORMAT_MESSAGE_IGNORE_INSERTS = 512L;
    private static final long FORMAT_MESSAGE_MAX_WIDTH_MASK = 255L;
    private static final long LOAD_LIBRARY_AS_IMAGE_RESOURCE = 32L;
    private static final long LOAD_LIBRARY_AS_DATAFILE = 2L;
    private static final int BUFFER_SIZE = 65536;
    private static final int MAXIMUM_MESSAGE_STRING_COUNT = 99;
    private String _name;
    private String _server;
    private RegistryKey _registryKey;
    private HashMap _keysMap;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;
    static /* synthetic */ Class class$com$jniwrapper$Str;

    private EventLog() {
    }

    public EventLog(String logName) {
        this(null, logName);
    }

    public EventLog(String serverName, String logName) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPENEVENTLOG.toString());
        Object server = serverName == null ? new Pointer(null, true) : new Str(serverName);
        long result = function.invoke((Parameter)this, (Parameter)server, (Parameter)new Str(logName));
        if (this.getValue() == 0L) {
            throw new RuntimeException(LastError.getMessage(result));
        }
        this._name = logName;
        this._server = serverName;
        RegistryKeyValues.registerAssociation(RegistryKeyType.EXPAND_SZ, RegistryValueTransformer.STRING_EXPAND_TRANSFORMER);
        this._registryKey = RegistryKey.LOCAL_MACHINE.openSubKey("SYSTEM\\CurrentControlSet\\services\\eventlog\\" + this._name);
        this._keysMap = new HashMap();
    }

    public String getLogName() {
        return this._name;
    }

    public String getServerName() {
        return this._server;
    }

    public static EventLog openBackup(File backup) {
        EventLog eventLog;
        if (backup == null || !backup.isFile()) {
            throw new IllegalArgumentException("Illegal backup file.");
        }
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPENBACKUPEVENTLOG.toString());
        long result = function.invoke((Parameter)(eventLog = new EventLog()), (Parameter)new Pointer(null, true), (Parameter)new Str(backup.getAbsolutePath()));
        if (result != 0L) {
            throw new RuntimeException(LastError.getMessage(result));
        }
        return eventLog;
    }

    public void backup(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Illegal backup file.");
        }
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_BACKUPEVENTLOG.toString());
        long result = function.invoke(null, (Parameter)this, (Parameter)new Str(file.getAbsolutePath()));
        if (result != 0L) {
            throw new LastErrorException(result);
        }
    }

    public void close() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_CLOSEEVENTLOG);
        long result = function.invoke(null, (Parameter)this);
        if (result != 0L && result != 38L) {
            throw new LastErrorException(result);
        }
    }

    public void clear() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_CLEAREVENTLOG.toString());
        long result = function.invoke(null, (Parameter)this, (Parameter)new Pointer(null, true));
        if (result != 0L && result != 38L) {
            throw new LastErrorException(result);
        }
    }

    public int getRecordsCount() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_GETNUMBEROFRECORDS);
        UInt32 count = new UInt32();
        IntBool retVal = new IntBool();
        long result = function.invoke((Parameter)retVal, (Parameter)this, (Parameter)new Pointer((Parameter)count));
        if (retVal.getValue() == 0L) {
            throw new LastErrorException(result);
        }
        return (int)count.getValue();
    }

    private int getOldestRecordNumber() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_GETOLDESTRECORD);
        UInt32 count = new UInt32();
        IntBool retVal = new IntBool();
        long result = function.invoke((Parameter)retVal, (Parameter)this, (Parameter)new Pointer((Parameter)count));
        if (retVal.getValue() != 0L) {
            // empty if block
        }
        return (int)count.getValue();
    }

    private void flush() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_READEVENTLOG.toString());
        function.invoke(null, new Parameter[]{this, new UInt32(6L), new UInt32((long)this.getOldestRecordNumber()), new Pointer((Parameter)new UInt8()), new UInt32(0L), new Pointer((Parameter)new UInt32()), new Pointer((Parameter)new UInt32())});
    }

    public List getMessages() {
        this.flush();
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_READEVENTLOG.toString());
        LinkedList<EventLogMessage> result = new LinkedList<EventLogMessage>();
        if (this.getRecordsCount() == 0) {
            return result;
        }
        while (true) {
            int size;
            UInt32 read = new UInt32();
            PrimitiveArray array = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? EventLog.class$("com.jniwrapper.UInt8") : class$com$jniwrapper$UInt8, 65536);
            int offset = 0;
            IntBool retVal = new IntBool();
            long error = function.invoke((Parameter)retVal, new Parameter[]{this, new UInt32(5L), new UInt32(0L), new Pointer((Parameter)array), new UInt32(65536L), new Pointer((Parameter)read), new Pointer((Parameter)new UInt32())});
            if (retVal.getValue() == 0L && error != 0L && error != 38L && error != 122L) {
                throw new LastErrorException(error);
            }
            if (read.getValue() == 0L) break;
            byte[] bytes = array.getBytes();
            int total = (int)read.getValue();
            UInt32 dwSize = new UInt32();
            do {
                byte[] bSize = new byte[4];
                System.arraycopy(bytes, offset, bSize, 0, 4);
                dwSize.read(bSize, 0);
                size = (int)dwSize.getValue();
                byte[] data = new byte[size];
                System.arraycopy(bytes, offset, data, 0, size);
                result.add(this.parseBytes(data));
            } while ((offset += size) != total);
        }
        this.flushKeysMap();
        return result;
    }

    private void flushKeysMap() {
        Function freeLibrary = Kernel32.getInstance().getFunction("FreeLibrary");
        Iterator iterator = this._keysMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Handle loadedLibraryFile = (Handle)((Object)iterator.next().getValue());
            freeLibrary.invoke(null, (Parameter)loadedLibraryFile);
        }
        this._keysMap.clear();
    }

    private EventLogMessage parseBytes(byte[] bytes) {
        int dataLength;
        Function accountSID = AdvApi32.getInstance().getFunction(FUNCTION_LOOKUPACCOUNTSID.toString());
        EventLogMessageInt logMessageInt = new EventLogMessageInt();
        logMessageInt.read(bytes, 0);
        EventLogMessage eventLogMessage = new EventLogMessage();
        eventLogMessage.setRecordNumber((int)logMessageInt.getRecordNumber());
        eventLogMessage.setEventID(logMessageInt.getEventID() & 0xFFFFL);
        eventLogMessage.setDate(new Date(logMessageInt.getTimeWritten() * 1000L));
        eventLogMessage.setCategory((int)logMessageInt.getEventCategory());
        eventLogMessage.setEventType(new EventLogMessage.Type((int)logMessageInt.getEventType()));
        int sourceSize = logMessageInt.getUserSidOffset() != 0 ? logMessageInt.getUserSidOffset() - 1 - logMessageInt.getLength() : logMessageInt.getStringOffset() - 1 - logMessageInt.getLength();
        byte[] bSource = new byte[sourceSize];
        System.arraycopy(bytes, logMessageInt.getLength(), bSource, 0, sourceSize);
        String source = new String(bSource);
        int bound = this.getStringSeparatorPos(source);
        String strSource = source.substring(0, bound).replaceAll("\u0000", "");
        eventLogMessage.setSource(strSource);
        String computerName = this.getNullTerminatedString(source.substring(bound + 2));
        eventLogMessage.setComputer(computerName.replaceAll("\u0000", ""));
        int messageSize = logMessageInt.getDataOffset() - logMessageInt.getStringOffset();
        int stringsCount = (int)logMessageInt._numStrings.getValue();
        if (stringsCount > 0) {
            byte[] messageBytes = new byte[messageSize];
            System.arraycopy(bytes, logMessageInt.getStringOffset(), messageBytes, 0, messageSize);
            String message = this.retrieveMessage(messageBytes, strSource, logMessageInt._eventID, stringsCount);
            eventLogMessage.setMessage(message);
        }
        if ((dataLength = logMessageInt.getDataLength()) > 0) {
            byte[] data = new byte[dataLength];
            System.arraycopy(bytes, logMessageInt.getDataOffset(), data, 0, dataLength);
            eventLogMessage.setData(data);
        }
        byte[] userSid = new byte[logMessageInt.getUserSidLength()];
        System.arraycopy(bytes, logMessageInt.getUserSidOffset(), userSid, 0, logMessageInt.getUserSidLength());
        if (userSid.length != 0) {
            Str name = new Str(255);
            Int id = new Int();
            accountSID.invoke(null, new Parameter[]{new Pointer(null, true), new Pointer((Parameter)new PrimitiveArray(userSid)), new Pointer((Parameter)name), new Pointer((Parameter)new UInt32(255L)), new Pointer((Parameter)new Str(255)), new Pointer((Parameter)new UInt32(255L)), new Pointer((Parameter)id)});
            eventLogMessage.setUser(name.getValue());
        } else {
            eventLogMessage.setUser(null);
        }
        return eventLogMessage;
    }

    private String getNullTerminatedString(String unicodeStr) {
        int indexOfNull = unicodeStr.indexOf("\u0000\u0000");
        return unicodeStr.substring(0, indexOfNull);
    }

    private String retrieveMessage(byte[] message, String sourceName, UInt32 messageID, int stringsCount) {
        int curStringIndex;
        String formattedString = null;
        Handle messageFormatFile = this.getMessageFileFormat(sourceName);
        String msg = new String(message);
        int beginIndex = 0;
        Pointer[] addresses = new Pointer[99];
        StringBuffer messageStrings = new StringBuffer();
        for (curStringIndex = 0; curStringIndex < stringsCount; ++curStringIndex) {
            int endIndex = msg.indexOf("\u0000\u0000", beginIndex);
            int length = endIndex - beginIndex;
            int increment = 2;
            if (length % 2 == 1) {
                ++increment;
            }
            byte[] messageStringBytes = new byte[]{};
            messageStringBytes = new byte[length += increment];
            System.arraycopy(message, beginIndex, messageStringBytes, 0, length);
            addresses[curStringIndex] = new Pointer((Parameter)new PrimitiveArray(messageStringBytes));
            String messageString = new String(messageStringBytes).replaceAll("\u0000", "");
            messageStrings.append(messageString);
            beginIndex = endIndex + increment;
        }
        byte[] emptyStringBytes = new byte[]{0, 0};
        Pointer emptyStringPointer = new Pointer((Parameter)new PrimitiveArray(emptyStringBytes));
        while (curStringIndex < 99) {
            addresses[curStringIndex] = emptyStringPointer;
            ++curStringIndex;
        }
        if (messageFormatFile != null) {
            Str retrievedMessage = new Str("", 65536);
            Function formatMessage = Kernel32.getInstance().getFunction(FUNCTION_FORMATMESSAGE.toString());
            UInt32 flags = new UInt32(14591L);
            UInt32 returnValue = new UInt32();
            formatMessage.invoke((Parameter)returnValue, new Parameter[]{flags, messageFormatFile.isNull() ? new Pointer.Void() : messageFormatFile, messageID, new UInt32(0L), new Pointer((Parameter)retrievedMessage), new UInt32((long)retrievedMessage.getMaxLength()), new Pointer((Parameter)new PrimitiveArray((Parameter[])addresses))});
            formattedString = retrievedMessage.toString();
        }
        if (formattedString == null || formattedString.equals("")) {
            formattedString = MessageFormat.format(NO_FORMAT_FILE_MESSAGE, Long.toString(messageID.getValue()), sourceName, messageStrings.toString());
        }
        return formattedString;
    }

    private Handle getMessageFileFormat(String sourceName) {
        String eventMessageFile = "EventMessageFile";
        Handle messageFormatFile = (Handle)((Object)this._keysMap.get(sourceName));
        if (messageFormatFile == null && this._registryKey.exists(sourceName)) {
            RegistryKey registryKey = this._registryKey.openSubKey(sourceName);
            RegistryKeyValues keyValues = registryKey.values();
            String eventMessageFilePath = (String)keyValues.get("EventMessageFile");
            if (eventMessageFilePath != null) {
                Function loadLibraryEx = Kernel32.getInstance().getFunction(FUNCTION_LOADLIBRARYEX.toString());
                messageFormatFile = new Handle();
                Str fileName = new Str(eventMessageFilePath);
                UInt32 flags = new UInt32(34L);
                loadLibraryEx.invoke((Parameter)messageFormatFile, new Parameter[]{fileName, new Pointer.Void(), flags});
                this._keysMap.put(sourceName, messageFormatFile);
            }
            registryKey.close();
        }
        return messageFormatFile;
    }

    private int getStringSeparatorPos(String s) {
        int pos = 0;
        while ((pos = s.indexOf(0, pos)) != -1) {
            if (s.charAt(pos - 1) == '\u0000' && s.charAt(pos + 1) == '\u0000') {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    public static void reportEvent(EventLogMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Illegal message argument.");
        }
        EventLog eventLog = EventLog.registerSource(message.getSource());
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_REPORTEVENT.toString());
        PrimitiveArray array = new PrimitiveArray(class$com$jniwrapper$Str == null ? (class$com$jniwrapper$Str = EventLog.class$("com.jniwrapper.Str")) : class$com$jniwrapper$Str, 1);
        if (message.getMessage() != null) {
            array.setElement(0, (Parameter)new Pointer((Parameter)new Str(message.getMessage())));
        } else {
            array.setElement(0, (Parameter)new Pointer((Parameter)new Str()));
        }
        int dataSize = 0;
        Pointer.Void pData = new Pointer.Void();
        if (message.getData() != null) {
            dataSize = message.getData().length;
            new Pointer((Parameter)new PrimitiveArray(message.getData())).castTo(pData);
        }
        function.invoke(null, new Parameter[]{eventLog, new UInt16(message.getEventType() == null ? EventLogMessage.Type.INFORMATION.getValue() : message.getEventType().getValue()), new UInt16(message.getCategory()), new UInt32(message.getEventID()), new Pointer(null, true), new UInt16(1), new UInt32((long)dataSize), new Pointer((Parameter)array), pData});
        EventLog.deregisterSource(eventLog);
    }

    private static EventLog registerSource(String logName) {
        EventLog eventLog;
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_REGISTEREVENTSOURCE.toString());
        long result = function.invoke((Parameter)(eventLog = new EventLog()), (Parameter)new Pointer(null, true), (Parameter)new Str(logName));
        if (result != 0L) {
            throw new LastErrorException(result);
        }
        return eventLog;
    }

    private static void deregisterSource(EventLog eventLog) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_DEREGISTEREVENTSOURCE.toString());
        Bool result = new Bool();
        long errorCode = function.invoke((Parameter)result, (Parameter)eventLog);
        if (!result.getValue()) {
            throw new LastErrorException(errorCode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EventLogMessageInt
    extends Structure {
        private UInt32 _length = new UInt32();
        private UInt32 _reserved = new UInt32();
        private UInt32 _recordNumber = new UInt32();
        private UInt32 _timeGenerated = new UInt32();
        private UInt32 _timeWritten = new UInt32();
        private UInt32 _eventID = new UInt32();
        private UInt16 _eventType = new UInt16();
        private UInt16 _numStrings = new UInt16();
        private UInt16 _eventCategory = new UInt16();
        private UInt16 _reservedFlags = new UInt16();
        private UInt32 _closingRecordNumber = new UInt32();
        private UInt32 _stringOffset = new UInt32();
        private UInt32 _userSidLength = new UInt32();
        private UInt32 _userSidOffset = new UInt32();
        private UInt32 _dataLength = new UInt32();
        private UInt32 _dataOffset = new UInt32();

        public EventLogMessageInt() {
            this.init(new Parameter[]{this._length, this._reserved, this._recordNumber, this._timeGenerated, this._timeWritten, this._eventID, this._eventType, this._numStrings, this._eventCategory, this._reservedFlags, this._closingRecordNumber, this._stringOffset, this._userSidLength, this._userSidOffset, this._dataLength, this._dataOffset});
        }

        public EventLogMessageInt(EventLogMessageInt that) {
            this();
            this.initFrom(that);
        }

        public long getRecordNumber() {
            return this._recordNumber.getValue();
        }

        public long getTimeGenerated() {
            return this._timeGenerated.getValue();
        }

        public long getEventID() {
            return this._eventID.getValue();
        }

        public long getEventType() {
            return this._eventType.getValue();
        }

        public long getEventCategory() {
            return this._eventCategory.getValue();
        }

        public long getRecordLength() {
            return this._length.getValue();
        }

        public long getTimeWritten() {
            return this._timeWritten.getValue();
        }

        public int getUserSidLength() {
            return (int)this._userSidLength.getValue();
        }

        public int getUserSidOffset() {
            return (int)this._userSidOffset.getValue();
        }

        public int getStringOffset() {
            return (int)this._stringOffset.getValue();
        }

        public int getDataLength() {
            return (int)this._dataLength.getValue();
        }

        public int getDataOffset() {
            return (int)this._dataOffset.getValue();
        }

        public Object clone() {
            return new EventLogMessageInt(this);
        }
    }
}

