/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Int;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.automation.OleStr;
import com.jniwrapper.win32.automation.types.VariantBool;
import com.jniwrapper.win32.com.impl.IPersistFileImpl;
import com.jniwrapper.win32.com.impl.IUnknownImpl;
import com.jniwrapper.win32.com.types.ClsCtx;
import com.jniwrapper.win32.io.Win32FindData;
import com.jniwrapper.win32.shell.impl.IShellLinkImpl;
import com.jniwrapper.win32.stg.types.StgMode;
import com.jniwrapper.win32.ui.Wnd;
import java.io.File;
import java.io.IOException;

public class ShellLink {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$shell$ShellLink == null ? (class$com$jniwrapper$win32$shell$ShellLink = ShellLink.class$("com.jniwrapper.win32.shell.ShellLink")) : class$com$jniwrapper$win32$shell$ShellLink));
    static final int MAX_PATH = 260;
    private IShellLinkImpl _shellLinkImpl;
    private IPersistFileImpl _persistFileImpl;
    private File _linkFile;
    static /* synthetic */ Class class$com$jniwrapper$win32$shell$ShellLink;

    public ShellLink(File linkFile) {
        if (!linkFile.exists()) {
            throw new IllegalArgumentException("Link file not found.");
        }
        this._shellLinkImpl = new IShellLinkImpl(ClsCtx.INPROC_SERVER);
        this._persistFileImpl = new IPersistFileImpl((IUnknownImpl)this._shellLinkImpl);
        this._linkFile = linkFile;
    }

    public ShellLink(File linkFile, File sourceFile) throws IOException {
        this._shellLinkImpl = new IShellLinkImpl(ClsCtx.INPROC_SERVER);
        this._persistFileImpl = new IPersistFileImpl((IUnknownImpl)this._shellLinkImpl);
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Source file not found.");
        }
        if (!linkFile.exists()) {
            linkFile.createNewFile();
        }
        this._linkFile = linkFile;
        this.setSourceFile(sourceFile);
    }

    private void saveFile() {
        this._persistFileImpl.save(new OleStr(this._linkFile.getAbsolutePath()), new VariantBool(false));
    }

    private void loadFile() {
        this._persistFileImpl.load(new OleStr(this._linkFile.getAbsolutePath()), new StgMode(0L));
    }

    public File getLinkFile() {
        return this._linkFile;
    }

    public void setSourceFile(File sourceFile) {
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Source file not found.");
        }
        this._shellLinkImpl.setPath(new Str(sourceFile.getAbsolutePath()));
        this.saveFile();
    }

    public File getSourceFile() {
        Str value = new Str(260);
        this.loadFile();
        this._shellLinkImpl.resolve(new Wnd(), new UInt32(1L));
        Win32FindData data = new Win32FindData();
        this._shellLinkImpl.getPath(value, new Int((long)value.getMaxLength()), data, new UInt32(4L));
        return new File(value.getValue());
    }

    public void setDescription(String description) {
        this.loadFile();
        this._shellLinkImpl.setDescription(new Str(description));
        this.saveFile();
    }

    public String getDescription() {
        this.loadFile();
        Str res = this._shellLinkImpl.getDescription(new Int(260L));
        return res.getValue();
    }

    public void setIconPath(File iconFile, int iconIndex) {
        if (!iconFile.exists()) {
            throw new IllegalArgumentException("Icon file not found.");
        }
        this.loadFile();
        this._shellLinkImpl.setIconLocation(new Str(iconFile.getAbsolutePath()), new Int((long)iconIndex));
        this.saveFile();
    }

    public String getIconPath() {
        Str iconPath = new Str(260);
        Int iconIndex = new Int();
        this.loadFile();
        this._shellLinkImpl.getIconLocation(iconPath, new Int(260L), iconIndex);
        return iconPath.getValue();
    }

    public int getIconIndex() {
        Str iconPath = new Str(260);
        Int iconIndex = new Int();
        this.loadFile();
        this._shellLinkImpl.getIconLocation(iconPath, new Int(260L), iconIndex);
        return (int)iconIndex.getValue();
    }

    public void setArguments(String arguments) {
        this.loadFile();
        this._shellLinkImpl.setArguments(new Str(arguments));
        this.saveFile();
    }

    public String getArguments() {
        this.loadFile();
        Str res = this._shellLinkImpl.getArguments(new Int(260L));
        return res.getValue();
    }

    public String getWorkingDirectory() {
        this.loadFile();
        Str directory = this._shellLinkImpl.getWorkingDirectory(new Int(260L));
        return directory.getValue();
    }

    public void setWorkingDirectory(String value) {
        this.loadFile();
        this._shellLinkImpl.setWorkingDirectory(new Str(value));
        this.saveFile();
    }

    public static void createLink(File sourceFile, File linkFile, String comment) {
        try {
            ShellLink shellLink = new ShellLink(linkFile, sourceFile);
            shellLink.setDescription(comment);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public static String resolveLink(File linkFile) {
        ShellLink shellLink = new ShellLink(linkFile);
        File res = shellLink.getSourceFile();
        return res.getAbsolutePath();
    }

    public static void updateShellLink(File linkFile, String description, File iconFile, String arguments) {
        ShellLink shellLink = new ShellLink(linkFile);
        shellLink.setArguments(arguments);
        shellLink.setIconPath(iconFile, 0);
        shellLink.setDescription(description);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

