/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.service;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.StringArray;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastError;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.service.ScHandle;
import com.jniwrapper.win32.service.ServiceConfig;
import com.jniwrapper.win32.service.ServiceException;
import com.jniwrapper.win32.system.AdvApi32;
import com.jniwrapper.win32.system.LocalMemoryBlock;
import com.jniwrapper.win32.system.MemoryAllocationAttributes;

public class Service
extends ScHandle {
    public static final String ACCOUNT_LOCAL_SYSTEM = "LocalSystem";
    private static final int ONE_SECOND = 1000;
    private static final int TEN_SECONDS = 10000;
    private static final int DESCRIPTION_MAX_LENGTH = 2048;
    private static final int CONTROL_SERVICE_STOP = 1;
    private static final int CONTROL_SERVICE_PAUSE = 2;
    private static final int CONTROL_SERVICE_CONTINUE = 3;
    private static final int SERVICE_CONFIG_DESCRIPTION = 1;
    private static final FunctionName FUNCTION_START_SERVICE = new FunctionName("StartService");
    private static final String FUNCTION_DELETE_SERVICE = "DeleteService";
    private static final String FUNCTION_CONTROL_SERVICE = "ControlService";
    private static final FunctionName FUNCTION_CHANGE_SERVICE_CONFIG = new FunctionName("ChangeServiceConfig");
    private static final FunctionName FUNCTION_QUERY_SERVICE_CONFIG = new FunctionName("QueryServiceConfig");
    private static final FunctionName FUNCTION_QUERY_SERVICE_CONFIG2 = new FunctionName("QueryServiceConfig2");
    private static final String FUNCTION_QUERY_SERVICE_STATUS = "QueryServiceStatus";
    private static final String SERVICES_PATH = "SYSTEM\\CurrentControlSet\\Services\\";
    private String _name;
    private AccessRights _accessRights = new AccessRights(983551L);
    private String _displayName = "";
    private Type _serviceType = Type.WIN32_OWN_PROCESS;
    private boolean _isInteractive = false;
    private StartupType _startupType = StartupType.DEMAND_START;
    private ErrorControl _errorControl = ErrorControl.NORMAL;
    private String _binaryPath;
    private String _startAccount;
    private String _password;
    private String[] _dependencies;
    static /* synthetic */ Class class$com$jniwrapper$win32$service$Service$CurrentState;
    static /* synthetic */ Class class$com$jniwrapper$win32$service$Service$Type;
    static /* synthetic */ Class class$com$jniwrapper$win32$service$Service$StartupType;
    static /* synthetic */ Class class$com$jniwrapper$win32$service$Service$ErrorControl;

    protected Service(String name, AccessRights accessRights) {
        this._name = name;
        this._accessRights = accessRights;
        this.setOpened(true);
    }

    protected Service(String name) {
        this(name, new AccessRights(983551L));
    }

    public void setValue(long value) {
        super.setValue(value);
        if (value != 0L) {
            this.loadConfiguration();
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public Type getServiceType() {
        return this._serviceType;
    }

    public void setServiceType(Type serviceType) {
        this._serviceType = serviceType;
    }

    public boolean isInteractive() {
        return this._isInteractive;
    }

    public void setInteractive(boolean isInteractive) {
        this._isInteractive = isInteractive;
    }

    public ErrorControl getErrorControl() {
        return this._errorControl;
    }

    public void setErrorControl(ErrorControl errorControl) {
        this._errorControl = errorControl;
    }

    public StartupType getStartupType() {
        return this._startupType;
    }

    public void setStartupType(StartupType startupType) {
        this._startupType = startupType;
    }

    public String getBinaryPath() {
        return this._binaryPath;
    }

    public void setBinaryPath(String binaryPath) {
        this._binaryPath = binaryPath;
    }

    public AccessRights getAccessRights() {
        return this._accessRights;
    }

    public void setAccessRights(AccessRights accessRights) {
        this._accessRights = accessRights;
    }

    public String[] getDependencies() {
        return this._dependencies;
    }

    public void setDependencies(String[] dependencies) {
        this._dependencies = dependencies;
    }

    public String getStartAccount() {
        return this._startAccount != null ? this._startAccount : ACCOUNT_LOCAL_SYSTEM;
    }

    public void setStartAccount(String startAccount) {
        if (startAccount == null) {
            startAccount = ACCOUNT_LOCAL_SYSTEM;
        }
        this._startAccount = startAccount;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void start() {
        this.start(null);
    }

    public void start(String[] parameters) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_START_SERVICE.toString());
        Bool result = new Bool();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{this, parameters != null ? new UInt32((long)parameters.length) : new UInt32(0L), this.makeArgumentsArray(parameters)});
        this.checkResult(LastError.getMessage(errorCode), result);
    }

    public void stop() {
        this.controlService(1);
    }

    public void pause() {
        this.controlService(2);
    }

    public void resume() {
        this.controlService(3);
    }

    public Status getStatus() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_QUERY_SERVICE_STATUS.toString());
        Bool result = new Bool();
        Status status = new Status();
        long errorCode = function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)status));
        this.checkResult(LastError.getMessage(errorCode), result);
        return status;
    }

    public CurrentState getCurrentState() {
        Status status = this.getStatus();
        return status.getCurrentState();
    }

    private boolean queryServiceConfig(Handle lpServiceConfig, int bufferSize, UInt32 bytesNeeded) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_QUERY_SERVICE_CONFIG.toString());
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, lpServiceConfig, new UInt((long)bufferSize), new Pointer((Parameter)bytesNeeded)});
        return result.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration() {
        UInt32 bytesNeeded = new UInt32();
        this.queryServiceConfig(new Handle(), 0, bytesNeeded);
        int bufferSize = (int)bytesNeeded.getValue();
        LocalMemoryBlock lpBuffer = new LocalMemoryBlock(bufferSize, MemoryAllocationAttributes.LPTR);
        try {
            if (!this.queryServiceConfig(lpBuffer, bufferSize, bytesNeeded)) {
                throw new ServiceException("Can not query status.");
            }
            ServiceConfig serviceConfig = new ServiceConfig();
            Pointer pServiceConfig = new Pointer((Parameter)serviceConfig);
            lpBuffer.castTo(pServiceConfig);
            this._displayName = serviceConfig.getDisplayName();
            this._serviceType = Type.create(serviceConfig.getServiceType());
            this._isInteractive = Type.isInteractive(serviceConfig.getServiceType());
            this._startupType = StartupType.create(serviceConfig.getStartupType());
            this._errorControl = ErrorControl.create(serviceConfig.getErrorControl());
            this._binaryPath = serviceConfig.getBinaryPath();
            this._startAccount = serviceConfig.getServiceStartName();
            this._dependencies = serviceConfig.getDependencies();
            this._password = null;
        }
        finally {
            lpBuffer.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Function function;
        try {
            function = AdvApi32.getInstance().getFunction(FUNCTION_QUERY_SERVICE_CONFIG2.toString());
        }
        catch (NoSuchFunctionException e) {
            return "";
        }
        int charSize = PlatformContext.isUnicode() ? PlatformContext.getWideCharLength() : PlatformContext.getCharLength();
        int numBytes = 2048 * charSize;
        LocalMemoryBlock buffer = new LocalMemoryBlock(numBytes, MemoryAllocationAttributes.LPTR);
        try {
            Bool res = new Bool();
            long errorCode = function.invoke((Parameter)res, new Parameter[]{this, new UInt32(1L), buffer, new UInt32((long)numBytes), new Pointer((Parameter)new UInt32())});
            this.checkResult(LastError.getMessage(errorCode), res);
            Handle description = new Handle();
            Pointer pDescription = new Pointer((Parameter)description);
            buffer.castTo(pDescription);
            if (description.isNull()) {
                String string = "";
                return string;
            }
            Str result = new Str(2048);
            Pointer pResult = new Pointer((Parameter)result);
            description.castTo(pResult);
            String string = result.getValue();
            return string;
        }
        finally {
            buffer.free();
        }
    }

    public void saveConfiguration() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_CHANGE_SERVICE_CONFIG.toString());
        Bool result = new Bool();
        int serviceType = this._isInteractive ? this._serviceType.getValue() | 0x100 : this._serviceType.getValue();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{this, new UInt32((long)serviceType), new UInt32((long)this._startupType.getValue()), new UInt32((long)this._errorControl.getValue()), new Str(this._binaryPath), new Handle(), new Handle(), this._dependencies != null && this._dependencies.length > 0 ? new Pointer((Parameter)new StringArray(this._dependencies)) : new Handle(), this._startAccount != null ? new Str(this._startAccount) : new Handle(), this._password != null ? new Str(this._password) : new Handle(), this._displayName != null ? new Str(this._displayName) : new Str("")});
        this.checkResult(LastError.getMessage(errorCode), result);
    }

    public void delete() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_DELETE_SERVICE);
        Bool result = new Bool();
        long errorCode = function.invoke((Parameter)result, (Parameter)this);
        this.checkResult(LastError.getMessage(errorCode), result);
    }

    private Parameter makeArgumentsArray(String[] args) {
        if (args != null && args.length > 0) {
            int length = args.length;
            Parameter[] params = new Parameter[length];
            for (int i = 0; i < length; ++i) {
                Str str = new Str(args[i]);
                params[i] = new Pointer((Parameter)str);
            }
            PrimitiveArray result = new PrimitiveArray(params);
            return new Pointer((Parameter)result);
        }
        return new Handle();
    }

    private Status controlService(int dwControl) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_CONTROL_SERVICE);
        Bool result = new Bool();
        Status serviceStatus = new Status();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{this, new UInt32((long)dwControl), new Pointer((Parameter)serviceStatus)});
        this.checkResult(LastError.getMessage(errorCode), result);
        return serviceStatus;
    }

    private static boolean inState(CurrentState[] expectedStates, CurrentState currentState) {
        for (int i = 0; i < expectedStates.length; ++i) {
            CurrentState expectedState = expectedStates[i];
            if (!expectedState.equals((Object)currentState)) continue;
            return true;
        }
        return false;
    }

    public void waitState(CurrentState expectedState) throws InterruptedException {
        this.waitState(new CurrentState[]{expectedState}, null);
    }

    public void waitState(CurrentState expectedState, StatusListener listener) throws InterruptedException {
        this.waitState(new CurrentState[]{expectedState}, listener);
    }

    public void waitState(CurrentState[] expectedStates) throws InterruptedException {
        this.waitState(expectedStates, null);
    }

    public void waitState(CurrentState[] expectedStates, StatusListener listener) throws InterruptedException {
        Status status = this.getStatus();
        while (!Service.inState(expectedStates, status.getCurrentState())) {
            long waitTime;
            if (listener != null) {
                listener.statusChecked(status);
            }
            if ((waitTime = status.getWaitHint() / 10L) < 1000L) {
                waitTime = 1000L;
            }
            if (waitTime > 10000L) {
                waitTime = 10000L;
            }
            Thread.sleep(waitTime);
            status = this.getStatus();
        }
    }

    public RegistryKey createParametersKey() {
        String keyPath = SERVICES_PATH + this.getName();
        String keyName = "Parameters";
        RegistryKey registryKey = RegistryKey.LOCAL_MACHINE.openSubKey(keyPath);
        RegistryKey result = registryKey.createSubKey("Parameters", true);
        registryKey.close();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Status
    extends Structure {
        private UInt32 _serviceType = new UInt32();
        private UInt32 _currentState = new UInt32();
        private UInt32 _controlsAccepted = new UInt32();
        private UInt32 _win32ExitCode = new UInt32();
        private UInt32 _serviceSpecificExitCode = new UInt32();
        private UInt32 _checkPoint = new UInt32();
        private UInt32 _waitHint = new UInt32();

        public Status(Status that) {
            this._serviceType = (UInt32)that._serviceType.clone();
            this._currentState = (UInt32)that._currentState.clone();
            this._controlsAccepted = (UInt32)that._controlsAccepted.clone();
            this._win32ExitCode = (UInt32)that._win32ExitCode.clone();
            this._serviceSpecificExitCode = (UInt32)that._serviceSpecificExitCode.clone();
            this._checkPoint = (UInt32)that._checkPoint.clone();
            this._waitHint = (UInt32)that._waitHint.clone();
            this.init();
        }

        public Status() {
            this.init();
        }

        private void init() {
            this.init(new Parameter[]{this._serviceType, this._currentState, this._controlsAccepted, this._win32ExitCode, this._serviceSpecificExitCode, this._checkPoint, this._waitHint});
        }

        public Type getServiceType() {
            Type type = (Type)Enums.getItem((Class)(class$com$jniwrapper$win32$service$Service$Type == null ? (class$com$jniwrapper$win32$service$Service$Type = Service.class$("com.jniwrapper.win32.service.Service$Type")) : class$com$jniwrapper$win32$service$Service$Type), (int)((int)this._serviceType.getValue()));
            return type;
        }

        public void setServiceType(Type serviceType) {
            this._serviceType.setValue((long)serviceType.getValue());
        }

        public CurrentState getCurrentState() {
            return CurrentState.create((int)this._currentState.getValue());
        }

        public ControlsAccepted getControlsAccepted() {
            return new ControlsAccepted(this._controlsAccepted.getValue());
        }

        public long getWin32ExitCode() {
            return this._win32ExitCode.getValue();
        }

        public long getServiceSpecificExitCode() {
            return this._serviceSpecificExitCode.getValue();
        }

        public long getCheckPoint() {
            return this._checkPoint.getValue();
        }

        public long getWaitHint() {
            return this._waitHint.getValue();
        }

        public Object clone() {
            return new Status(this);
        }

        public static class ControlsAccepted
        extends FlagSet {
            private static final int SERVICE_ACCEPT_STOP = 1;
            private static final int SERVICE_ACCEPT_PAUSE_CONTINUE = 2;
            private static final int SERVICE_ACCEPT_SHUTDOWN = 4;
            private static final int SERVICE_ACCEPT_PARAMCHANGE = 8;
            private static final int SERVICE_ACCEPT_NETBINDCHANGE = 16;
            private static final int SERVICE_ACCEPT_HARDWAREPROFILECHANGE = 32;
            private static final int SERVICE_ACCEPT_POWEREVENT = 64;
            private static final int SERVICE_ACCEPT_SESSIONCHANGE = 128;

            public ControlsAccepted(long flags) {
                super(flags);
            }

            public ControlsAccepted() {
            }

            public boolean isAcceptStop() {
                return this.contains(1L);
            }

            public boolean isAcceptPauseContinue() {
                return this.contains(2L);
            }

            public boolean isAcceptShutdown() {
                return this.contains(4L);
            }

            public boolean isAcceptParamChange() {
                return this.contains(8L);
            }

            public boolean isAcceptNetBindChange() {
                return this.contains(16L);
            }

            public boolean isAcceptHardwareProfileChange() {
                return this.contains(32L);
            }

            public boolean isAcceptPowerEvent() {
                return this.contains(64L);
            }

            public boolean isAcceptSessionChange() {
                return this.contains(128L);
            }

            public void setAcceptStop(boolean isAccept) {
                this.setupFlag(1L, isAccept);
            }

            public void setAcceptPauseContinue(boolean isAccept) {
                this.setupFlag(2L, isAccept);
            }

            public void setAcceptShutdown(boolean isAccept) {
                this.setupFlag(4L, isAccept);
            }

            public void setAcceptParamChange(boolean isAccept) {
                this.setupFlag(8L, isAccept);
            }

            public void setAcceptNetBindChange(boolean isAccept) {
                this.setupFlag(16L, isAccept);
            }

            public void setAcceptHardwareProfileChange(boolean isAccept) {
                this.setupFlag(32L, isAccept);
            }

            public void setAcceptPowerEvent(boolean isAccept) {
                this.setupFlag(64L, isAccept);
            }

            public void setAcceptSessionChange(boolean isAccept) {
                this.setupFlag(128L, isAccept);
            }
        }
    }

    public static class ErrorControl
    extends ServiceEnumItem {
        public static final ErrorControl IGNORE = new ErrorControl(0, "Ignore");
        public static final ErrorControl NORMAL = new ErrorControl(1, "Normal");
        public static final ErrorControl SEVERE = new ErrorControl(2, "Severe");
        public static final ErrorControl CRITICAL = new ErrorControl(3, "Critical");

        private ErrorControl(int value, String stringValue) {
            super(value, stringValue);
        }

        public static ErrorControl create(int type) {
            return (ErrorControl)Enums.getItem((Class)(class$com$jniwrapper$win32$service$Service$ErrorControl == null ? (class$com$jniwrapper$win32$service$Service$ErrorControl = Service.class$("com.jniwrapper.win32.service.Service$ErrorControl")) : class$com$jniwrapper$win32$service$Service$ErrorControl), (int)type);
        }
    }

    public static class StartupType
    extends ServiceEnumItem {
        public static final StartupType BOOT_START = new StartupType(0, "Boot start");
        public static final StartupType SYSTEM_START = new StartupType(1, "System start");
        public static final StartupType AUTO_START = new StartupType(2, "Automatic");
        public static final StartupType DEMAND_START = new StartupType(3, "Manual");
        public static final StartupType DISABLED = new StartupType(4, "Disabled");

        public StartupType(int value, String stringValue) {
            super(value, stringValue);
        }

        public static StartupType create(int type) {
            return (StartupType)Enums.getItem((Class)(class$com$jniwrapper$win32$service$Service$StartupType == null ? (class$com$jniwrapper$win32$service$Service$StartupType = Service.class$("com.jniwrapper.win32.service.Service$StartupType")) : class$com$jniwrapper$win32$service$Service$StartupType), (int)type);
        }
    }

    public static class Type
    extends ServiceEnumItem {
        public static final Type KERNEL_DRIVER = new Type(1, "Kernel driver");
        public static final Type FILE_SYSTEM_DRIVER = new Type(2, "File system driver");
        public static final Type WIN32_OWN_PROCESS = new Type(16, "Win32 own process");
        public static final Type WIN32_SHARE_PROCESS = new Type(32, "Win32 share process");
        private static final int INTERACTIVE_PROCESS = 256;
        public static final Type WIN32 = new Type(WIN32_OWN_PROCESS.getValue() | WIN32_SHARE_PROCESS.getValue(), "Win32 process");

        private Type(int value, String stringValue) {
            super(value, stringValue);
        }

        public static Type create(int type) {
            FlagSet flagSet = new FlagSet((long)type);
            flagSet.remove(256L);
            type = (int)flagSet.getFlags();
            return (Type)Enums.getItem((Class)(class$com$jniwrapper$win32$service$Service$Type == null ? (class$com$jniwrapper$win32$service$Service$Type = Service.class$("com.jniwrapper.win32.service.Service$Type")) : class$com$jniwrapper$win32$service$Service$Type), (int)type);
        }

        public static boolean isInteractive(int type) {
            return (type & 0x100) != 0;
        }
    }

    public static class AccessRights
    extends FlagSet {
        private static final int QUERY_CONFIG = 1;
        private static final int CHANGE_CONFIG = 2;
        private static final int QUERY_STATUS = 4;
        private static final int ENUMERATE_DEPENDENTS = 8;
        private static final int START = 16;
        private static final int STOP = 32;
        private static final int PAUSE_CONTINUE = 64;
        private static final int INTERROGATE = 128;
        private static final int USER_DEFINED_CONTROL = 256;
        private static final int ALL = 983551;

        public AccessRights() {
        }

        public AccessRights(long flags) {
            super(flags);
        }

        public void setQueryConfig(boolean queryConfig) {
            this.setupFlag(1L, queryConfig);
        }

        public boolean isQueryConfig() {
            return this.contains(1L);
        }

        public void setChangeConfig(boolean changeConfig) {
            this.setupFlag(2L, changeConfig);
        }

        public boolean isChangeConfig() {
            return this.contains(2L);
        }

        public void setQueryStatus(boolean queryStatus) {
            this.setupFlag(4L, queryStatus);
        }

        public boolean isQueryStatus() {
            return this.contains(4L);
        }

        public void setEnumerateDependents(boolean enumerateDependents) {
            this.setupFlag(8L, enumerateDependents);
        }

        public boolean isEnumerateDependents() {
            return this.contains(8L);
        }

        public void setStart(boolean start) {
            this.setupFlag(16L, start);
        }

        public boolean isStart() {
            return this.contains(16L);
        }

        public void setStop(boolean stop) {
            this.setupFlag(32L, stop);
        }

        public boolean isStop() {
            return this.contains(32L);
        }

        public void setPauseContinue(boolean pauseContinue) {
            this.setupFlag(64L, pauseContinue);
        }

        public boolean isPauseContinue() {
            return this.contains(64L);
        }

        public void setInterrogate(boolean interrogate) {
            this.setupFlag(128L, interrogate);
        }

        public boolean isInterrogate() {
            return this.contains(128L);
        }

        public void setUserDefinedControl(boolean userDefinedControl) {
            this.setupFlag(256L, userDefinedControl);
        }

        public boolean isUserDefinedControl() {
            return this.contains(256L);
        }

        public void setAll(boolean all) {
            this.setupFlag(983551L, all);
        }

        public boolean isAll() {
            return this.contains(983551L);
        }
    }

    public static class CurrentState
    extends ServiceEnumItem {
        public static final CurrentState STOPPED = new CurrentState(1, "Stopped");
        public static final CurrentState START_PENDING = new CurrentState(2, "Starting...");
        public static final CurrentState STOP_PENDING = new CurrentState(3, "Stopping...");
        public static final CurrentState RUNNING = new CurrentState(4, "Running");
        public static final CurrentState CONTINUE_PENDING = new CurrentState(5, "Resuming...");
        public static final CurrentState PAUSE_PENDING = new CurrentState(6, "Pausing...");
        public static final CurrentState PAUSED = new CurrentState(7, "Paused");

        private CurrentState(int value, String stringValue) {
            super(value, stringValue);
        }

        static CurrentState create(int type) {
            return (CurrentState)Enums.getItem((Class)(class$com$jniwrapper$win32$service$Service$CurrentState == null ? (class$com$jniwrapper$win32$service$Service$CurrentState = Service.class$("com.jniwrapper.win32.service.Service$CurrentState")) : class$com$jniwrapper$win32$service$Service$CurrentState), (int)type);
        }
    }

    private static class ServiceEnumItem
    extends EnumItem {
        private String _stringValue;

        ServiceEnumItem(int value, String stringValue) {
            super(value);
            this._stringValue = stringValue;
        }

        public String toString() {
            return this._stringValue;
        }
    }

    public static interface StatusListener {
        public void statusChecked(Status var1);
    }
}

