/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryValueTransformer;
import com.jniwrapper.win32.registry.WinRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegistryKeyValues
implements Map {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$registry$RegistryKeyValues == null ? (class$com$jniwrapper$win32$registry$RegistryKeyValues = RegistryKeyValues.class$("com.jniwrapper.win32.registry.RegistryKeyValues")) : class$com$jniwrapper$win32$registry$RegistryKeyValues));
    private RegistryKey _registryKey;
    private static final Map TYPE_ASSOCIATIONS = new HashMap();
    private static final List BACK_TYPE_ASSOCIATIONS = new ArrayList();
    static /* synthetic */ Class class$com$jniwrapper$win32$registry$RegistryKeyValues;
    static /* synthetic */ Class class$com$jniwrapper$win32$registry$RegistryKeyType;

    public static void registerAssociation(RegistryKeyType type, RegistryValueTransformer transformer) {
        TYPE_ASSOCIATIONS.put(type, transformer);
        BACK_TYPE_ASSOCIATIONS.add(new Pair(transformer, (Object)type));
    }

    public RegistryKeyValues(RegistryKey registryKey) {
        this._registryKey = registryKey;
    }

    private Map loadWholeMap() {
        HashMap<String, RegistryValueEntry> entries = new HashMap<String, RegistryValueEntry>();
        int i = 0;
        int errorCode = 0;
        while (errorCode == 0) {
            Str valueName = new Str("", 260);
            UInt32 type = new UInt32();
            UInt32 size = new UInt32();
            errorCode = (int)WinRegistry.enumValue(this._registryKey, i, valueName, new UInt32(260L), type, null, size);
            if (errorCode == 0) {
                RegistryKeyType registryKeyType = (RegistryKeyType)Enums.getItem((Class)(class$com$jniwrapper$win32$registry$RegistryKeyType == null ? RegistryKeyValues.class$("com.jniwrapper.win32.registry.RegistryKeyType") : class$com$jniwrapper$win32$registry$RegistryKeyType), (int)((int)type.getValue()));
                String valName = valueName.getValue();
                RegistryValueEntry registryValueEntry = new RegistryValueEntry(valName, registryKeyType, (int)size.getValue());
                entries.put(valName, registryValueEntry);
            }
            ++i;
        }
        return entries;
    }

    public int size() {
        UInt32 valueCount = new UInt32();
        try {
            this._registryKey.checkError(WinRegistry.queryInfoKey(this._registryKey, null, null, null, null, null, valueCount, null, null));
        }
        catch (Exception e) {
            return 0;
        }
        return (int)valueCount.getValue();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        String keyName = (String)key;
        long res = WinRegistry.getValueInfo(this._registryKey, keyName, new Int32(0), new Int32(0));
        return res != 2L;
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Object get(Object key) {
        String keyName = (String)key;
        try {
            Int32 type = new Int32(0);
            Int32 size = new Int32(0);
            this._registryKey.checkError(WinRegistry.getValueInfo(this._registryKey, keyName, type, size));
            int typeId = (int)type.getValue();
            RegistryKeyType keyType = new RegistryKeyType(typeId);
            RegistryValueTransformer valueTransformer = RegistryKeyValues.getValueTransformer(keyType);
            Parameter valueParameter = valueTransformer.createRegistryValueParameter((int)size.getValue());
            this._registryKey.checkError(WinRegistry.getValue(this._registryKey, keyName, typeId, valueParameter));
            return valueTransformer.fromRegistryValue(valueParameter);
        }
        catch (RegistryException ex) {
            return null;
        }
    }

    public RegistryKeyType getType(Object key) {
        String keyName = (String)key;
        Int32 type = new Int32(0);
        Int32 size = new Int32(0);
        this._registryKey.checkError(WinRegistry.getValueInfo(this._registryKey, keyName, type, size));
        int typeId = (int)type.getValue();
        return new RegistryKeyType(typeId);
    }

    public Object put(Object key, Object value) {
        return this.putImpl(key, value, null);
    }

    public Object put(Object key, Object value, RegistryKeyType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("valueType can not be Null");
        }
        return this.putImpl(key, value, valueType);
    }

    private Object putImpl(Object key, Object value, RegistryKeyType valueType) {
        Object prevValue = this.get(key);
        String keyName = (String)key;
        if (valueType == null) {
            valueType = RegistryKeyValues.getValueType(value);
        }
        RegistryValueTransformer transformer = RegistryKeyValues.getValueTransformer(valueType);
        Parameter result = transformer.toRegistryValue(value);
        this._registryKey.checkError(WinRegistry.setValue(this._registryKey, keyName, valueType.getValue(), result, result.getLength()));
        return prevValue;
    }

    public Object remove(Object key) {
        Object prevValue = this.get(key);
        WinRegistry.deleteValue(this._registryKey, key.toString());
        return prevValue;
    }

    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this._registryKey.checkError(WinRegistry.deleteValue(this._registryKey, name));
        }
    }

    public Set keySet() {
        Map cached = this.loadWholeMap();
        return cached.keySet();
    }

    public Collection values() {
        Map cached = this.loadWholeMap();
        int size = this.size();
        ArrayList result = new ArrayList(size);
        Iterator i = cached.values().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Object value = entry.getValue();
            result.add(value);
        }
        return result;
    }

    public Set entrySet() {
        Map cached = this.loadWholeMap();
        return cached.entrySet();
    }

    public List getEntries() {
        Map cached = this.loadWholeMap();
        return Collections.list(Collections.enumeration(cached.values()));
    }

    private static RegistryValueTransformer getValueTransformer(RegistryKeyType type) {
        RegistryValueTransformer res = (RegistryValueTransformer)TYPE_ASSOCIATIONS.get((Object)type);
        if (res == null) {
            throw new IllegalArgumentException("Unable to get value transformer for given value type: " + (Object)((Object)type));
        }
        return res;
    }

    private static RegistryKeyType getValueType(Object value) {
        RegistryKeyType result = RegistryKeyType.NONE;
        Iterator i = BACK_TYPE_ASSOCIATIONS.iterator();
        while (i.hasNext()) {
            Pair pair = (Pair)i.next();
            RegistryValueTransformer transformer = (RegistryValueTransformer)pair.getKey();
            if (!transformer.isTypeSupported(value)) continue;
            result = (RegistryKeyType)((Object)pair.getValue());
            break;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RegistryKeyValues.registerAssociation(RegistryKeyType.DWORD, RegistryValueTransformer.INTEGER_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.SZ, RegistryValueTransformer.STRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.BINARY, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.EXPAND_SZ, RegistryValueTransformer.STRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.QWORD, RegistryValueTransformer.QWORD_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.RESOURCE_LIST, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.FULL_RESOURCE_DESCRIPTOR, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.RESOURCE_REQUIREMENTS_LIST, RegistryValueTransformer.BINARY_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.MULTI_SZ, RegistryValueTransformer.MULTISTRING_TRANSFORMER);
        RegistryKeyValues.registerAssociation(RegistryKeyType.NONE, RegistryValueTransformer.BINARY_TRANSFORMER);
    }

    private static final class Pair {
        private Object key;
        private Object value;

        public Pair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public class RegistryValueEntry
    implements Map.Entry {
        private String _name;
        private RegistryKeyType _type = RegistryKeyType.NONE;
        private int _size;
        private Object _value;

        public RegistryValueEntry(String name, RegistryKeyType type, int size) {
            this._name = name;
            this._type = type;
            this._size = size;
        }

        public RegistryValueEntry(String name) {
            this._name = name;
        }

        public Object getKey() {
            return this._name;
        }

        public Object getValue() {
            if (this._value == null && !RegistryKeyValues.this._registryKey.isNull()) {
                RegistryKeyType type = this.getType();
                RegistryValueTransformer transformer = RegistryKeyValues.getValueTransformer(type);
                this._value = transformer.createRegistryValueParameter(this._size);
                RegistryKeyValues.this._registryKey.checkError(WinRegistry.getValue(RegistryKeyValues.this._registryKey, this._name, type.getValue(), (Parameter)this._value));
                this._value = transformer.fromRegistryValue((Parameter)this._value);
            }
            return this._value;
        }

        public Object setValue(Object value) {
            RegistryKeyType type = this.getType();
            RegistryValueTransformer transformer = RegistryKeyValues.getValueTransformer(type);
            Parameter result = transformer.toRegistryValue(value);
            RegistryKeyValues.this._registryKey.checkError(WinRegistry.setValue(RegistryKeyValues.this._registryKey, this._name, type.getValue(), result, result.getLength()));
            this._value = value;
            return result;
        }

        public RegistryKeyType getType() {
            return this._type;
        }

        public void setType(RegistryKeyType type) {
            this._type = type;
        }

        public int getSize() {
            return this._size;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("RegistryValueEntry [Name=");
            result.append(this._name).append(";type=").append((Object)this._type).append(']');
            return result.toString();
        }
    }
}

