/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.PolyFillMode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Region
extends GdiObject {
    static final String FUNCTION_CREATE_ELLIPTIC_RGN = "CreateEllipticRgn";
    static final String FUNCTION_CREATE_ELLIPTIC_RGN_INDIRECT = "CreateEllipticRgnIndirect";
    static final String FUNCTION_COMBINE_RGN = "CombineRgn";
    static final String FUNCTION_CREATE_POLYGON_RGN = "CreatePolygonRgn";
    static final String FUNCTION_CREATE_POLY_POLYGON_RGN = "CreatePolyPolygonRgn";
    static final String FUNCTION_CREATE_RECT_RGN = "CreateRectRgn";
    static final String FUNCTION_CREATE_RECT_RGN_INDIRECT = "CreateRectRgnIndirect";
    static final String FUNCTION_CREATE_ROUND_RECT_RGN = "CreateRoundRectRgn";
    static final String FUNCTION_EQUAL_RGN = "EqualRgn";
    static final String FUNCTION_GET_REGION_DATA = "GetRegionData";
    static final String FUNCTION_GET_RGN_BOX = "GetRgnBox";
    static final String FUNCTION_OFFSET_RGN = "OffsetRgn";
    static final String FUNCTION_POINT_IN_REGION = "PtInRegion";
    static final String FUNCTION_RECT_IN_REGION = "RectInRegion";
    static final String FUNCTION_SET_RECT_RGN = "SetRectRgn";
    public static final int RGN_ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    static /* synthetic */ Class class$com$jniwrapper$win32$Point;
    static /* synthetic */ Class class$com$jniwrapper$Int;

    public Region() {
    }

    public Region(long value) {
        super(value);
    }

    public static Region createElliptic(int left, int top, int right, int bottom) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ELLIPTIC_RGN);
        Region result = new Region();
        function.invoke((Parameter)result, (Parameter)new Int((long)left), (Parameter)new Int((long)top), (Parameter)new Int((long)right), (Parameter)new Int((long)bottom));
        return result;
    }

    public static Region createElliptic(Rect rect) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ELLIPTIC_RGN_INDIRECT);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)rect));
        return null;
    }

    public static Region createRoundRectRegion(int left, int top, int right, int bottom, int ellipseWidth, int ellipseHight) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_ROUND_RECT_RGN);
        function.invoke((Parameter)result, new Parameter[]{new Int((long)left), new Int((long)top), new Int((long)right), new Int((long)bottom), new Int((long)ellipseWidth), new Int((long)ellipseHight)});
        return result;
    }

    public static Region combineRgn(Region srcRgn1, Region srcRgn2, CombineMode combineMode) {
        Region result = Region.createRectRegion(0, 0, 0, 0);
        Int resultRgnType = new Int();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_COMBINE_RGN);
        long errorCode = function.invoke((Parameter)resultRgnType, (Parameter)result, (Parameter)srcRgn1, (Parameter)srcRgn2, (Parameter)new Int((long)combineMode.getValue()));
        long value = resultRgnType.getValue();
        if (0L == value) {
            throw new LastErrorException(errorCode, "Failed to combine regions.");
        }
        return result;
    }

    public static Region createPolygonRgn(Point[] points, int nPoints, PolyFillMode polyFillMode) {
        PrimitiveArray pointsArray = new PrimitiveArray(class$com$jniwrapper$win32$Point == null ? (class$com$jniwrapper$win32$Point = Region.class$("com.jniwrapper.win32.Point")) : class$com$jniwrapper$win32$Point, nPoints);
        for (int i = 0; i < nPoints; ++i) {
            pointsArray.setElement(i, (Parameter)points[i]);
        }
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_POLYGON_RGN);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)pointsArray), (Parameter)new Int((long)nPoints), (Parameter)new Int((long)polyFillMode.getValue()));
        return result;
    }

    public static Region createPolyPolygonRgn(Point[] points, int[] polyCounts, int count, PolyFillMode polyFillMode) {
        Region result = new Region();
        int length = points.length;
        PrimitiveArray pointsArray = new PrimitiveArray(class$com$jniwrapper$win32$Point == null ? (class$com$jniwrapper$win32$Point = Region.class$("com.jniwrapper.win32.Point")) : class$com$jniwrapper$win32$Point, length);
        for (int i = 0; i < length; ++i) {
            pointsArray.setElement(i, (Parameter)points[i]);
        }
        PrimitiveArray polyCountsArray = new PrimitiveArray(class$com$jniwrapper$Int == null ? (class$com$jniwrapper$Int = Region.class$("com.jniwrapper.Int")) : class$com$jniwrapper$Int, count);
        for (int i = 0; i < length; ++i) {
            polyCountsArray.setElement(i, (Parameter)new Int((long)polyCounts[i]));
        }
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_POLY_POLYGON_RGN);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)pointsArray), (Parameter)new Pointer((Parameter)polyCountsArray), (Parameter)new Int((long)count), (Parameter)new Int((long)polyFillMode.getValue()));
        return result;
    }

    public static Region createRectRegion(int left, int top, int right, int bottom) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN);
        function.invoke((Parameter)result, new Parameter[]{new Int((long)left), new Int((long)top), new Int((long)right), new Int((long)bottom)});
        return result;
    }

    public static Region createRectRegion(Rect rect) {
        Region result = new Region();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN_INDIRECT);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)rect));
        return result;
    }

    public boolean equalRegion(Region region) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_CREATE_RECT_RGN);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)region);
        return result.getValue();
    }

    public int getRagionData(PrimitiveArray rgnData, int count) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_REGION_DATA);
        UInt32 returnValue = new UInt32();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new UInt32((long)count), (Parameter)new Pointer((Parameter)rgnData));
        return (int)returnValue.getValue();
    }

    public Rect getRegionBox() {
        Rect result = new Rect();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_RGN_BOX);
        Int returnResult = new Int();
        function.invoke((Parameter)returnResult, (Parameter)this, (Parameter)new Pointer((Parameter)result));
        return result;
    }

    public void offsetRegion(int xOffset, int yOffset) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_OFFSET_RGN);
        function.invoke(null, (Parameter)this, (Parameter)new Int((long)xOffset), (Parameter)new Int((long)yOffset));
    }

    public boolean isPointInRegion(int x, int y) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_POINT_IN_REGION);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Int((long)x), (Parameter)new Int((long)y));
        return result.getValue();
    }

    public boolean isPointInRegion(Point point) {
        return this.isPointInRegion((int)point.getY(), (int)point.getY());
    }

    public boolean isRectInRegion(Rect rect) {
        Bool result = new Bool();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_RECT_IN_REGION);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new Pointer((Parameter)rect));
        return result.getValue();
    }

    public void setRectRegion(int left, int top, int right, int bottom) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_SET_RECT_RGN);
        function.invoke(null, new Parameter[]{this, new Int((long)left), new Int((long)top), new Int((long)right), new Int((long)bottom)});
    }

    public static Region createFromImage(Image image, Color transparent) {
        return Region.createFromImage(image, transparent, null);
    }

    public static Region createFromImage(Image image, Color transparent, Color tolerance) {
        if (image == null || transparent == null) {
            throw new IllegalArgumentException();
        }
        if (tolerance == null) {
            tolerance = new Color(0x101010);
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, transparent, null);
        graphics2D.dispose();
        Region result = Region.createRectRegion(new Rect());
        int transparentRedValue = transparent.getRed();
        int transparentGreenValue = transparent.getGreen();
        int transparentBlueValue = transparent.getBlue();
        int toleranceRedValue = Math.min(transparentRedValue + tolerance.getRed(), 255);
        int toleranceGreenValue = Math.min(transparentGreenValue + tolerance.getGreen(), 255);
        int toleranceBlueValue = Math.min(transparentBlueValue + tolerance.getBlue(), 255);
        for (int x = 0; x < width; ++x) {
            boolean continuous = false;
            int yBegin = 0;
            for (int y = 0; y < height; ++y) {
                int greenValue;
                int rgb = bufferedImage.getRGB(x, y);
                int redValue = (rgb & 0xFF0000) >> 16;
                boolean isTransparent = false;
                if (redValue >= transparentRedValue && redValue <= toleranceRedValue && (greenValue = (rgb & 0xFF00) >> 8) >= transparentGreenValue && greenValue <= toleranceGreenValue) {
                    int blueVale = rgb & 0xFF;
                    boolean bl = isTransparent = blueVale >= transparentBlueValue && blueVale <= toleranceBlueValue;
                }
                if (isTransparent) {
                    if (!continuous) continue;
                    continuous = false;
                    Region rectRegion = Region.createRectRegion(x, yBegin, x + 1, y - 1);
                    Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
                    result.deleteObject();
                    result = newResult;
                    rectRegion.deleteObject();
                    continue;
                }
                if (continuous) continue;
                continuous = true;
                yBegin = y;
            }
            if (!continuous) continue;
            Region rectRegion = Region.createRectRegion(x, yBegin, x + 1, height);
            Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
            result.deleteObject();
            result = newResult;
            rectRegion.deleteObject();
        }
        return result;
    }

    public static Region createFromImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        Region result = Region.createRectRegion(new Rect());
        for (int x = 0; x < width; ++x) {
            boolean continuous = false;
            int yBegin = 0;
            for (int y = 0; y < height; ++y) {
                boolean isTransparent;
                int argb = bufferedImage.getRGB(x, y);
                boolean bl = isTransparent = (argb & 0xFF000000) >> 24 == 0;
                if (isTransparent) {
                    if (!continuous) continue;
                    continuous = false;
                    Region rectRegion = Region.createRectRegion(x, yBegin, x + 1, y - 1);
                    Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
                    result.deleteObject();
                    result = newResult;
                    rectRegion.deleteObject();
                    continue;
                }
                if (continuous) continue;
                continuous = true;
                yBegin = y;
            }
            if (!continuous) continue;
            Region rectRegion = Region.createRectRegion(x, yBegin, x + 1, height);
            Region newResult = Region.combineRgn(result, rectRegion, CombineMode.OR);
            result.deleteObject();
            result = newResult;
            rectRegion.deleteObject();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CombineMode
    extends EnumItem {
        public static final CombineMode AND = new CombineMode(1);
        public static final CombineMode OR = new CombineMode(2);
        public static final CombineMode XOR = new CombineMode(3);
        public static final CombineMode DIFF = new CombineMode(4);
        public static final CombineMode COPY = new CombineMode(5);
        public static final CombineMode MIN = AND;
        public static final CombineMode MAX = COPY;

        private CombineMode(int value) {
            super(value);
        }
    }
}

