/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public abstract class WizardScreen
extends JPanel {
    private static final Dimension NAVIGATION_VERTICAL_GAP = new Dimension(0, 5);
    private static final Color MACOS_SEPARATOR_COLOR;
    public static final int CHECKBOX_WIDTH;
    public static final int RADIOBUTTON_WIDTH;
    private static int nameCount;
    private WizardBase wizardBase;

    protected WizardScreen(WizardBase wizardBase) {
        this.wizardBase = wizardBase;
        this.setName(String.valueOf(nameCount++));
    }

    protected WizardBase getWizardBase() {
        return this.wizardBase;
    }

    protected void activate() {
        this.wizardBase.activateScreen(this);
        this.requestFocus();
    }

    protected void deactivate() {
    }

    protected JPanel createNavigationPanel(Box buttonBox, boolean needsSeparator) {
        JPanel panel = new JPanel(new BorderLayout());
        Box navigationBox = new Box(3);
        if (needsSeparator) {
            navigationBox.add(this.createSeparator(true));
            navigationBox.add(Box.createVerticalStrut(WizardScreen.NAVIGATION_VERTICAL_GAP.height));
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        buttonPanel.add((Component)buttonBox, "Center");
        navigationBox.add(buttonPanel);
        navigationBox.add(Box.createRigidArea(NAVIGATION_VERTICAL_GAP));
        panel.add((Component)navigationBox, "Last");
        return panel;
    }

    protected JComponent createSeparator(boolean watermark) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = -1;
        String watermarkText = this.getWatermarkText();
        if (watermark && watermarkText != null) {
            gc.insets.left = 5;
            gc.insets.right = 2;
            JLabel label = new JLabel(watermarkText);
            label.setEnabled(false);
            panel.add((Component)label, gc);
            gc.insets.left = 0;
            gc.insets.right = 0;
        }
        gc.weightx = 1.0;
        gc.fill = 2;
        if (Util.isMacOS()) {
            JPanel separatorPanel = new JPanel();
            Dimension size = new Dimension(10, 1);
            separatorPanel.setMinimumSize(size);
            separatorPanel.setPreferredSize(size);
            separatorPanel.setOpaque(true);
            if (MACOS_SEPARATOR_COLOR != null) {
                separatorPanel.setBackground(MACOS_SEPARATOR_COLOR);
            }
            panel.add((Component)separatorPanel, gc);
        } else {
            JSeparator separator = new JSeparator();
            separator.setOpaque(false);
            separator.setMinimumSize(separator.getPreferredSize());
            panel.add((Component)separator, gc);
        }
        return panel;
    }

    protected String getWatermarkText() {
        return null;
    }

    protected Window getParentWindow() {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
    }

    protected boolean supportsPrevious() {
        return true;
    }

    protected boolean supportsNext() {
        return true;
    }

    static {
        if (!InstallerUtil.isConsole() && !InstallerUtil.isUnattended()) {
            CHECKBOX_WIDTH = new JCheckBox().getPreferredSize().width;
            RADIOBUTTON_WIDTH = new JRadioButton().getPreferredSize().width;
            MACOS_SEPARATOR_COLOR = new Color(212, 212, 212);
        } else {
            CHECKBOX_WIDTH = 10;
            RADIOBUTTON_WIDTH = 10;
            MACOS_SEPARATOR_COLOR = null;
        }
        nameCount = 0;
    }
}

