/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VolumeInfo {
    private static Map<String, String> mountPointToDiskFile;
    private static final String DOWNLOAD_SUFFIX = ".download";

    public static Map<String, String> getNewMountPointToDiskFile() {
        mountPointToDiskFile = null;
        return VolumeInfo.getMountPointToDiskFile();
    }

    public static Map<String, String> getMountPointToDiskFile() {
        if (mountPointToDiskFile == null) {
            mountPointToDiskFile = new HashMap<String, String>();
            StringBuffer output = new StringBuffer();
            try {
                int returnCode = Execution.executeWithReturnCode(new String[]{"hdiutil", "info", "-plist"}, output, true);
                if (returnCode != 0) {
                    return mountPointToDiskFile;
                }
                Document document = XmlHelper.parseString(output.toString(), false, false);
                Element element = document.getDocumentElement();
                element = PlistHelper.getFirstChild(PlistHelper.getFirstChild(element, "dict"), "array");
                block6: for (Element diskImageElement : XmlHelper.childElements(element)) {
                    try {
                        String imagePath = XmlHelper.getTextValue(PlistHelper.findValue(diskImageElement, "image-path"));
                        Element systemEntities = PlistHelper.findValue(diskImageElement, "system-entities");
                        for (Element dictElement : XmlHelper.childElements(systemEntities)) {
                            try {
                                String mountPoint = XmlHelper.getTextValue(PlistHelper.findValue(dictElement, "mount-point"));
                                String path = VolumeInfo.removeDownloadDir(imagePath);
                                mountPointToDiskFile.put(mountPoint, path);
                                Logger.getInstance().info(VolumeInfo.class, "image: " + path + ", mountPoint: " + mountPoint);
                                continue block6;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance().info(VolumeInfo.class, "Could not get volume info: " + e);
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance().error(VolumeInfo.class, "Could not get volume info: " + e);
            }
        }
        return mountPointToDiskFile;
    }

    private static String removeDownloadDir(String imagePath) {
        File parentFile = new File(imagePath).getParentFile();
        if (parentFile.getName().endsWith(DOWNLOAD_SUFFIX)) {
            String path = parentFile.getAbsolutePath();
            return path.substring(0, path.length() - DOWNLOAD_SUFFIX.length());
        }
        return imagePath;
    }
}

