/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.beans.ErrorHandlingCallback;
import com.install4j.api.beans.ErrorHandlingMode;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class HttpRequestHandler {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    public static final String SYSPROP_SHOW_CONNECT_ERROR = "install4j.showConnectError";
    private static final String SYSPROP_SHOW_PROXY_CONFIG = "install4j.showProxyConfig";
    private static final String SYSPROP_NO_PROXY_AUTO_DETECT = "install4j.noProxyAutoDetect";
    private static final String SYSPROP_NO_PROXY = "install4j.noProxy";
    private static final String SYSPROP_CONNECT_TIMEOUT = "install4j.connectTimeout";
    private static final String SYSPROP_INSTALL4J_READ_TIMEOUT = "install4j.readTimeout";
    private static ProxyConfig proxyConfig = new ProxyConfig();
    private Context context;
    private boolean askForProxy = false;
    private ErrorHandlingCallback errorHandlingCallback;
    private boolean showProxyOnErrorCode = false;
    private boolean acceptAllCertificates = false;
    private URLConnection connection;
    private int mode;
    private ProxyHostInfo proxyHostInfo;
    private Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private boolean readResponse = true;
    private volatile boolean canceled;

    public static ProxyConfig getProxyConfig() {
        return proxyConfig;
    }

    protected HttpRequestHandler(Context context) {
        this(context, context.isUnattended() ? 3 : (context.isConsole() ? 2 : 1));
    }

    protected HttpRequestHandler(Context context, int mode) {
        this.context = context;
        this.mode = mode;
    }

    public void cancel() {
        this.canceled = true;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public void setAskForProxy(boolean askForProxy) {
        this.askForProxy = askForProxy;
    }

    public void setShowProxyOnErrorCode(boolean showProxyOnErrorCode) {
        this.showProxyOnErrorCode = showProxyOnErrorCode;
    }

    public void setErrorHandlingCallback(ErrorHandlingCallback errorHandlingCallback) {
        this.errorHandlingCallback = errorHandlingCallback;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this.acceptAllCertificates = acceptAllCertificates;
    }

    public void setReadResponse(boolean readResponse) {
        this.readResponse = readResponse;
    }

    protected boolean isReadResponse() {
        return this.readResponse;
    }

    protected Context getContext() {
        return this.context;
    }

    public HttpRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return this.connect(urlString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestHandler connect(String urlString, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        URL url = new URL(urlString);
        Runnable resetter = this.maybeAcceptAllCertificates(url);
        try {
            this.connection = this.getURLConnection(url, connectionPreparer, this.showProxyOnErrorCode);
        }
        finally {
            if (resetter != null) {
                resetter.run();
            }
        }
        this.connectionInitialized(this.connection);
        if (this.isReadResponse()) {
            try {
                this.connection.getInputStream();
            }
            catch (IOException e) {
                String message;
                String string = message = this.proxyHostInfo == null ? "No auto-detected proxy was used" : "Auto-detected proxy was " + this.proxyHostInfo;
                if (this.context != null) {
                    ContextInt contextInt = ContextImpl.getContextInt(this.context);
                    if (contextInt != null) {
                        Logger.getInstance().info(contextInt.getEventSource(), message);
                    }
                } else if (Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR)) {
                    System.err.println(message);
                    System.err.println("proxySet = " + System.getProperty("proxySet"));
                    System.err.println("proxyHost = " + System.getProperty("proxyHost"));
                    System.err.println("proxyPort = " + System.getProperty("proxyPort"));
                }
                throw e;
            }
        }
        return this;
    }

    private Runnable maybeAcceptAllCertificates(URL url) {
        if (!this.acceptAllCertificates || !url.getProtocol().equals("https")) {
            return null;
        }
        final SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Runnable(){

            @Override
            public void run() {
                HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
            }
        };
    }

    protected void connectionInitialized(URLConnection connection) {
    }

    public void disconnect() throws IOException {
        this.connection.getInputStream().close();
    }

    protected boolean isCancelled() {
        return this.context != null && this.context.isCancelling() || this.canceled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URLConnection getURLConnection(URL url, ConnectionPreparer connectionPreparer, boolean showProxyOnErrorCode) throws IOException, UserCanceledException {
        if (!Boolean.getBoolean(SYSPROP_NO_PROXY)) {
            if (!Boolean.getBoolean(SYSPROP_NO_PROXY_AUTO_DETECT) && !Boolean.getBoolean(SYSPROP_SHOW_PROXY_CONFIG)) {
                this.proxyHostInfo = ProxyHelper.getProxyHostInfo(url);
                proxyConfig.update(this.proxyHostInfo);
            } else {
                this.proxyHostInfo = null;
                proxyConfig.setProperties();
            }
        }
        HttpAuthenticator.setRequestHandler(this);
        while (true) {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                HttpURLConnection httpURLConnection;
                if (Boolean.getBoolean(SYSPROP_SHOW_PROXY_CONFIG)) {
                    System.setProperty(SYSPROP_SHOW_PROXY_CONFIG, "false");
                    System.setProperty(SYSPROP_NO_PROXY_AUTO_DETECT, "true");
                    this.askForProxyPassword();
                }
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("X-Client-Application", "install4j");
                connection.setConnectTimeout(Integer.getInteger(SYSPROP_CONNECT_TIMEOUT, this.connectTimeout));
                connection.setReadTimeout(Integer.getInteger(SYSPROP_INSTALL4J_READ_TIMEOUT, this.readTimeout));
                proxyConfig.updateConnection(connection);
                for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (key.isEmpty()) continue;
                    for (String value : values) {
                        if (value.isEmpty()) continue;
                        connection.addRequestProperty(key, value);
                    }
                }
                String cookies = System.getProperty("install4j.cookies");
                if (cookies != null && !this.requestHeaders.containsKey("Cookie")) {
                    connection.setRequestProperty("Cookie", cookies);
                }
                if (connectionPreparer != null) {
                    connectionPreparer.prepare(connection);
                }
                connection.connect();
                if (connection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)connection;
                    int responseCode = httpURLConnection.getResponseCode();
                    if (showProxyOnErrorCode && this.askForProxy && this.mode != 3 && responseCode / 200 != 1) {
                        throw new IOException();
                    }
                }
                if (!Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR) || !(connection instanceof HttpURLConnection)) return connection;
                httpURLConnection = (HttpURLConnection)connection;
                System.err.println("response code = " + httpURLConnection.getResponseCode());
                System.err.println("response message = " + httpURLConnection.getResponseMessage());
                System.err.println("header fields = " + httpURLConnection.getHeaderFields());
                return connection;
            }
            catch (SSLHandshakeException e) {
                throw e;
            }
            catch (IOException e) {
                if (this.handleProxyFailure(url, e)) continue;
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!this.handleProxyFailure(url, e)) throw e;
                continue;
            }
            break;
        }
    }

    private boolean handleProxyFailure(URL url, Exception e) throws IOException, UserCanceledException {
        ErrorHandlingMode errorHandlingMode;
        String host = url.getHost();
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            return false;
        }
        if (!proxyConfig.isProxySet() && proxyConfig.getHost().length() > 0) {
            proxyConfig.setProxySet(true);
            proxyConfig.setProperties();
            return true;
        }
        if (proxyConfig.shouldTrySavedValues()) {
            proxyConfig.applySavedValues();
            return true;
        }
        if (this.errorHandlingCallback != null && (errorHandlingMode = this.errorHandlingCallback.errorOccurred(e)) != null) {
            switch (errorHandlingMode) {
                case CANCEL: {
                    return false;
                }
                case RETRY: {
                    return true;
                }
            }
        }
        if (this.mode == 3 || !this.askForProxy) {
            return false;
        }
        proxyConfig.show(this.mode == 2, false);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
        return true;
    }

    public void askForProxyPassword() throws IOException, UserCanceledException {
        if (this.mode == 3 && System.getProperty("proxyAuthPassword") != null) {
            return;
        }
        if (this.mode == 3 || !this.askForProxy) {
            throw new IOException(Messages.getMessages().getString("ProxyPasswordRequired"));
        }
        proxyConfig.show(this.mode == 2, true);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public static interface ConnectionPreparer {
        public void prepare(URLConnection var1) throws IOException;
    }
}

