/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.components.TextSource;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.HtmlTextPane;
import com.install4j.runtime.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class HtmlDisplay
extends JPanel {
    private HtmlTextProvider htmlTextProvider;
    private HtmlTextPane htmlTextPane;
    private JScrollPane scpInfo;
    private String actualText;
    private boolean allRead = false;
    private Context context;

    public HtmlDisplay(HtmlTextProvider htmlTextProvider) {
        this.htmlTextProvider = htmlTextProvider;
        this.setupControls();
        this.setupEventHandlers();
        this.setupComponent();
    }

    public void setPreferredHeight(int preferredHeight) {
        this.scpInfo.setPreferredSize(new Dimension(100, preferredHeight));
    }

    public String getActualText() {
        return this.actualText;
    }

    public boolean isAllRead() {
        return this.allRead;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public HtmlTextPane getHtmlTextPane() {
        return this.htmlTextPane;
    }

    private void setupControls() {
        this.htmlTextPane = new HtmlTextPane();
        this.scpInfo = new JScrollPane(this.htmlTextPane);
        this.scpInfo.getViewport().setBackground(Color.WHITE);
    }

    private void setupEventHandlers() {
        this.scpInfo.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                HtmlDisplay.this.checkAllRead();
            }
        });
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scpInfo, "Center");
    }

    private void checkAllRead() {
        JScrollBar scrollBar = this.scpInfo.getVerticalScrollBar();
        if (scrollBar.getValue() + scrollBar.getModel().getExtent() == scrollBar.getMaximum()) {
            this.allRead = true;
        }
    }

    public void handleConsole(Console console) throws UserCanceledException {
        String originalText = StringUtil.formatTextWithoutHtmlTags(this.getOrLoadText());
        console.println();
        console.more(originalText);
        console.println();
        this.actualText = originalText;
    }

    public void updateText() {
        String newText = this.getOrLoadText();
        if (!newText.equals(this.actualText)) {
            this.actualText = newText;
            this.htmlTextPane.updateText(this.actualText);
            this.allRead = false;
            this.checkAllRead();
        }
    }

    private String getOrLoadText() {
        String originalText;
        if (this.htmlTextProvider.getTextSource() == TextSource.FILE) {
            originalText = InstallerUtil.loadFile(this.context.getExternalFile(this.htmlTextProvider.getDisplayedTextFile(), false), this.context.getLanguageId());
            if (originalText == null) {
                originalText = "";
            }
        } else {
            originalText = this.htmlTextProvider.getDisplayedText();
        }
        return InstallerVariables.replaceVariables(originalText, ReplacementMode.PLAIN, VariableErrorHandlingDescriptor.ALWAYS_IGNORE);
    }

    public static interface HtmlTextProvider {
        public TextSource getTextSource();

        public LocalizedExternalFile getDisplayedTextFile();

        public String getDisplayedText();
    }
}

