/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.beans.Anchor;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.IndexPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.wizard.StandardScreen;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ScreenEnvelope
extends StandardScreen
implements ActionCallback {
    private static final Icon ICON_WIZARD = GUIHelper.loadIcon("wizard.png");
    private static final Object ORIGINAL_SIZE = "originalSize";
    private static int nextId;
    private WizardScreenExecutor wizard;
    private Screen screen;
    private ScreenBeanConfig config;
    private FormPanel formPanel;
    private boolean lastForwardEnabled;
    private boolean lastPreviousEnabled;
    private Map<FormComponent, Boolean> formComponentToEnabledStatus = new HashMap<FormComponent, Boolean>();
    private JPanel lazyLoadWrapperPanel;

    public ScreenEnvelope(WizardScreenExecutor wizard, Screen screen, ScreenBeanConfig config) {
        super(wizard);
        this.wizard = wizard;
        this.screen = screen;
        this.config = config;
        this.init();
    }

    protected ScreenEnvelope(Screen screen) {
        super((WizardBase)null);
        this.screen = screen;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    protected void init() {
        this.setName(String.valueOf(nextId++));
        this.initFormPanel();
        this.initScreen();
    }

    protected void initFormPanel() {
        if (this.screen instanceof FormPanelContainer) {
            this.formPanel = this.createFormPanel();
            ((FormPanelContainer)((Object)this.screen)).setFormPanel(this.formPanel, this.formPanel.getFormEnvironment());
        }
    }

    protected FormPanel createFormPanel() {
        return new FormPanel(this.config.getFormComponentConfigs(), this.wizard.getContext(), this.isBannerPainted(), this.screen);
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public void actionsStarted() {
        this.lastForwardEnabled = this.getForwardButton().isEnabled();
        this.lastPreviousEnabled = this.getPreviousButton().isEnabled();
        final ArrayList<FormComponent> disabledComponents = new ArrayList<FormComponent>();
        if (this.formPanel != null) {
            FormComponent[] formComponents;
            for (FormComponent formComponent : formComponents = this.formPanel.getFormEnvironment().getFormComponents()) {
                if (!formComponent.hasUserInput()) continue;
                this.formComponentToEnabledStatus.put(formComponent, formComponent.isEnabled());
                disabledComponents.add(formComponent);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenEnvelope.this.getForwardButton().setEnabled(false);
                ScreenEnvelope.this.getPreviousButton().setEnabled(false);
                for (FormComponent disabledComponent : disabledComponents) {
                    disabledComponent.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void actionsFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenEnvelope.this.getForwardButton().setEnabled(ScreenEnvelope.this.lastForwardEnabled);
                ScreenEnvelope.this.getPreviousButton().setEnabled(ScreenEnvelope.this.lastPreviousEnabled);
                if (ScreenEnvelope.this.formPanel != null) {
                    for (Map.Entry entry : ScreenEnvelope.this.formComponentToEnabledStatus.entrySet()) {
                        ((FormComponent)entry.getKey()).setEnabled((Boolean)entry.getValue());
                    }
                    ScreenEnvelope.this.formComponentToEnabledStatus.clear();
                }
            }
        });
    }

    @Override
    public void activate() {
        this.initializeLazilyLoaded();
        this.applyConfiguredWizardIndex();
        ContextImpl context = this.wizard.getContext();
        context.runBooleanScript(this.config.getPreActivationClassName(), this.screen, this.createScriptParameters());
        this.screen.willActivate();
        if (this.formPanel != null) {
            this.formPanel.willActivate();
        }
        this.activateWizardIndex();
        this.updateTitleAndSubtitle();
        super.activate();
        this.screen.activated();
        if (this.formPanel != null) {
            this.formPanel.activated();
        }
        context.runBooleanScript(this.config.getPostActivationClassName(), this.screen, this.createScriptParameters());
    }

    public void initializeLazilyLoaded() {
        if (this.lazyLoadWrapperPanel != null) {
            this.lazyLoadWrapperPanel.add((Component)this.screen.createComponent(), "Center");
            this.lazyLoadWrapperPanel = null;
        }
    }

    private void applyConfiguredWizardIndex() {
        int wizardIndexChangeType = this.config.getWizardIndexChangeType();
        switch (wizardIndexChangeType) {
            case 4: {
                this.wizard.setWizardIndex(null);
                break;
            }
            case 3: {
                this.wizard.setWizardIndexKey(this.config.getWizardIndexKey());
                break;
            }
            case 2: {
                this.wizard.setWizardIndex(this.config.getWizardIndex());
            }
        }
    }

    private void activateWizardIndex() {
        String wizardIndexKey = this.wizard.getWizardIndexKey();
        WizardIndex wizardIndex = this.wizard.getWizardIndex();
        this.setIndexPanel(!this.screen.isShowIndex() || wizardIndex == null || wizardIndexKey == null ? null : new IndexPanel(wizardIndex, wizardIndexKey));
        this.wizard.cacheWizardIndexAndKey(this.screen);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.screen.deactivated();
        if (this.formPanel != null) {
            this.formPanel.deactivated();
        }
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.getForwardButton().setEnabled(enabled);
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        this.getPreviousButton().setEnabled(enabled);
    }

    public void setCancelButtonEnabled(boolean enabled) {
        this.getCancelButton().setEnabled(enabled);
    }

    public void setNextButtonVisible(boolean visible) {
        this.getForwardButton().setVisible(visible);
    }

    public void setPreviousButtonVisible(boolean visible) {
        this.getPreviousButton().setVisible(visible);
    }

    public void setCancelButtonVisible(boolean visible) {
        this.getCancelButton().setVisible(visible);
    }

    @Override
    protected boolean hasTitlePanel() {
        return this.screen.hasTitlePanel();
    }

    @Override
    protected boolean isBannerPainted() {
        return this.screen instanceof SystemScreen && ((SystemScreen)this.screen).isBannerPainted();
    }

    @Override
    protected Anchor getBannerImageAnchor() {
        if (this.screen instanceof SystemScreen) {
            return ((SystemScreen)this.screen).getBannerImageAnchor();
        }
        return Anchor.NORTH;
    }

    protected String getBannerImageFileName() {
        return this.screen instanceof SystemScreen ? ((SystemScreen)this.screen).getBannerImageFileName() : null;
    }

    @Override
    protected Color getBannerBackground() {
        Color bannerBackground;
        if (this.screen instanceof SystemScreen && (bannerBackground = ((SystemScreen)this.screen).getBannerBackground()) != null) {
            return bannerBackground;
        }
        return super.getBannerBackground();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.getPreviousButton()) {
            if (this.isEnabledAndVisible(this.getPreviousButton())) {
                this.doPrevious();
            }
        } else if (source == this.getForwardButton()) {
            if (this.isEnabledAndVisible(this.getForwardButton())) {
                this.doNext();
            }
        } else if (source == this.getCancelButton() && this.isEnabledAndVisible(this.getCancelButton())) {
            this.doCancel();
        }
    }

    private boolean isEnabledAndVisible(JButton button) {
        return button.isEnabled() && button.isVisible();
    }

    void doCancel() {
        if (this.screen.cancel()) {
            this.cancelWizard();
        }
    }

    void doNext() {
        if (this.screen.next() && this.checkFormCompleted()) {
            ControllerCommand storedCommand;
            boolean validated;
            this.wizard.getCommandSink().startStoreCommand();
            try {
                validated = this.wizard.getContext().runBooleanScript(this.config.getValidationClassName(), this.screen, this.createScriptParameters());
            }
            finally {
                storedCommand = this.wizard.getCommandSink().finishStoreCommand();
            }
            if (storedCommand != null) {
                this.wizard.getCommandSink().returnToController(storedCommand);
            } else if (validated) {
                if (this.isFinishScreen()) {
                    this.screen.deactivated();
                    this.wizard.getCommandSink().returnToController(new FinishCommand(this));
                } else {
                    this.wizard.getCommandSink().returnToController(new GoForwardCommand(1, true, true, this));
                }
            }
        }
    }

    private Object[] createScriptParameters() {
        Object[] scriptParameters = this.formPanel != null ? new Object[]{this.formPanel.getFormEnvironment()} : null;
        return scriptParameters;
    }

    void doPrevious() {
        if (this.screen.previous()) {
            if (this.formPanel != null) {
                this.formPanel.previous();
            }
            this.wizard.getCommandSink().returnToController(new GoBackCommand(1, true));
        }
    }

    protected void cancelWizard() {
        this.wizard.cancel();
    }

    private boolean checkFormCompleted() {
        return this.formPanel == null || this.formPanel.checkCompleted();
    }

    public boolean isFinishScreen() {
        return this.config == null || this.config.isFinishScreen();
    }

    public boolean isCancelVisible() {
        return this.screen.isCancelVisible() && !this.isFinishScreen();
    }

    @Override
    protected boolean supportsPrevious() {
        return !this.screen.isHidden() && !this.screen.isHiddenForPrevious();
    }

    @Override
    protected boolean supportsNext() {
        return !this.screen.isHidden() && !this.screen.isHiddenForNext();
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets.bottom = 5;
        gc.anchor = 23;
        gc.fill = 0;
        if (this.screen.isFillHorizontal()) {
            gc.fill = 2;
        }
        if (this.screen.isFillVertical()) {
            gc.fill = 3;
        }
        if (this.screen.isFillHorizontal() && this.screen.isFillVertical()) {
            gc.fill = 1;
        }
        Insets oldInsets = gc.insets;
        boolean defaultInsets = this.hasDefaultInsets();
        if (!defaultInsets) {
            gc.insets = new Insets(0, 0, 0, 0);
            panel.setBorder(null);
        }
        if (this.screen.isCreateLazily()) {
            this.lazyLoadWrapperPanel = new JPanel(new BorderLayout());
            this.lazyLoadWrapperPanel.setOpaque(false);
            panel.add((Component)this.lazyLoadWrapperPanel, gc);
        } else {
            panel.add((Component)this.screen.createComponent(), gc);
        }
        gc.insets = oldInsets;
        this.getPreviousButton().setVisible(this.screen.isPreviousVisible());
        this.getForwardButton().setVisible(this.screen.isNextVisible() || this.isFinishScreen());
        this.getCancelButton().setVisible(this.isCancelVisible());
        if (this.isFinishScreen()) {
            this.getForwardButton().setText(this.getMessages().getString("ButtonFinish"));
        }
    }

    private boolean hasDefaultInsets() {
        try {
            return this.screen.hasDefaultInsets();
        }
        catch (Throwable t) {
            return true;
        }
    }

    private boolean hasDefaultButtons() {
        try {
            return this.screen.hasDefaultButtons();
        }
        catch (Throwable t) {
            return true;
        }
    }

    @Override
    protected String getTitle() {
        return this.screen.getTitle();
    }

    @Override
    protected String getSubTitle() {
        return this.screen.getSubTitle();
    }

    @Override
    protected boolean needsSpacer() {
        return !this.screen.isFillVertical();
    }

    @Override
    protected boolean hasNavigationPanel() {
        return this.screen.hasDefaultButtons();
    }

    @Override
    protected Icon getBannerIcon() {
        Icon bannerIcon = ICON_WIZARD;
        String bannerIconFileName = this.getBannerImageFileName();
        if (bannerIconFileName != null) {
            try {
                bannerIcon = GUIHelper.loadIcon(InstallerUtil.getInstallerFile(bannerIconFileName));
                if (bannerIcon.getIconWidth() <= 0) {
                    return ICON_WIZARD;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return bannerIcon;
    }

    @Override
    protected Color getHeaderBackgroundColor() {
        return this.wizard.getHeaderBackgroundColor();
    }

    @Override
    protected Color getHeaderForegroundColor() {
        return this.wizard.getHeaderForegroundColor();
    }

    @Override
    protected Icon getHeaderIcon() {
        return this.wizard.getHeaderIcon();
    }

    @Override
    protected boolean isHeaderIconOverlap() {
        return this.wizard.isHeaderIconOverlap();
    }

    @Override
    protected Anchor getHeaderIconAnchor() {
        return this.wizard.getHeaderIconAnchor();
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }

    @Override
    protected JButton createCancelButton() {
        JButton button = new JButton(this.getMessages().getString("ButtonCancel"));
        button.setName("cancel");
        return button;
    }

    @Override
    protected JButton createForwardButton() {
        JButton button = new JButton(this.getMessages().getString("ButtonNext") + " >");
        button.setName("next");
        return button;
    }

    @Override
    protected JButton createPreviousButton() {
        JButton button = new JButton("< " + this.getMessages().getString("ButtonBack"));
        button.setName("back");
        return button;
    }

    public boolean isCancelButtonEnabled() {
        return this.getCancelButton().isEnabled();
    }

    @Override
    protected String getWatermarkText() {
        Application application = InstallerConfig.getCurrentApplication();
        if (this.isBannerPainted() || !application.isWatermark()) {
            return null;
        }
        String watermarkText = application.getCustomWatermarkText().trim();
        return watermarkText.length() == 0 ? "install4j " : watermarkText;
    }

    public void disarmButtons() {
        this.disarmButton(this.getForwardButton());
        this.disarmButton(this.getPreviousButton());
        this.disarmButton(this.getCancelButton());
    }

    private void disarmButton(JButton button) {
        button.getModel().setArmed(false);
        button.getModel().setPressed(false);
    }

    public void focusNextButton() {
        this.getForwardButton().requestFocus();
    }

    public void setNextButtonText(String text) {
        this.setButtonText(text, this.getForwardButton());
    }

    public void setPreviousButtonText(String text) {
        this.setButtonText(text, this.getPreviousButton());
    }

    public void setCancelButtonText(String text) {
        this.setButtonText(text, this.getCancelButton());
    }

    private void setButtonText(String text, JButton button) {
        Dimension originalSize = (Dimension)button.getClientProperty(ORIGINAL_SIZE);
        Dimension preferredSize = button.getPreferredSize();
        if (originalSize == null) {
            originalSize = (Dimension)preferredSize.clone();
            button.putClientProperty(ORIGINAL_SIZE, originalSize);
        }
        button.setPreferredSize(null);
        button.setText(text);
        preferredSize.width = Math.max(button.getPreferredSize().width, originalSize.width);
        button.setPreferredSize(preferredSize);
        button.setMinimumSize(preferredSize);
        button.setMaximumSize(preferredSize);
    }

    private void setIndexPanel(IndexPanel indexPanel) {
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof IndexPanel)) continue;
            this.remove(component);
            break;
        }
        if (indexPanel != null) {
            this.add((Component)indexPanel, "Before");
        }
    }
}

