/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.context.WizardIndex;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.MaximizedLayeredPane;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class IndexPanel
extends JPanel {
    private WizardIndex wizardIndex;
    private Font boldFont;
    private Font plainFont;

    public IndexPanel(WizardIndex wizardIndex, String key) {
        this.wizardIndex = wizardIndex;
        MaximizedLayeredPane layeredPane = new MaximizedLayeredPane();
        layeredPane.add((Component)this.createTextBox(key), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.createImagePanel(), JLayeredPane.DEFAULT_LAYER);
        this.setLayout(new BorderLayout());
        this.add((Component)layeredPane, "Center");
    }

    private JComponent createTextBox(String key) {
        Box box = new Box(3);
        String[] stepNames = AbstractBean.replaceVariables(this.wizardIndex.getStepNames());
        for (int i = 0; i < stepNames.length; ++i) {
            String stepName = stepNames[i];
            String labelText = (this.wizardIndex.isNumbered() ? String.valueOf(i + 1) + ". " : "") + stepName;
            boolean selected = AbstractBean.replaceVariables(this.wizardIndex.getKeys())[i].equals(key);
            box.add(this.createLabel(labelText, selected));
        }
        if (this.wizardIndex.isPartiallyDefined()) {
            box.add(this.createLabel("...", false));
        }
        box.add(Box.createVerticalGlue());
        box.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(GUIHelper.getSeparatorColor(), 1, 4), BorderFactory.createEmptyBorder(6, 6, 6, 4)));
        return box;
    }

    private JPanel createImagePanel() {
        JPanel backPanel = new JPanel(new GridBagLayout());
        backPanel.setBackground(this.getIndexBackground());
        backPanel.setOpaque(true);
        GridBagConstraints gc = new GridBagConstraints();
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.anchor = this.wizardIndex.getBackgroundImageAnchor().getValue();
        backPanel.add((Component)new JLabel(this.getIcon(this.wizardIndex.getBackgroundImage())), gc);
        return backPanel;
    }

    private JLabel createLabel(String labelText, boolean selected) {
        JLabel label = new JLabel(labelText);
        Font font = label.getFont();
        if (selected) {
            if (this.boldFont == null) {
                this.boldFont = font.deriveFont(1);
            }
            font = this.boldFont;
        } else if (font.isBold()) {
            if (this.plainFont == null) {
                this.plainFont = font.deriveFont(0);
            }
            font = this.plainFont;
        }
        label.setFont(font);
        Color foreground = this.wizardIndex.getForeground();
        if (foreground != null) {
            label.setForeground(foreground);
        }
        return label;
    }

    public Icon getIcon(File file) {
        if (file == null) {
            return null;
        }
        if (!file.isAbsolute()) {
            String fileName;
            if (file.getParent() == null && !(fileName = file.getName()).startsWith("i4j_extf_")) {
                file = new File("user", fileName);
            }
            file = InstallerUtil.getInstallerFile(file.getPath());
        }
        try {
            ImageIcon headerIcon = GUIHelper.loadIcon(file);
            if (headerIcon.getIconWidth() > 0) {
                return headerIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Color getIndexBackground() {
        Color background = this.wizardIndex.getBackground();
        return background == null ? Color.WHITE : background;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = Math.min(Math.max(size.width, this.wizardIndex.getMinWidth()), this.wizardIndex.getMaxWidth());
        return size;
    }
}

