/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.beans.ActionList;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.helper.InstallerUtil;

public class CommandSink {
    private ControllerCommand command;
    private ControllerCommand overrideCommand;
    private boolean allowOverride = false;
    private boolean store = false;
    private ControllerCommand storedCommand;
    private boolean finished = false;
    private Thread controllerThread;
    private Controller controller;

    public CommandSink(Controller controller) {
        this.controller = controller;
        this.controllerThread = Thread.currentThread();
    }

    public ControllerCommand getCommand() {
        return this.command;
    }

    public synchronized void returnToController(ControllerCommand command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (this.store) {
            this.storedCommand = command;
        } else if (this.command == null) {
            this.command = command;
            if (!this.controllerThread.isAlive() && command == ControllerCommand.CANCEL) {
                this.controller.rollback(this);
            } else {
                this.notifyAll();
            }
        } else if (this.allowOverride) {
            this.overrideCommand = command;
        }
    }

    public synchronized void finished() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void waitForFinish() {
        while (!this.finished && this.controllerThread.isAlive() && !InstallerUtil.isExiting()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ControllerCommand getOverriddenCommand() {
        return this.overrideCommand != null ? this.overrideCommand : this.command;
    }

    public synchronized void allowOverride() {
        this.allowOverride = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void startStoreCommand() {
        this.store = true;
        this.storedCommand = null;
    }

    public synchronized ControllerCommand finishStoreCommand() {
        this.store = false;
        ControllerCommand ret = this.storedCommand;
        this.storedCommand = null;
        return ret;
    }

    public boolean executeActionList(ActionList actionList) throws UserCanceledException {
        return this.controller.executeActionList(actionList);
    }

    public boolean isExecutingActions() {
        return this.controller.isExecutingActions();
    }

    public void rollbackActionList(ActionList actionList) {
        this.controller.rollbackActionList(actionList);
    }
}

