/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.context.FileOptions;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.ApplicationBeanConfig;
import com.install4j.runtime.installer.config.Bitness;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.FileOptionsConfig;
import com.install4j.runtime.installer.config.FilesetConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.LegacyUninstallerBeanConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.config.RootConfig;
import com.install4j.runtime.installer.config.ScriptClassOrigin;
import com.install4j.runtime.installer.config.UnixSpecificConfig;
import com.install4j.runtime.installer.config.WindowsSpecificConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.apiimpl.ApplicationRegistryImpl;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstallerConfig
extends AbstractConfig {
    private static String currentApplicationId = null;
    private static Application currentApplication = null;
    private static InstallerConfig currentConfig = null;
    private String install4jVersion = "";
    private String install4jBuild = "";
    private String type;
    private boolean archive;
    private String applicationName = "";
    private String applicationVersion = "";
    private String defaultInstallationDirectory = "";
    private boolean jreShared = false;
    private String jreVersion = "";
    private Map<String, ApplicationBeanConfig> applicationIdToConfig = new HashMap<String, ApplicationBeanConfig>();
    private Map<String, ScriptClassOrigin> classNameToScriptClassOrigin = new HashMap<String, ScriptClassOrigin>();
    private List<FilesetConfig> filesets = Collections.emptyList();
    private List<ComponentConfig> components = Collections.emptyList();
    private ComponentFolderConfig componentRoot = new ComponentFolderConfig(null);
    private List<LauncherConfig> launchers = Collections.emptyList();
    private List<String> uninstallDeleteEntries;
    private String minJavaVersion = "";
    private String publisherName = "";
    private String publisherURL = "";
    private String mediaName = "";
    private String mediaSetId = "";
    private String uninstallerPath = "uninstall";
    private String uninstallerDirectory = ".";
    private String projectCrc;
    private File installationDirectory;
    private String downloadURL = "";
    private List<String> customJars = Collections.emptyList();
    private String status = "";
    private List<LanguageConfig> languages = Collections.emptyList();
    private boolean skipLanguageSelection = false;
    private boolean languageSelectionInPrincipalLanguage = false;
    private Map<String, String> compilerVariables = Collections.emptyMap();
    private Map<String, RootConfig> externalRoots = Collections.emptyMap();
    private String applicationId = "";
    private int installerType;
    private String addonAppId = "";
    private boolean suggestPreviousLocations = true;
    private boolean lzmaCompression = false;
    private boolean pack200Compression = false;
    private Bitness bitness = Bitness.UNDEFINED;
    private FileOptionsConfig fileOptionsConfig = new FileOptionsConfig();
    private WindowsSpecificConfig windowsSpecificConfig = new WindowsSpecificConfig();
    private MacSpecificConfig macSpecificConfig = new MacSpecificConfig();
    private UnixSpecificConfig unixSpecificConfig = new UnixSpecificConfig();
    private boolean readGeneralOnly;

    public static void setCurrentApplicationId(String currentApplicationId) {
        if (InstallerConfig.currentApplicationId != null) {
            throw new IllegalStateException();
        }
        InstallerConfig.currentApplicationId = currentApplicationId;
        if (currentConfig == null) {
            try {
                currentConfig = new InstallerConfig(InstallerUtil.getInstallerFile("i4jparams.conf"), false);
            }
            catch (IOException e) {
                Util.showMessage("Internal error: Could not open config file.", 0);
                InstallerUtil.exit(1);
            }
        }
        try {
            currentApplication = currentConfig.getApplicationById(currentApplicationId);
        }
        catch (Exception e) {
            Util.showMessage("Internal error: The selected application could not be instantiated.", 0);
            InstallerUtil.exit(1);
        }
        if (currentApplication == null) {
            Util.showMessage("Internal error: The selected application " + currentApplicationId + " could not be instantiated.", 0);
            InstallerUtil.exit(1);
        }
    }

    public static void clearCurrentApplication() {
        currentApplicationId = null;
        currentApplication = null;
        currentConfig = null;
    }

    public static Map<String, String> readVariables(Element element) {
        return InstallerConfig.readVariables(element, null);
    }

    public static Map<String, String> readVariables(Element element, XmlHelper.XmlElementVisitor visitor) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Element variableElement : InstallerConfig.childElements(element)) {
            String name = InstallerConfig.readAttribute(variableElement, "name", (String)null);
            String value = InstallerConfig.readAttribute(variableElement, "value", (String)null);
            if (name == null) continue;
            if (visitor != null) {
                visitor.visit(variableElement);
            }
            if (value == null) continue;
            variables.put(name, value);
        }
        return Collections.unmodifiableMap(variables);
    }

    public static InstallerConfig getCurrentInstance() {
        return currentConfig;
    }

    public static Application getCurrentApplication() {
        return currentApplication;
    }

    public static String getCurrentApplicationId() {
        return currentApplicationId;
    }

    public static boolean isInstaller() {
        return currentApplicationId.equals("installer");
    }

    public static boolean isUninstaller() {
        return currentApplicationId.equals("uninstaller");
    }

    public static InstallerConfig getGeneralConfigFromFile(File configFile) throws IOException {
        return new InstallerConfig(configFile, true);
    }

    public static InstallerConfig getConfigFromFile(File configFile) throws IOException {
        return new InstallerConfig(configFile, false);
    }

    private InstallerConfig(File configFile, boolean readGeneralOnly) throws IOException {
        this.readGeneralOnly = readGeneralOnly;
        Document document = XmlHelper.parseFile(configFile);
        this.read(document.getDocumentElement());
        CRC32 crc = new CRC32();
        crc.update(this.getApplicationId().getBytes("UTF-8"));
        this.projectCrc = Long.toString(crc.getValue(), 36);
    }

    public String getInstall4jVersion() {
        return this.install4jVersion;
    }

    public String getInstall4jBuild() {
        return this.install4jBuild;
    }

    public String getProjectCrc() {
        return this.projectCrc;
    }

    public String getMediaSetId() {
        return this.mediaSetId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean isLzmaCompression() {
        return this.lzmaCompression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public boolean isJreShared() {
        return this.jreShared;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getApplicationName() {
        return InstallerVariables.replaceVariables(this.applicationName);
    }

    public String getApplicationNameWithVersion() {
        String ret = this.getApplicationName();
        if (this.getApplicationVersion().trim().length() > 0 && !this.getApplicationName().contains(this.getApplicationVersion())) {
            ret = ret + " " + this.getApplicationVersion();
        }
        return ret;
    }

    public File getInstallationDirectory() {
        HelperCommunication.helperUnsupported();
        if (this.installationDirectory == null) {
            this.installationDirectory = this.getInitialInstallationDirectory();
        }
        return this.installationDirectory;
    }

    public void setInstallationDirectory(File installationDirectory) {
        if (!installationDirectory.isAbsolute()) {
            try {
                installationDirectory = new File(InstallerVariables.getMediaDir(), installationDirectory.getPath()).getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        this.installationDirectory = installationDirectory;
    }

    private File getInitialInstallationDirectory() {
        if (this.isSuggestPreviousLocations()) {
            try {
                String targetApplicationId = this.getTargetApplicationId();
                String previousLocation = InstallRegistry.getInstallationDir(targetApplicationId);
                if (previousLocation != null && previousLocation.trim().length() > 0) {
                    String singleBundleName = InstallRegistry.getSingleBundleName(targetApplicationId, previousLocation);
                    File possibleTargetDir = new File(previousLocation);
                    if (Util.isMacosInstaller() && this.isAddOnInstaller() && singleBundleName != null) {
                        possibleTargetDir = new File(possibleTargetDir, singleBundleName + "/" + "Contents/Resources/app");
                    }
                    if (Util.isMacosInstaller() && (!this.getMacSpecificConfig().isSingleBundle() && singleBundleName != null || this.getMacSpecificConfig().isSingleBundle() && singleBundleName == null)) {
                        return this.getDefaultResolvedInstallationDirectory();
                    }
                    if (new File(previousLocation).getParentFile() == null) {
                        return this.getDefaultResolvedInstallationDirectory();
                    }
                    if (Boolean.getBoolean("install4j.noPreviousExistenceCheck")) {
                        return possibleTargetDir;
                    }
                    ApplicationRegistryImpl.ApplicationInfoImpl applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(new File(previousLocation + (singleBundleName != null ? "/" + singleBundleName : "")));
                    if (applicationInfo != null && targetApplicationId.equals(applicationInfo.getId())) {
                        if (Boolean.getBoolean("install4j.noPreviousBitnessCheck")) {
                            return possibleTargetDir;
                        }
                        if (applicationInfo.getBitness().isCompatible()) {
                            return possibleTargetDir;
                        }
                        Logger.getInstance().info(null, "bitness " + applicationInfo.getBitness() + " from " + previousLocation + " is not compatible");
                        return this.getDefaultResolvedInstallationDirectory();
                    }
                }
            }
            catch (Throwable t) {
                Logger.getInstance().log(t);
            }
        }
        return this.getDefaultResolvedInstallationDirectory();
    }

    public File getDefaultResolvedInstallationDirectory() {
        int varEndPos;
        int varStartPos;
        String initialInstallationDir = StringUtil.replaceHomeDir(this.defaultInstallationDirectory);
        while ((varStartPos = initialInstallationDir.indexOf(123)) > -1 && (varEndPos = initialInstallationDir.indexOf(125, varStartPos)) >= 0) {
            String variable = initialInstallationDir.substring(varStartPos, varEndPos + 1);
            initialInstallationDir = initialInstallationDir.substring(0, varStartPos) + InstallerConfig.getVariableValue(variable) + initialInstallationDir.substring(varEndPos + 1);
        }
        return new File(initialInstallationDir);
    }

    private static String getVariableValue(String variableName) {
        if (variableName.equals("{/}")) {
            return File.separator;
        }
        if (variableName.equals("{appdir}")) {
            return InstallerUtil.getStandardApplicationsDirectory();
        }
        return "";
    }

    public List<AbstractBeanConfig> getApplicationScreens() {
        ApplicationBeanConfig applicationConfig = this.getApplicationConfigById(currentApplicationId);
        if (applicationConfig == null) {
            return Collections.emptyList();
        }
        return applicationConfig.getScreenConfigs();
    }

    public InstallerApplication getInstallerApplication() {
        return (InstallerApplication)this.getApplicationById("installer");
    }

    public UninstallerApplication getUninstallerApplication() {
        return (UninstallerApplication)this.getApplicationById("uninstaller");
    }

    public Application getApplicationById(String id) {
        ApplicationBeanConfig applicationConfig = this.getApplicationConfigById(id);
        if (applicationConfig != null) {
            return applicationConfig.getOrInstantiateApplication(false);
        }
        return null;
    }

    public ApplicationBeanConfig getApplicationConfigById(String id) {
        return this.applicationIdToConfig.get(id);
    }

    public ApplicationBeanConfig getCurrentApplicationConfig() {
        return this.applicationIdToConfig.get(currentApplicationId);
    }

    public Map<String, ScriptClassOrigin> getClassNameToScriptClassOrigin() {
        return this.classNameToScriptClassOrigin;
    }

    public String getPublisherName() {
        return InstallerVariables.replaceVariables(this.publisherName);
    }

    public String getPublisherURL() {
        return InstallerVariables.replaceVariables(this.publisherURL);
    }

    public String getDownloadURL() {
        return InstallerVariables.replaceVariables(this.downloadURL);
    }

    public String getStatus() {
        return this.status;
    }

    public List<FilesetConfig> getFilesets() {
        return this.filesets;
    }

    public List<ComponentConfig> getComponents() {
        return this.components;
    }

    public ComponentConfig getComponentById(String id) {
        for (ComponentConfig componentConfig : this.components) {
            if (!componentConfig.getId().equals(id)) continue;
            return componentConfig;
        }
        return null;
    }

    public ComponentNodeConfig getComponentNodeById(String id) {
        return this.getComponentNodeById(id, this.componentRoot);
    }

    private ComponentNodeConfig getComponentNodeById(String id, ComponentFolderConfig componentFolderConfig) {
        for (ComponentNodeConfig componentNodeConfig : componentFolderConfig.getComponents()) {
            ComponentNodeConfig result;
            if (componentNodeConfig.getId().equals(id)) {
                return componentNodeConfig;
            }
            if (!(componentNodeConfig instanceof ComponentFolderConfig) || (result = this.getComponentNodeById(id, (ComponentFolderConfig)componentNodeConfig)) == null) continue;
            return result;
        }
        return null;
    }

    public ComponentFolderConfig getComponentRoot() {
        return this.componentRoot;
    }

    public List<LauncherConfig> getLaunchers() {
        return this.launchers;
    }

    public LauncherConfig getLauncherConfigById(String id) {
        for (LauncherConfig launcherConfig : this.launchers) {
            if (!launcherConfig.getId().equals(id) && !launcherConfig.getDisplayedId().equals(id)) continue;
            return launcherConfig;
        }
        return null;
    }

    public Bitness getBitness() {
        return this.bitness;
    }

    public List<String> getUninstallDeleteEntries() {
        return this.uninstallDeleteEntries;
    }

    public FileOptions getOptions(String fileName) {
        return this.fileOptionsConfig.getOptions(fileName);
    }

    public FileOptionsConfig getFileOptionsConfig() {
        return this.fileOptionsConfig;
    }

    public WindowsSpecificConfig getWindowsSpecificConfig() {
        return this.windowsSpecificConfig;
    }

    public MacSpecificConfig getMacSpecificConfig() {
        return this.macSpecificConfig;
    }

    public UnixSpecificConfig getUnixSpecificConfig() {
        return this.unixSpecificConfig;
    }

    public List<LanguageConfig> getLanguages() {
        return this.languages;
    }

    public boolean isSkipLanguageSelection() {
        return this.skipLanguageSelection;
    }

    public boolean isLanguageSelectionInPrincipalLanguage() {
        return this.languageSelectionInPrincipalLanguage;
    }

    public LanguageConfig getLanguageById(String languageId) {
        for (LanguageConfig languageConfig : this.languages) {
            if (!languageConfig.getId().equals(languageId)) continue;
            return languageConfig;
        }
        int underscoreIndex = languageId.indexOf(95);
        if (underscoreIndex > -1) {
            return this.getLanguageById(languageId.substring(0, underscoreIndex));
        }
        return null;
    }

    public Map<String, String> getCompilerVariables() {
        return this.compilerVariables;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getInstallerType() {
        return this.installerType;
    }

    public String getAddonAppId() {
        return this.addonAppId;
    }

    public void setAddonAppId(String addonAppId) {
        this.addonAppId = addonAppId;
    }

    public boolean isSuggestPreviousLocations() {
        return this.suggestPreviousLocations;
    }

    public boolean isPack200Compression() {
        return this.pack200Compression;
    }

    public List<String> getCustomJars() {
        return this.customJars;
    }

    public String getUninstallerPath() {
        return this.uninstallerPath;
    }

    public String getUninstallerDirectory() {
        return this.uninstallerDirectory;
    }

    @Override
    protected void read(Element rootElement) {
        this.install4jVersion = InstallerConfig.readAttribute(rootElement, "install4jVersion", this.install4jVersion);
        this.install4jBuild = InstallerConfig.readAttribute(rootElement, "install4jBuild", this.install4jBuild);
        this.type = InstallerConfig.readAttribute(rootElement, "type", this.type);
        this.archive = InstallerConfig.readAttribute(rootElement, "archive", this.archive);
        this.bitness = this.readAttribute(rootElement, "bitness", this.bitness);
        Element generalElement = null;
        for (Element element : InstallerConfig.childElements(rootElement)) {
            String elementName = element.getTagName();
            if (elementName.equals("general")) {
                generalElement = element;
                this.readGeneral(element);
            } else if (elementName.equals("compilerVariables")) {
                this.compilerVariables = InstallerConfig.readVariables(element);
            }
            if (this.readGeneralOnly) continue;
            if (elementName.equals("languages")) {
                this.readLanguages(element);
                continue;
            }
            if (elementName.equals("externalRoots")) {
                this.readRoots(element);
                continue;
            }
            if (elementName.equals("customCode")) {
                this.readCustomCode(element);
                continue;
            }
            if (elementName.equals("applications")) {
                this.readScreens(element);
                continue;
            }
            if (elementName.equals("scriptClassOrigins")) {
                this.readScriptClassOrigins(element);
                continue;
            }
            if (elementName.equals("fileOptions")) {
                this.fileOptionsConfig.read(element);
                continue;
            }
            if (elementName.equals("filesets")) {
                this.readFilesets(element);
                continue;
            }
            if (elementName.equals("components")) {
                this.readComponents(element);
                continue;
            }
            if (elementName.equals("launchers")) {
                this.readLaunchers(element);
                continue;
            }
            if (elementName.equals("uninstallDelete")) {
                this.readUninstallDelete(element);
                continue;
            }
            if (elementName.equals("windowsSpecific")) {
                this.windowsSpecificConfig.read(element);
                continue;
            }
            if (elementName.equals("macSpecific")) {
                this.macSpecificConfig.read(element);
                continue;
            }
            if (elementName.equals("unixSpecific")) {
                this.unixSpecificConfig.read(element);
                continue;
            }
            if (!elementName.equals("uninstallerScreens")) continue;
            this.readLegacyUninstallerScreens(element, generalElement);
        }
    }

    private void readLegacyUninstallerScreens(Element element, Element generalElement) {
        LegacyUninstallerBeanConfig applicationConfig = new LegacyUninstallerBeanConfig(generalElement);
        ((ApplicationBeanConfig)applicationConfig).read(element);
        this.applicationIdToConfig.put(applicationConfig.getId(), applicationConfig);
    }

    private void readCustomCode(Element element) {
        LinkedList<String> customJars = new LinkedList<String>();
        for (Element variableElement : InstallerConfig.childElements(element)) {
            String name = InstallerConfig.readAttribute(variableElement, "name", (String)null);
            if (name == null) continue;
            customJars.add(name);
        }
        this.customJars = Collections.unmodifiableList(customJars);
    }

    private void readGeneral(Element element) {
        this.applicationName = InstallerConfig.readAttribute(element, "applicationName", this.applicationName);
        this.defaultInstallationDirectory = InstallerConfig.readAttribute(element, "defaultInstallationDirectory", this.defaultInstallationDirectory);
        this.status = InstallerConfig.readAttribute(element, "status", this.status);
        this.jreShared = InstallerConfig.readAttribute(element, "jreShared", this.jreShared);
        this.jreVersion = InstallerConfig.readAttribute(element, "jreVersion", this.jreVersion);
        this.minJavaVersion = InstallerConfig.readAttribute(element, "minJavaVersion", this.minJavaVersion);
        this.publisherName = InstallerConfig.readAttribute(element, "publisherName", this.publisherName);
        this.publisherURL = InstallerConfig.readAttribute(element, "publisherURL", this.publisherURL);
        this.mediaName = InstallerConfig.readAttribute(element, "mediaName", this.mediaName);
        this.applicationVersion = InstallerConfig.readAttribute(element, "applicationVersion", this.applicationVersion);
        this.lzmaCompression = InstallerConfig.readAttribute(element, "lzmaCompression", this.lzmaCompression);
        this.pack200Compression = InstallerConfig.readAttribute(element, "pack200Compression", this.pack200Compression);
        this.downloadURL = InstallerConfig.readAttribute(element, "downloadURL", this.downloadURL);
        this.mediaSetId = InstallerConfig.readAttribute(element, "mediaSetId", this.mediaSetId);
        this.applicationId = InstallerConfig.readAttribute(element, "applicationId", this.applicationId);
        this.installerType = InstallerConfig.readAttribute(element, "installerType", this.installerType);
        this.addonAppId = InstallerConfig.readAttribute(element, "addOnAppId", this.addonAppId);
        this.suggestPreviousLocations = InstallerConfig.readAttribute(element, "suggestPreviousLocations", this.suggestPreviousLocations);
        this.uninstallerPath = InstallerConfig.readFileAttribute(element, "uninstallerFilename", this.uninstallerPath);
        this.uninstallerDirectory = InstallerConfig.readFileAttribute(element, "uninstallerDirectory", this.uninstallerPath);
    }

    private void readLanguages(Element element) {
        this.skipLanguageSelection = InstallerConfig.readAttribute(element, "skipLanguageSelection", this.skipLanguageSelection);
        this.languageSelectionInPrincipalLanguage = InstallerConfig.readAttribute(element, "languageSelectionInPrincipalLanguage", this.languageSelectionInPrincipalLanguage);
        LinkedList<LanguageConfig> languages = new LinkedList<LanguageConfig>();
        for (Element languageElement : InstallerConfig.childElements(element)) {
            LanguageConfig languageConfig = new LanguageConfig();
            languageConfig.read(languageElement);
            languages.add(languageConfig);
        }
        this.languages = Collections.unmodifiableList(languages);
    }

    private void readRoots(Element element) {
        this.externalRoots = new HashMap<String, RootConfig>();
        for (Element rootElement : InstallerConfig.childElements(element)) {
            RootConfig rootConfig = new RootConfig();
            rootConfig.read(rootElement);
            this.externalRoots.put(rootConfig.getId(), rootConfig);
        }
    }

    private void readScreens(Element element) {
        for (Element applicationElement : InstallerConfig.childElements(element)) {
            ApplicationBeanConfig applicationConfig = new ApplicationBeanConfig();
            applicationConfig.read(applicationElement);
            String prefix = "";
            if (applicationConfig.getIdNamespace().length() > 0) {
                prefix = applicationConfig.getIdNamespace() + ":";
            }
            String id = applicationConfig.getId();
            String displayedId = applicationConfig.getDisplayedId();
            this.applicationIdToConfig.put(prefix + id, applicationConfig);
            if (id.equals(displayedId)) continue;
            this.applicationIdToConfig.put(prefix + displayedId, applicationConfig);
        }
    }

    private void readScriptClassOrigins(Element element) {
        this.classNameToScriptClassOrigin.clear();
        for (Element scriptClassOriginElement : InstallerConfig.childElements(element)) {
            ScriptClassOrigin scriptClassOrigin = new ScriptClassOrigin();
            scriptClassOrigin.read(scriptClassOriginElement);
            this.classNameToScriptClassOrigin.put(scriptClassOrigin.getClassName(), scriptClassOrigin);
        }
    }

    private void readUninstallDelete(Element element) {
        ArrayList<String> uninstallDeleteEntries = new ArrayList<String>();
        for (Element entryElement : InstallerConfig.childElements(element)) {
            String fileName = InstallerConfig.readAttribute(entryElement, "name", "");
            if (fileName.equals("")) continue;
            uninstallDeleteEntries.add(fileName);
        }
        this.uninstallDeleteEntries = Collections.unmodifiableList(uninstallDeleteEntries);
    }

    private void readFilesets(Element element) {
        this.filesets = new LinkedList<FilesetConfig>();
        for (Element filesetElement : InstallerConfig.childElements(element)) {
            FilesetConfig filesetConfig = new FilesetConfig();
            filesetConfig.read(filesetElement);
            this.filesets.add(filesetConfig);
        }
    }

    private void readComponents(Element element) {
        LinkedList<ComponentConfig> components = new LinkedList<ComponentConfig>();
        this.componentRoot.read(element);
        this.collectComponents(this.componentRoot.getComponents(), components);
        this.components = Collections.unmodifiableList(components);
        for (ComponentConfig componentConfig : components) {
            componentConfig.notifyDependentComponents(this);
        }
    }

    private void collectComponents(List<ComponentNodeConfig> componentNodes, List<ComponentConfig> components) {
        for (ComponentNodeConfig componentNodeConfig : componentNodes) {
            if (componentNodeConfig instanceof ComponentConfig) {
                components.add((ComponentConfig)componentNodeConfig);
                continue;
            }
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.collectComponents(((ComponentFolderConfig)componentNodeConfig).getComponents(), components);
        }
    }

    private void readLaunchers(Element element) {
        LinkedList<LauncherConfig> launchers = new LinkedList<LauncherConfig>();
        for (Element entryElement : InstallerConfig.childElements(element)) {
            String elementName = entryElement.getTagName();
            if (!elementName.equals("launcher")) {
                return;
            }
            LauncherConfig launcherConfig = new LauncherConfig();
            launcherConfig.read(entryElement);
            launchers.add(launcherConfig);
        }
        this.launchers = Collections.unmodifiableList(launchers);
    }

    public String getTargetApplicationId() {
        if (this.isAddOnInstaller()) {
            return this.getAddonAppId();
        }
        return this.getApplicationId();
    }

    public String getFilesetForRootId(String rootId) {
        if (rootId.length() == 0) {
            return "";
        }
        RootConfig rootConfig = this.getRootById(rootId);
        return rootConfig.getFileset();
    }

    public RootConfig getRootById(String rootId) {
        return this.externalRoots.get(rootId);
    }

    public boolean isAddOnInstaller() {
        return this.installerType == 2;
    }
}

