/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LinkBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.config.LinkScreenBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class ApplicationBeanConfig
extends AbstractBeanConfig {
    protected Application instance;
    private Map<String, String> installerVariables;
    protected List<AbstractBeanConfig> screenConfigs;
    private Map<String, AbstractBeanConfig> id2BeanConfig;
    private HashSet<String> hiddenVariableNames;
    private Set<String> responseFileVariableNames;
    private Map<String, String> responseFileComments;

    public Application getOrInstantiateApplication(boolean suppressErrors) {
        if (this.instance == null) {
            this.instance = (Application)this.instantiateBean(suppressErrors);
        }
        return this.instance;
    }

    @Override
    public boolean isInstantiated() {
        return this.instance != null;
    }

    public List<AbstractBeanConfig> getScreenConfigs() {
        return this.screenConfigs;
    }

    public Map<String, String> getInstallerVariables() {
        return this.installerVariables;
    }

    public HashSet<String> getHiddenVariableNames() {
        return this.hiddenVariableNames;
    }

    public Set<String> getResponseFileVariableNames() {
        return this.responseFileVariableNames;
    }

    public Map<String, String> getResponseFileComments() {
        return this.responseFileComments;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.hiddenVariableNames = new HashSet();
        this.responseFileVariableNames = new HashSet<String>();
        this.responseFileComments = new HashMap<String, String>();
        this.installerVariables = InstallerConfig.readVariables(ApplicationBeanConfig.findChild(element, "variables"), new XmlHelper.XmlElementVisitor(){

            @Override
            public void visit(Element variableElement) {
                String comment;
                String name = VariableEncoding.getRealVariableName(AbstractConfig.readAttribute(variableElement, "name", (String)null));
                if (AbstractConfig.readAttribute(variableElement, "hidden", false)) {
                    ApplicationBeanConfig.this.hiddenVariableNames.add(name);
                }
                if (AbstractConfig.readAttribute(variableElement, "registerForResponseFile", false)) {
                    ApplicationBeanConfig.this.responseFileVariableNames.add(name);
                }
                if (!(comment = AbstractConfig.readAttribute(variableElement, "responseFileComment", "")).isEmpty()) {
                    ApplicationBeanConfig.this.responseFileComments.put(name, comment);
                }
            }
        });
        this.screenConfigs = Collections.unmodifiableList(this.readScreenConfigs(ApplicationBeanConfig.findChild(element, "screens")));
    }

    public Map getId2BeanConfig() {
        return this.id2BeanConfig;
    }

    /*
     * WARNING - void declaration
     */
    protected final List<AbstractBeanConfig> readScreenConfigs(Element screensElement) {
        LinkedList<AbstractBeanConfig> screenConfigs = new LinkedList<AbstractBeanConfig>();
        this.id2BeanConfig = new HashMap<String, AbstractBeanConfig>();
        for (Element beanElement : ApplicationBeanConfig.childElements(screensElement)) {
            void var6_6;
            AbstractBeanConfig beanConfig;
            String beanElementName = beanElement.getTagName();
            if (beanElementName.equalsIgnoreCase("screen")) {
                beanConfig = new ScreenBeanConfig();
            } else if (beanElementName.equalsIgnoreCase("group")) {
                beanConfig = new GroupBeanConfig(true);
            } else {
                if (!beanElementName.equalsIgnoreCase("link")) continue;
                beanConfig = ApplicationBeanConfig.readAttribute(beanElement, "group", false) ? new LinkGroupBeanConfig(true) : new LinkScreenBeanConfig();
            }
            var6_6.read(beanElement);
            screenConfigs.add((AbstractBeanConfig)var6_6);
            var6_6.addAllTo(this.id2BeanConfig);
        }
        for (AbstractBeanConfig beanConfig : this.id2BeanConfig.values()) {
            if (!(beanConfig instanceof LinkBeanConfig)) continue;
            ((LinkBeanConfig)((Object)beanConfig)).setDelegate(this.id2BeanConfig);
        }
        return screenConfigs;
    }
}

